/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.logs;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.log4j.Level;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.rest.models.system.loggers.responses.LoggersSummary;
import org.graylog2.rest.models.system.loggers.responses.SingleLoggerSummary;
import org.graylog2.rest.models.system.loggers.responses.SingleSubsystemSummary;
import org.graylog2.rest.models.system.loggers.responses.SubsystemSummary;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/Loggers", description="Internal Graylog loggers")
@Path(value="/system/loggers")
public class LoggersResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(LoggersResource.class);
    private static final Map<String, Subsystem> SUBSYSTEMS = ImmutableMap.of((Object)"graylog2", (Object)new Subsystem("Graylog2", "org.graylog2", "All messages from graylog2-owned systems."), (Object)"indexer", (Object)new Subsystem("Indexer", "org.elasticsearch", "All messages related to indexing and searching."), (Object)"authentication", (Object)new Subsystem("Authentication", "org.apache.shiro", "All user authentication messages."), (Object)"sockets", (Object)new Subsystem("Sockets", "netty", "All messages related to socket communication."));

    @GET
    @Timed
    @ApiOperation(value="List all loggers and their current levels")
    @Produces(value={"application/json"})
    public LoggersSummary loggers() {
        HashMap loggerList = Maps.newHashMap();
        Enumeration loggers = org.apache.log4j.Logger.getRootLogger().getLoggerRepository().getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            org.apache.log4j.Logger logger = (org.apache.log4j.Logger)loggers.nextElement();
            if (!this.isPermitted("loggers:read", logger.getName())) continue;
            loggerList.put(logger.getName(), SingleLoggerSummary.create((String)logger.getEffectiveLevel().toString().toLowerCase(), (int)logger.getEffectiveLevel().getSyslogEquivalent()));
        }
        return LoggersSummary.create((Map)loggerList);
    }

    @GET
    @Timed
    @Path(value="/subsystems")
    @ApiOperation(value="List all logger subsystems and their current levels")
    @Produces(value={"application/json"})
    public SubsystemSummary subsystems() {
        HashMap subsystems = Maps.newHashMap();
        for (Map.Entry<String, Subsystem> subsystem : SUBSYSTEMS.entrySet()) {
            if (!this.isPermitted("loggers:readsubsystem", subsystem.getKey())) continue;
            try {
                Level effectiveLevel = org.apache.log4j.Logger.getLogger((String)subsystem.getValue().getCategory()).getEffectiveLevel();
                subsystems.put(subsystem.getKey(), SingleSubsystemSummary.create((String)subsystem.getValue().getTitle(), (String)subsystem.getValue().getCategory(), (String)subsystem.getValue().getDescription(), (String)effectiveLevel.toString().toLowerCase(), (int)effectiveLevel.getSyslogEquivalent()));
            }
            catch (Exception e) {
                LOG.warn("Error while listing logger subsystem.", (Throwable)e);
            }
        }
        return SubsystemSummary.create((Map)subsystems);
    }

    @PUT
    @Timed
    @ApiOperation(value="Set the loglevel of a whole subsystem", notes="Provided level is falling back to DEBUG if it does not exist")
    @ApiResponses(value={@ApiResponse(code=404, message="No such subsystem.")})
    @Path(value="/subsystems/{subsystem}/level/{level}")
    public void setSubsystemLoggerLevel(@ApiParam(name="subsystem", required=true) @PathParam(value="subsystem") String subsystemTitle, @ApiParam(name="level", required=true) @PathParam(value="level") String level) {
        if (!SUBSYSTEMS.containsKey(subsystemTitle)) {
            LOG.warn("No such subsystem: [{}]. Returning 404.", (Object)subsystemTitle);
            throw new NotFoundException();
        }
        this.checkPermission("loggers:editsubsystem", subsystemTitle);
        Subsystem subsystem = SUBSYSTEMS.get(subsystemTitle);
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)subsystem.getCategory());
        Level newLevel = Level.toLevel((String)level.toUpperCase());
        logger.setLevel(newLevel);
    }

    @PUT
    @Timed
    @ApiOperation(value="Set the loglevel of a single logger", notes="Provided level is falling back to DEBUG if it does not exist")
    @Path(value="/{loggerName}/level/{level}")
    public void setSingleLoggerLevel(@ApiParam(name="loggerName", required=true) @PathParam(value="loggerName") String loggerName, @ApiParam(name="level", required=true) @PathParam(value="level") String level) {
        this.checkPermission("loggers:edit", loggerName);
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)loggerName);
        Level newLevel = Level.toLevel((String)level.toUpperCase());
        logger.setLevel(newLevel);
    }

    private static class Subsystem {
        private final String title;
        private final String category;
        private final String description;

        public Subsystem(String title, String category, String description) {
            this.title = title;
            this.category = category;
            this.description = description;
        }

        private String getTitle() {
            return this.title;
        }

        private String getCategory() {
            return this.category;
        }

        private String getDescription() {
            return this.description;
        }
    }
}

