/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.ldap;

import com.google.common.collect.Maps;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.net.URI;
import java.security.SecureRandom;
import java.util.Map;
import org.apache.shiro.codec.Hex;
import org.bson.types.ObjectId;
import org.graylog2.Configuration;
import org.graylog2.database.CollectionName;
import org.graylog2.database.PersistedImpl;
import org.graylog2.plugin.database.validators.Validator;
import org.graylog2.security.AESTools;
import org.graylog2.shared.security.ldap.LdapSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CollectionName(value="ldap_settings")
public class LdapSettingsImpl
extends PersistedImpl
implements LdapSettings {
    private static final Logger LOG = LoggerFactory.getLogger(LdapSettingsImpl.class);
    public static final String ENABLED = "enabled";
    public static final String SYSTEM_USERNAME = "system_username";
    public static final String SYSTEM_PASSWORD = "system_password";
    public static final String SYSTEM_PASSWORD_SALT = "system_password_salt";
    public static final String LDAP_URI = "ldap_uri";
    public static final String SEARCH_PATTERN = "principal_search_pattern";
    public static final String SEARCH_BASE = "search_base";
    public static final String DISPLAY_NAME_ATTRIBUTE = "username_attribute";
    public static final String USE_START_TLS = "use_start_tls";
    public static final String ACTIVE_DIRECTORY = "active_directory";
    public static final String DEFAULT_GROUP = "reader";
    public static final String TRUST_ALL_CERTS = "trust_all_certificates";
    protected Configuration configuration;

    @AssistedInject
    public LdapSettingsImpl(Configuration configuration) {
        super(Maps.newHashMap());
        this.configuration = configuration;
    }

    @AssistedInject
    public LdapSettingsImpl(Configuration configuration, @Assisted ObjectId id, @Assisted Map<String, Object> fields) {
        super(id, fields);
        this.configuration = configuration;
    }

    public Map<String, Validator> getValidations() {
        return null;
    }

    public Map<String, Validator> getEmbeddedValidations(String key) {
        return null;
    }

    public String getSystemUserName() {
        Object o = this.fields.get(SYSTEM_USERNAME);
        return o != null ? o.toString() : "";
    }

    public void setSystemUsername(String systemUsername) {
        this.fields.put(SYSTEM_USERNAME, systemUsername);
    }

    public String getSystemPassword() {
        Object o = this.fields.get(SYSTEM_PASSWORD);
        if (o == null) {
            return "";
        }
        if (this.getSystemPasswordSalt().isEmpty()) {
            LOG.debug("Old database version does not have salted, encrypted password. Please save the LDAP settings again.");
            return o.toString();
        }
        String encryptedPw = o.toString();
        return AESTools.decrypt(encryptedPw, this.configuration.getPasswordSecret().substring(0, 16), this.getSystemPasswordSalt());
    }

    public void setSystemPassword(String systemPassword) {
        if (this.getSystemPasswordSalt().isEmpty()) {
            LOG.debug("Generating new salt for LDAP system password.");
            SecureRandom random = new SecureRandom();
            byte[] saltBytes = new byte[8];
            random.nextBytes(saltBytes);
            this.setSystemPasswordSalt(Hex.encodeToString((byte[])saltBytes));
        }
        String encrypted = AESTools.encrypt(systemPassword, this.configuration.getPasswordSecret().substring(0, 16), this.getSystemPasswordSalt());
        this.fields.put(SYSTEM_PASSWORD, encrypted);
    }

    public String getSystemPasswordSalt() {
        Object o = this.fields.get(SYSTEM_PASSWORD_SALT);
        return o != null ? o.toString() : "";
    }

    public void setSystemPasswordSalt(String salt) {
        this.fields.put(SYSTEM_PASSWORD_SALT, salt);
    }

    public URI getUri() {
        Object o = this.fields.get(LDAP_URI);
        return o != null ? URI.create(o.toString()) : null;
    }

    public void setUri(URI ldapUri) {
        this.fields.put(LDAP_URI, ldapUri.toString());
    }

    public String getSearchBase() {
        Object o = this.fields.get(SEARCH_BASE);
        return o != null ? o.toString() : "";
    }

    public void setSearchBase(String searchBase) {
        this.fields.put(SEARCH_BASE, searchBase);
    }

    public String getSearchPattern() {
        Object o = this.fields.get(SEARCH_PATTERN);
        return o != null ? o.toString() : "";
    }

    public void setSearchPattern(String searchPattern) {
        this.fields.put(SEARCH_PATTERN, searchPattern);
    }

    public String getDisplayNameAttribute() {
        Object o = this.fields.get(DISPLAY_NAME_ATTRIBUTE);
        return o != null ? o.toString() : "";
    }

    public void setDisplayNameAttribute(String displayNameAttribute) {
        this.fields.put(DISPLAY_NAME_ATTRIBUTE, displayNameAttribute);
    }

    public boolean isEnabled() {
        Object o = this.fields.get(ENABLED);
        return o != null ? Boolean.valueOf(o.toString()) : false;
    }

    public void setEnabled(boolean enabled) {
        this.fields.put(ENABLED, enabled);
    }

    public void setUseStartTls(boolean useStartTls) {
        this.fields.put(USE_START_TLS, useStartTls);
    }

    public boolean isUseStartTls() {
        Object o = this.fields.get(USE_START_TLS);
        return o != null ? Boolean.valueOf(o.toString()) : false;
    }

    public void setActiveDirectory(boolean activeDirectory) {
        this.fields.put(ACTIVE_DIRECTORY, activeDirectory);
    }

    public boolean isActiveDirectory() {
        Object o = this.fields.get(ACTIVE_DIRECTORY);
        return o != null ? Boolean.valueOf(o.toString()) : false;
    }

    public String getDefaultGroup() {
        Object o = this.fields.get(DEFAULT_GROUP);
        return o != null ? o.toString() : DEFAULT_GROUP;
    }

    public void setDefaultGroup(String defaultGroup) {
        this.fields.put(DEFAULT_GROUP, defaultGroup);
    }

    public boolean isTrustAllCertificates() {
        Object o = this.fields.get(TRUST_ALL_CERTS);
        return o != null ? Boolean.valueOf(o.toString()) : false;
    }

    public void setTrustAllCertificates(boolean trustAllCertificates) {
        this.fields.put(TRUST_ALL_CERTS, trustAllCertificates);
    }

    public static interface Factory {
        public LdapSettingsImpl createEmpty();

        public LdapSettingsImpl create(ObjectId var1, Map<String, Object> var2);
    }
}

