/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.realm;

import javax.inject.Inject;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.SimpleAccount;
import org.apache.shiro.authc.credential.AllowAllCredentialsMatcher;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.database.users.User;
import org.graylog2.security.AccessToken;
import org.graylog2.security.AccessTokenAuthToken;
import org.graylog2.security.AccessTokenService;
import org.graylog2.security.realm.LdapUserAuthenticator;
import org.graylog2.shared.users.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenAuthenticator
extends AuthenticatingRealm {
    private static final Logger LOG = LoggerFactory.getLogger(AccessTokenAuthenticator.class);
    private final AccessTokenService accessTokenService;
    private final UserService userService;
    private final LdapUserAuthenticator ldapAuthenticator;

    @Inject
    public AccessTokenAuthenticator(AccessTokenService accessTokenService, UserService userService, LdapUserAuthenticator ldapAuthenticator) {
        this.accessTokenService = accessTokenService;
        this.userService = userService;
        this.ldapAuthenticator = ldapAuthenticator;
        this.setAuthenticationTokenClass(AccessTokenAuthToken.class);
        this.setCredentialsMatcher((CredentialsMatcher)new AllowAllCredentialsMatcher());
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        AccessTokenAuthToken authToken = (AccessTokenAuthToken)token;
        AccessToken accessToken = this.accessTokenService.load(String.valueOf(authToken.getToken()));
        if (accessToken == null) {
            return null;
        }
        User user = this.userService.load(accessToken.getUserName());
        if (user == null) {
            return null;
        }
        if (user.isExternalUser() && !this.ldapAuthenticator.isEnabled()) {
            throw new LockedAccountException("LDAP authentication is currently disabled.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found user {} for access token.", (Object)user);
        }
        try {
            this.accessTokenService.touch(accessToken);
        }
        catch (ValidationException e) {
            LOG.warn("Unable to update access token's last access date.", (Throwable)e);
        }
        return new SimpleAccount((Object)user.getName(), null, "access token realm");
    }
}

