/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.realm;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.users.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbAuthorizationRealm
extends AuthorizingRealm {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbAuthorizationRealm.class);
    private final UserService userService;

    @Inject
    public MongoDbAuthorizationRealm(UserService userService) {
        this.userService = userService;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        List permissions;
        LOG.debug("Retrieving authorization information for {}", (Object)principals);
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        User user = this.userService.load(principals.getPrimaryPrincipal().toString());
        if (null == user) {
            permissions = Collections.emptyList();
        } else {
            permissions = user.getPermissions();
            if (permissions != null) {
                info.setStringPermissions((Set)Sets.newHashSet((Iterable)permissions));
            }
        }
        LOG.debug("User {} has permissions: {}", (Object)principals, (Object)permissions);
        return info;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        return null;
    }
}

