/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.users;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.Configuration;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.plugin.database.Persisted;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.security.RestPermissions;
import org.graylog2.shared.security.ldap.LdapEntry;
import org.graylog2.shared.security.ldap.LdapSettings;
import org.graylog2.shared.users.UserService;
import org.graylog2.users.UserImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserServiceImpl
extends PersistedServiceImpl
implements UserService {
    private static final Logger LOG = LoggerFactory.getLogger(UserServiceImpl.class);
    private final Configuration configuration;

    @Inject
    public UserServiceImpl(MongoConnection mongoConnection, Configuration configuration) {
        super(mongoConnection);
        this.configuration = configuration;
    }

    public User load(String username) {
        LOG.debug("Loading user {}", (Object)username);
        if (this.configuration.getRootUsername().equals(username)) {
            LOG.debug("User {} is the built-in admin user", (Object)username);
            return new UserImpl.LocalAdminUser(this.configuration);
        }
        BasicDBObject query = new BasicDBObject();
        query.put("username", (Object)username);
        List<DBObject> result = this.query(UserImpl.class, (DBObject)query);
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            String msg = "There was more than one matching user for username " + username + ". This should never happen.";
            LOG.error(msg);
            throw new RuntimeException(msg);
        }
        DBObject userObject = result.get(0);
        Object userId = userObject.get("_id");
        LOG.debug("Loaded user {}/{} from MongoDB", (Object)username, userId);
        return new UserImpl((ObjectId)userId, userObject.toMap());
    }

    public User create() {
        return new UserImpl(Maps.newHashMap());
    }

    public List<User> loadAll() {
        BasicDBObject query = new BasicDBObject();
        List<DBObject> result = this.query(UserImpl.class, (DBObject)query);
        ArrayList users = Lists.newArrayList();
        for (DBObject dbObject : result) {
            users.add(new UserImpl((ObjectId)dbObject.get("_id"), dbObject.toMap()));
        }
        return users;
    }

    public User syncFromLdapEntry(LdapEntry userEntry, LdapSettings ldapSettings, String username) {
        UserImpl user = (UserImpl)this.load(username);
        if (user == null) {
            user = new UserImpl(Maps.newHashMap());
        }
        this.updateFromLdap(user, userEntry, ldapSettings, username);
        try {
            this.save(user);
        }
        catch (ValidationException e) {
            LOG.error("Cannot save user.", (Throwable)e);
            return null;
        }
        return user;
    }

    public void updateFromLdap(User user, LdapEntry userEntry, LdapSettings ldapSettings, String username) {
        String displayNameAttribute = ldapSettings.getDisplayNameAttribute();
        String fullName = (String)MoreObjects.firstNonNull((Object)userEntry.get(displayNameAttribute), (Object)username);
        user.setName(username);
        user.setFullName(fullName);
        user.setExternal(true);
        String email = userEntry.getEmail();
        if (Strings.isNullOrEmpty((String)email)) {
            LOG.debug("No email address found for user {} in LDAP. Using {}@localhost", (Object)username, (Object)username);
            user.setEmail(username + "@localhost");
        } else {
            user.setEmail(email);
        }
        if (Strings.isNullOrEmpty((String)user.getHashedPassword())) {
            ((UserImpl)user).setHashedPassword("User synced from LDAP.");
        }
        if (user.getPermissions() == null) {
            if (ldapSettings.getDefaultGroup().equals("reader")) {
                user.setPermissions((List)Lists.newArrayList((Iterable)RestPermissions.readerPermissions((String)username)));
            } else {
                user.setPermissions((List)Lists.newArrayList((Object[])new String[]{"*"}));
            }
        }
    }

    @Override
    public <T extends Persisted> String save(T model) throws ValidationException {
        if (model instanceof UserImpl.LocalAdminUser) {
            throw new IllegalStateException("Cannot modify local root user, this is a bug.");
        }
        return super.save(model);
    }

    public User getAdminUser() {
        return new UserImpl.LocalAdminUser(this.configuration);
    }

    public long count() {
        return this.totalCount(UserImpl.class);
    }
}

