/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alerts.types;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.graylog2.Configuration;
import org.graylog2.alerts.AbstractAlertCondition;
import org.graylog2.indexer.InvalidRangeFormatException;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.indexer.results.SearchResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.MessageSummary;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.streams.Stream;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldContentValueAlertCondition
extends AbstractAlertCondition {
    private static final Logger LOG = LoggerFactory.getLogger(FieldContentValueAlertCondition.class);
    private final Searches searches;
    private final Configuration configuration;
    private final String field;
    private final String value;

    @AssistedInject
    public FieldContentValueAlertCondition(Searches searches, Configuration configuration, @Assisted Stream stream, @Nullable @Assisted String id, @Assisted DateTime createdAt, @Assisted(value="userid") String creatorUserId, @Assisted Map<String, Object> parameters) {
        super(stream, id, AbstractAlertCondition.Type.FIELD_CONTENT_VALUE, createdAt, creatorUserId, parameters);
        this.searches = searches;
        this.configuration = configuration;
        this.field = (String)parameters.get("field");
        this.value = (String)parameters.get("value");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.field) ? 1 : 0) != 0, (Object)"\"field\" must not be empty.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.value) ? 1 : 0) != 0, (Object)"\"value\" must not be empty.");
    }

    @Override
    protected AbstractAlertCondition.CheckResult runCheck() {
        String filter = "streams:" + this.stream.getId();
        String query = this.field + ":\"" + this.value + "\"";
        Integer backlogSize = this.getBacklog();
        boolean backlogEnabled = false;
        int searchLimit = 1;
        if (backlogSize != null && backlogSize > 0) {
            backlogEnabled = true;
            searchLimit = backlogSize;
        }
        try {
            ArrayList summaries;
            SearchResult result = this.searches.search(query, filter, RelativeRange.create(this.configuration.getAlertCheckInterval()), searchLimit, 0, new Sorting("timestamp", Sorting.Direction.DESC));
            if (backlogEnabled) {
                summaries = Lists.newArrayListWithCapacity((int)result.getResults().size());
                for (ResultMessage resultMessage : result.getResults()) {
                    Message msg = resultMessage.getMessage();
                    summaries.add(new MessageSummary(resultMessage.getIndex(), msg));
                }
            } else {
                summaries = Collections.emptyList();
            }
            long count = result.getTotalResults();
            String resultDescription = "Stream received messages matching <" + query + "> " + "(Current grace time: " + this.grace + " minutes)";
            if (count > 0L) {
                LOG.debug("Alert check <{}> found [{}] messages.", (Object)this.id, (Object)count);
                return new AbstractAlertCondition.CheckResult(true, this, resultDescription, Tools.nowUTC(), summaries);
            }
            LOG.debug("Alert check <{}> returned no results.", (Object)this.id);
            return new AbstractAlertCondition.NegativeCheckResult(this);
        }
        catch (InvalidRangeParametersException e) {
            LOG.error("Invalid timerange.", (Throwable)e);
            return null;
        }
        catch (InvalidRangeFormatException e) {
            LOG.error("Invalid timerange format.", (Throwable)e);
            return null;
        }
    }

    public String getDescription() {
        return "field: " + this.field + ", value: " + this.value;
    }

    public static interface Factory {
        public FieldContentValueAlertCondition createAlertCondition(Stream var1, String var2, DateTime var3, @Assisted(value="userid") String var4, Map<String, Object> var5);
    }
}

