/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.cluster;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.EventBus;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import javax.inject.Inject;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.cluster.ClusterConfig;
import org.graylog2.cluster.ClusterConfigChangedEvent;
import org.graylog2.database.MongoConnection;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.utilities.AutoValueUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterConfigServiceImpl
implements ClusterConfigService {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterConfigServiceImpl.class);
    @VisibleForTesting
    static final String COLLECTION_NAME = "cluster_config";
    private final JacksonDBCollection<ClusterConfig, String> dbCollection;
    private final NodeId nodeId;
    private final ObjectMapper objectMapper;
    private final EventBus clusterEventBus;

    @Inject
    public ClusterConfigServiceImpl(MongoJackObjectMapperProvider mapperProvider, MongoConnection mongoConnection, NodeId nodeId, ObjectMapper objectMapper, @ClusterEventBus EventBus clusterEventBus) {
        this((JacksonDBCollection<ClusterConfig, String>)JacksonDBCollection.wrap((DBCollection)ClusterConfigServiceImpl.prepareCollection(mongoConnection), ClusterConfig.class, String.class, (ObjectMapper)mapperProvider.get()), nodeId, objectMapper, clusterEventBus);
    }

    ClusterConfigServiceImpl(JacksonDBCollection<ClusterConfig, String> dbCollection, NodeId nodeId, ObjectMapper objectMapper, EventBus clusterEventBus) {
        this.nodeId = (NodeId)Preconditions.checkNotNull((Object)nodeId);
        this.dbCollection = (JacksonDBCollection)Preconditions.checkNotNull(dbCollection);
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper);
        this.clusterEventBus = (EventBus)Preconditions.checkNotNull((Object)clusterEventBus);
    }

    @VisibleForTesting
    static DBCollection prepareCollection(MongoConnection mongoConnection) {
        DBCollection coll = mongoConnection.getDatabase().getCollection(COLLECTION_NAME);
        coll.createIndex((DBObject)DBSort.asc((String)"type"), "unique_type", true);
        coll.setWriteConcern(WriteConcern.FSYNCED);
        return coll;
    }

    private <T> T extractPayload(Object payload, Class<T> type) {
        try {
            return (T)this.objectMapper.convertValue(payload, type);
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Error while deserializing payload", (Throwable)e);
            return null;
        }
    }

    public <T> T get(Class<T> type) {
        ClusterConfig config = (ClusterConfig)this.dbCollection.findOne(DBQuery.is((String)"type", (Object)type.getCanonicalName()));
        if (config == null) {
            LOG.debug("Couldn't find cluster config of type {}", (Object)type.getCanonicalName());
            return null;
        }
        T result = this.extractPayload(config.payload(), type);
        if (result == null) {
            LOG.error("Couldn't extract payload from cluster config (type: {})", (Object)type.getCanonicalName());
        }
        return result;
    }

    public <T> T getOrDefault(Class<T> type, T defaultValue) {
        return (T)MoreObjects.firstNonNull(this.get(type), defaultValue);
    }

    public <T> void write(T payload) {
        if (payload == null) {
            LOG.debug("Payload was null. Skipping.");
            return;
        }
        String canonicalClassName = AutoValueUtils.getCanonicalName(payload.getClass());
        ClusterConfig clusterConfig = ClusterConfig.create(canonicalClassName, payload, this.nodeId.toString());
        this.dbCollection.update(DBQuery.is((String)"type", (Object)canonicalClassName), (Object)clusterConfig, true, false, WriteConcern.FSYNCED);
        ClusterConfigChangedEvent event = ClusterConfigChangedEvent.create(DateTime.now((DateTimeZone)DateTimeZone.UTC), this.nodeId.toString(), canonicalClassName);
        this.clusterEventBus.post((Object)event);
    }

    public <T> int remove(Class<T> type) {
        String canonicalName = type.getCanonicalName();
        WriteResult result = this.dbCollection.remove(DBQuery.is((String)"type", (Object)canonicalName));
        return result.getN();
    }
}

