/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.collectors;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.validation.Validator;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.collectors.Collector;
import org.graylog2.collectors.CollectorImpl;
import org.graylog2.collectors.CollectorNodeDetails;
import org.graylog2.collectors.CollectorService;
import org.graylog2.database.CollectionName;
import org.graylog2.database.MongoConnection;
import org.graylog2.rest.models.collector.requests.CollectorRegistrationRequest;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;

public class CollectorServiceImpl
implements CollectorService {
    private final JacksonDBCollection<CollectorImpl, String> coll;
    private final Validator validator;

    @Inject
    public CollectorServiceImpl(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapperProvider, Validator validator) {
        this.validator = validator;
        String collectionName = CollectorImpl.class.getAnnotation(CollectionName.class).value();
        DBCollection dbCollection = mongoConnection.getDatabase().getCollection(collectionName);
        this.coll = JacksonDBCollection.wrap((DBCollection)dbCollection, CollectorImpl.class, String.class, (ObjectMapper)mapperProvider.get());
        this.coll.createIndex((DBObject)new BasicDBObject("id", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
    }

    @Override
    public long count() {
        return this.coll.count();
    }

    @Override
    public Collector save(Collector collector) {
        if (collector instanceof CollectorImpl) {
            CollectorImpl collectorImpl = (CollectorImpl)collector;
            Set violations = this.validator.validate((Object)collectorImpl, new Class[0]);
            if (violations.isEmpty()) {
                return (Collector)this.coll.findAndModify(DBQuery.is((String)"id", (Object)collector.getId()), (DBObject)new BasicDBObject(), (DBObject)new BasicDBObject(), false, (Object)collectorImpl, true, true);
            }
            throw new IllegalArgumentException("Specified object failed validation: " + violations);
        }
        throw new IllegalArgumentException("Specified object is not of correct implementation type (" + collector.getClass() + ")!");
    }

    @Override
    public List<Collector> all() {
        return this.toAbstractListType((DBCursor<CollectorImpl>)this.coll.find());
    }

    @Override
    public Collector findById(String id) {
        return (Collector)this.coll.findOne(DBQuery.is((String)"id", (Object)id));
    }

    @Override
    public List<Collector> findByNodeId(String nodeId) {
        return this.toAbstractListType((DBCursor<CollectorImpl>)this.coll.find(DBQuery.is((String)"node_id", (Object)nodeId)));
    }

    @Override
    public int destroy(Collector collector) {
        return this.coll.remove(DBQuery.is((String)"id", (Object)collector.getId())).getN();
    }

    @Override
    public int destroyExpired(int time, TimeUnit unit) {
        int count = 0;
        DateTime threshold = DateTime.now((DateTimeZone)DateTimeZone.UTC).minusSeconds(Ints.checkedCast((long)unit.toSeconds(time)));
        for (Collector collector : this.all()) {
            if (!collector.getLastSeen().isBefore((ReadableInstant)threshold)) continue;
            count += this.destroy(collector);
        }
        return count;
    }

    @Override
    public Collector fromRequest(String collectorId, CollectorRegistrationRequest request, String collectorVersion) {
        return CollectorImpl.create(collectorId, request.nodeId(), collectorVersion, CollectorNodeDetails.create(request.nodeDetails().operatingSystem()), DateTime.now((DateTimeZone)DateTimeZone.UTC));
    }

    private List<Collector> toAbstractListType(DBCursor<CollectorImpl> collectors) {
        return this.toAbstractListType(collectors.toArray());
    }

    private List<Collector> toAbstractListType(List<CollectorImpl> collectors) {
        ArrayList result = Lists.newArrayListWithCapacity((int)collectors.size());
        result.addAll(collectors);
        return result;
    }
}

