/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.graylog2.dashboards.widgets.ChartWidget;
import org.graylog2.dashboards.widgets.ComputationResult;
import org.graylog2.dashboards.widgets.DashboardWidget;
import org.graylog2.dashboards.widgets.WidgetCacheTime;
import org.graylog2.indexer.results.HistogramResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.timeranges.TimeRange;

public class SearchResultChartWidget
extends ChartWidget {
    private final String query;
    private final Searches searches;

    public SearchResultChartWidget(MetricRegistry metricRegistry, Searches searches, String id, String description, WidgetCacheTime cacheTime, Map<String, Object> config, String query, TimeRange timeRange, String creatorUserId) {
        super(metricRegistry, DashboardWidget.Type.SEARCH_RESULT_CHART, id, timeRange, description, cacheTime, config, creatorUserId);
        this.searches = searches;
        this.query = this.getNonEmptyQuery(query);
    }

    private String getNonEmptyQuery(String query) {
        if (Strings.isNullOrEmpty((String)query)) {
            return "*";
        }
        return query;
    }

    public String getQuery() {
        return this.query;
    }

    @Override
    public Map<String, Object> getPersistedConfig() {
        ImmutableMap.Builder persistedConfig = ImmutableMap.builder().putAll(super.getPersistedConfig()).put((Object)"query", (Object)this.query);
        return persistedConfig.build();
    }

    @Override
    protected ComputationResult compute() {
        String filter = null;
        if (!Strings.isNullOrEmpty((String)this.streamId)) {
            filter = "streams:" + this.streamId;
        }
        HistogramResult histogram = this.searches.histogram(this.query, this.interval, filter, this.getTimeRange());
        return new ComputationResult(histogram.getResults(), histogram.took().millis(), histogram.getHistogramBoundaries());
    }
}

