/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.graylog2.dashboards.widgets.ComputationResult;
import org.graylog2.dashboards.widgets.DashboardWidget;
import org.graylog2.dashboards.widgets.SearchResultCountWidget;
import org.graylog2.dashboards.widgets.WidgetCacheTime;
import org.graylog2.indexer.results.FieldStatsResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.indexer.searches.timeranges.RelativeRange;
import org.graylog2.indexer.searches.timeranges.TimeRange;
import org.joda.time.DateTime;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticalCountWidget
extends SearchResultCountWidget {
    private static final Logger log = LoggerFactory.getLogger(StatisticalCountWidget.class);
    private final StatisticalFunction statsFunction;
    private final String field;
    private final String streamId;

    public StatisticalCountWidget(MetricRegistry metricRegistry, Searches searches, String id, String description, WidgetCacheTime cacheTime, Map<String, Object> config, String query, TimeRange timeRange, String creatorUserId) {
        super(metricRegistry, DashboardWidget.Type.STATS_COUNT, searches, id, description, cacheTime, config, query, timeRange, creatorUserId);
        this.field = (String)config.get("field");
        String statsFunction = (String)config.get("stats_function");
        this.statsFunction = statsFunction.equals("stddev") ? StatisticalFunction.STANDARD_DEVIATION : StatisticalFunction.fromString(statsFunction);
        this.streamId = (String)config.get("stream_id");
    }

    @Override
    public Map<String, Object> getPersistedConfig() {
        Map<String, Object> inheritedConfig = super.getPersistedConfig();
        ImmutableMap.Builder persistedConfig = ImmutableMap.builder();
        persistedConfig.putAll(inheritedConfig);
        persistedConfig.put((Object)"field", (Object)this.field);
        persistedConfig.put((Object)"stats_function", (Object)this.statsFunction.toString());
        if (!Strings.isNullOrEmpty((String)this.streamId)) {
            persistedConfig.put((Object)"stream_id", (Object)this.streamId);
        }
        return persistedConfig.build();
    }

    private Number getStatisticalValue(FieldStatsResult fieldStatsResult) {
        switch (this.statsFunction) {
            case COUNT: {
                return fieldStatsResult.getCount();
            }
            case MEAN: {
                return fieldStatsResult.getMean();
            }
            case STANDARD_DEVIATION: {
                return fieldStatsResult.getStdDeviation();
            }
            case MIN: {
                return fieldStatsResult.getMin();
            }
            case MAX: {
                return fieldStatsResult.getMax();
            }
            case SUM: {
                return fieldStatsResult.getSum();
            }
            case VARIANCE: {
                return fieldStatsResult.getVariance();
            }
            case SUM_OF_SQUARES: {
                return fieldStatsResult.getSumOfSquares();
            }
            case CARDINALITY: {
                return fieldStatsResult.getCardinality();
            }
        }
        throw new IllegalArgumentException("Statistic function " + (Object)((Object)this.statsFunction) + " is not supported");
    }

    @Override
    protected ComputationResult compute() {
        try {
            String filter = !Strings.isNullOrEmpty((String)this.streamId) ? "streams:" + this.streamId : null;
            TimeRange timeRange = this.getTimeRange();
            boolean needsCardinality = this.statsFunction.equals((Object)StatisticalFunction.CARDINALITY);
            boolean needsCount = this.statsFunction.equals((Object)StatisticalFunction.COUNT);
            FieldStatsResult fieldStatsResult = this.getSearches().fieldStats(this.field, this.query, filter, timeRange, needsCardinality, !needsCount && !needsCardinality, needsCount);
            if (this.trend.booleanValue() && timeRange instanceof RelativeRange) {
                DateTime toPrevious = timeRange.getFrom();
                DateTime fromPrevious = toPrevious.minus((ReadablePeriod)Seconds.seconds((int)((RelativeRange)timeRange).getRange()));
                AbsoluteRange previousTimeRange = AbsoluteRange.create(fromPrevious, toPrevious);
                FieldStatsResult previousFieldStatsResult = this.getSearches().fieldStats(this.field, this.query, filter, previousTimeRange, needsCardinality, !needsCount && !needsCardinality, needsCount);
                HashMap results = Maps.newHashMap();
                results.put("now", this.getStatisticalValue(fieldStatsResult));
                results.put("previous", this.getStatisticalValue(previousFieldStatsResult));
                long tookMs = fieldStatsResult.took().millis() + previousFieldStatsResult.took().millis();
                return new ComputationResult(results, tookMs);
            }
            return new ComputationResult(this.getStatisticalValue(fieldStatsResult), fieldStatsResult.took().millis());
        }
        catch (Searches.FieldTypeException e) {
            log.warn("Invalid field provided, returning 'NaN'", (Throwable)e);
            return new ComputationResult(Double.NaN, 0L);
        }
    }

    public static enum StatisticalFunction {
        COUNT("count"),
        MEAN("mean"),
        STANDARD_DEVIATION("std_deviation"),
        MIN("min"),
        MAX("max"),
        SUM("sum"),
        VARIANCE("variance"),
        SUM_OF_SQUARES("squares"),
        CARDINALITY("cardinality");

        private final String function;

        private StatisticalFunction(String function) {
            this.function = function;
        }

        public String toString() {
            return this.function;
        }

        public static StatisticalFunction fromString(String function) {
            for (StatisticalFunction statisticalFunction : StatisticalFunction.values()) {
                if (!statisticalFunction.toString().equals(function)) continue;
                return statisticalFunction;
            }
            throw new IllegalArgumentException("Statistic function " + function + " is not supported");
        }
    }
}

