/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.filters;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.mongodb.DBCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.filters.FilterService;
import org.graylog2.filters.blacklist.FilterDescription;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.ValidationException;
import org.mongojack.DBCursor;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

@Singleton
public class FilterServiceImpl
implements FilterService {
    public static final String FILTERS = "filters";
    private final JacksonDBCollection<FilterDescription, ObjectId> dbCollection;

    @Inject
    protected FilterServiceImpl(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper) {
        this.dbCollection = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(FILTERS), FilterDescription.class, ObjectId.class, (ObjectMapper)mapper.get());
    }

    @Override
    public FilterDescription load(String filterId) throws NotFoundException {
        FilterDescription filter = (FilterDescription)this.dbCollection.findOneById((Object)new ObjectId(filterId));
        if (filter == null) {
            throw new NotFoundException();
        }
        return filter;
    }

    @Override
    public Set<FilterDescription> loadAll() throws NotFoundException {
        DBCursor filterDescriptions = this.dbCollection.find();
        HashSet filters = Sets.newHashSet();
        if (filterDescriptions.hasNext()) {
            Iterators.addAll((Collection)filters, (Iterator)filterDescriptions);
        }
        return filters;
    }

    @Override
    public FilterDescription save(FilterDescription filter) throws ValidationException {
        if (filter.createdAt == null) {
            filter.createdAt = Tools.nowUTC();
        }
        if (!this.validate(filter)) {
            throw new ValidationException("Validation failed.");
        }
        WriteResult writeResult = this.dbCollection.save((Object)filter);
        return (FilterDescription)writeResult.getSavedObject();
    }

    @Override
    public boolean validate(FilterDescription filter) {
        return true;
    }

    @Override
    public int delete(String filterId) {
        return this.dbCollection.removeById((Object)new ObjectId(filterId)).getN();
    }
}

