/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indices;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.alias.exists.AliasesExistResponse;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.filter.Filter;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.max.Max;
import org.elasticsearch.search.aggregations.metrics.min.Min;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.IndexMapping;
import org.graylog2.indexer.IndexNotFoundException;
import org.graylog2.indexer.indices.IndexStatistics;
import org.graylog2.indexer.messages.Messages;
import org.graylog2.indexer.searches.TimestampStats;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Indices {
    private static final Logger LOG = LoggerFactory.getLogger(Indices.class);
    private static final String REOPENED_INDEX_SETTING = "graylog2_reopened";
    private final Client c;
    private final ElasticsearchConfiguration configuration;
    private final IndexMapping indexMapping;
    private final Messages messages;

    @Inject
    public Indices(Client client, ElasticsearchConfiguration configuration, IndexMapping indexMapping, Messages messages) {
        this.c = client;
        this.configuration = configuration;
        this.indexMapping = indexMapping;
        this.messages = messages;
    }

    public void move(String source, String target) {
        SearchResponse scrollResp = (SearchResponse)this.c.prepareSearch(new String[]{source}).setScroll(TimeValue.timeValueSeconds((long)10L)).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).addSort((SortBuilder)SortBuilders.fieldSort((String)"_doc")).setSize(350).execute().actionGet();
        while ((scrollResp = (SearchResponse)this.c.prepareSearchScroll(scrollResp.getScrollId()).setScroll(new TimeValue(60000L)).execute().actionGet()).getHits().hits().length != 0) {
            BulkRequestBuilder request = this.c.prepareBulk();
            for (SearchHit hit : scrollResp.getHits()) {
                Map doc = hit.getSource();
                String id = (String)doc.remove("_id");
                request.add(this.messages.buildIndexRequest(target, doc, id));
            }
            request.setConsistencyLevel(WriteConsistencyLevel.ONE);
            if (request.numberOfActions() <= 0) continue;
            BulkResponse response = (BulkResponse)this.c.bulk((BulkRequest)request.request()).actionGet();
            LOG.info("Moving index <{}> to <{}>: Bulk indexed {} messages, took {} ms, failures: {}", new Object[]{source, target, response.getItems().length, response.getTookInMillis(), response.hasFailures()});
            if (!response.hasFailures()) continue;
            throw new RuntimeException("Failed to move a message. Check your indexer log.");
        }
    }

    public void delete(String indexName) {
        this.c.admin().indices().delete(new DeleteIndexRequest(indexName)).actionGet();
    }

    public void close(String indexName) {
        this.c.admin().indices().close(new CloseIndexRequest(new String[]{indexName})).actionGet();
    }

    public long numberOfMessages(String indexName) throws IndexNotFoundException {
        IndexStats index = this.indexStats(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.getPrimaries().getDocs().getCount();
    }

    public Map<String, IndexStats> getAll() {
        IndicesStatsRequest request = (IndicesStatsRequest)this.c.admin().indices().prepareStats(new String[]{this.allIndicesAlias()}).request();
        IndicesStatsResponse response = (IndicesStatsResponse)this.c.admin().indices().stats(request).actionGet();
        return response.getIndices();
    }

    @Nullable
    public IndexStats indexStats(String indexName) {
        IndicesStatsRequest request = (IndicesStatsRequest)this.c.admin().indices().prepareStats(new String[]{indexName}).request();
        IndicesStatsResponse response = (IndicesStatsResponse)this.c.admin().indices().stats(request).actionGet();
        return response.getIndex(indexName);
    }

    public String allIndicesAlias() {
        return this.configuration.getIndexPrefix() + "_*";
    }

    public boolean exists(String index) {
        ActionFuture existsFuture = this.c.admin().indices().exists(new IndicesExistsRequest(new String[]{index}));
        return ((IndicesExistsResponse)existsFuture.actionGet()).isExists();
    }

    public boolean aliasExists(String alias) {
        return ((AliasesExistResponse)this.c.admin().indices().aliasesExist(new GetAliasesRequest(alias)).actionGet()).exists();
    }

    @Nullable
    public String aliasTarget(String alias) {
        IndicesAdminClient indicesAdminClient = this.c.admin().indices();
        GetAliasesRequest request = (GetAliasesRequest)indicesAdminClient.prepareGetAliases(new String[]{alias}).request();
        GetAliasesResponse response = (GetAliasesResponse)indicesAdminClient.getAliases(request).actionGet();
        return response.getAliases().isEmpty() ? null : (String)response.getAliases().keysIt().next();
    }

    private void ensureIndexTemplate() {
        Map<String, Object> template = this.indexMapping.messageTemplate(this.allIndicesAlias(), this.configuration.getAnalyzer());
        try {
            GetIndexTemplatesResponse getIndexTemplatesResponse = (GetIndexTemplatesResponse)this.c.admin().indices().prepareGetTemplates(new String[]{this.configuration.getTemplateName()}).get();
            List existingTemplate = getIndexTemplatesResponse.getIndexTemplates();
            if (existingTemplate.size() > 0) {
                LOG.debug("Index template \"{}\" exists, not installing it again.", (Object)this.configuration.getTemplateName());
                return;
            }
        }
        catch (Exception e) {
            LOG.error("Unable to get index template \"" + this.configuration.getTemplateName() + "\" from Elasticsearch.", (Throwable)e);
        }
        PutIndexTemplateRequest itr = (PutIndexTemplateRequest)this.c.admin().indices().preparePutTemplate(this.configuration.getTemplateName()).setOrder(Integer.MIN_VALUE).setSource(template).request();
        try {
            boolean acknowledged = ((PutIndexTemplateResponse)this.c.admin().indices().putTemplate(itr).actionGet()).isAcknowledged();
            if (acknowledged) {
                LOG.info("Created Graylog index template \"{}\" in Elasticsearch.", (Object)this.configuration.getTemplateName());
            }
        }
        catch (Exception e) {
            LOG.error("Unable to create the Graylog index template: " + this.configuration.getTemplateName(), (Throwable)e);
        }
    }

    public boolean create(String indexName) {
        return this.create(indexName, this.configuration.getShards(), this.configuration.getReplicas(), Settings.EMPTY);
    }

    public boolean create(String indexName, int numShards, int numReplicas, Settings customSettings) {
        Settings settings = Settings.builder().put("number_of_shards", numShards).put("number_of_replicas", numReplicas).put("analysis.analyzer.analyzer_keyword.tokenizer", "keyword").put("analysis.analyzer.analyzer_keyword.filter", "lowercase").put(customSettings).build();
        this.ensureIndexTemplate();
        CreateIndexRequest cir = (CreateIndexRequest)this.c.admin().indices().prepareCreate(indexName).setSettings(settings).request();
        return ((CreateIndexResponse)this.c.admin().indices().create(cir).actionGet()).isAcknowledged();
    }

    public Set<String> getAllMessageFields() {
        HashSet fields = Sets.newHashSet();
        ClusterStateRequest csr = new ClusterStateRequest().blocks(true).nodes(true).indices(new String[]{this.allIndicesAlias()});
        ClusterState cs = ((ClusterStateResponse)this.c.admin().cluster().state(csr).actionGet()).getState();
        for (ObjectObjectCursor m : cs.getMetaData().indices()) {
            try {
                MappingMetaData mmd = ((IndexMetaData)m.value).mapping("message");
                if (mmd == null) continue;
                Map mapping = (Map)mmd.getSourceAsMap().get("properties");
                fields.addAll(mapping.keySet());
            }
            catch (Exception e) {
                LOG.error("Error while trying to get fields of <" + m.index + ">", (Throwable)e);
            }
        }
        return fields;
    }

    public void setReadOnly(String index) {
        Settings.Builder sb = Settings.builder().put("index.blocks.write", true).put("index.blocks.read", false).put("index.blocks.metadata", false);
        UpdateSettingsRequest request = (UpdateSettingsRequest)this.c.admin().indices().prepareUpdateSettings(new String[]{index}).setSettings(sb).request();
        this.c.admin().indices().updateSettings(request).actionGet();
    }

    public void flush(String index) {
        FlushRequest flush = new FlushRequest(new String[]{index});
        flush.force(true);
        this.c.admin().indices().flush(new FlushRequest(new String[]{index}).force(true)).actionGet();
    }

    public Settings reopenIndexSettings() {
        return Settings.builder().put(REOPENED_INDEX_SETTING, true).build();
    }

    public void reopenIndex(String index) {
        UpdateSettingsRequest settings = new UpdateSettingsRequest(new String[]{index});
        settings.settings(this.reopenIndexSettings());
        this.c.admin().indices().updateSettings(settings).actionGet();
        this.c.admin().indices().open(new OpenIndexRequest(new String[]{index})).actionGet();
    }

    public boolean isReopened(String indexName) {
        ClusterState clusterState = ((ClusterStateResponse)this.c.admin().cluster().state(new ClusterStateRequest()).actionGet()).getState();
        IndexMetaData metaData = (IndexMetaData)clusterState.getMetaData().getIndices().get((Object)indexName);
        if (metaData == null) {
            return false;
        }
        return this.checkForReopened(metaData);
    }

    protected Boolean checkForReopened(IndexMetaData metaData) {
        return metaData.getSettings().getAsBoolean("index.graylog2_reopened", Boolean.valueOf(false));
    }

    public Set<String> getClosedIndices() {
        HashSet closedIndices = Sets.newHashSet();
        ClusterStateRequest csr = new ClusterStateRequest().nodes(false).routingTable(false).blocks(false).metaData(true);
        ClusterState state = ((ClusterStateResponse)this.c.admin().cluster().state(csr).actionGet()).getState();
        UnmodifiableIterator it = state.getMetaData().getIndices().valuesIt();
        while (it.hasNext()) {
            IndexMetaData indexMeta = (IndexMetaData)it.next();
            if (!indexMeta.getIndex().startsWith(this.configuration.getIndexPrefix()) || !indexMeta.getState().equals((Object)IndexMetaData.State.CLOSE)) continue;
            closedIndices.add(indexMeta.getIndex());
        }
        return closedIndices;
    }

    public Set<String> getReopenedIndices() {
        HashSet reopenedIndices = Sets.newHashSet();
        ClusterStateRequest csr = new ClusterStateRequest().nodes(false).routingTable(false).blocks(false).metaData(true);
        ClusterState state = ((ClusterStateResponse)this.c.admin().cluster().state(csr).actionGet()).getState();
        UnmodifiableIterator it = state.getMetaData().getIndices().valuesIt();
        while (it.hasNext()) {
            IndexMetaData indexMeta = (IndexMetaData)it.next();
            if (!indexMeta.getIndex().startsWith(this.configuration.getIndexPrefix()) || !this.checkForReopened(indexMeta).booleanValue()) continue;
            reopenedIndices.add(indexMeta.getIndex());
        }
        return reopenedIndices;
    }

    @Nullable
    public IndexStatistics getIndexStats(String index) {
        IndexStats indexStats;
        if (!index.startsWith(this.configuration.getIndexPrefix())) {
            return null;
        }
        try {
            indexStats = this.indexStats(index);
        }
        catch (ElasticsearchException e) {
            return null;
        }
        if (indexStats == null) {
            return null;
        }
        ImmutableList.Builder shardRouting = ImmutableList.builder();
        for (ShardStats shardStats : indexStats.getShards()) {
            shardRouting.add((Object)shardStats.getShardRouting());
        }
        return IndexStatistics.create(indexStats.getIndex(), indexStats.getPrimaries(), indexStats.getTotal(), (List<ShardRouting>)shardRouting.build());
    }

    public Set<IndexStatistics> getIndicesStats() {
        Map<String, IndexStats> responseIndices;
        try {
            responseIndices = this.getAll();
        }
        catch (ElasticsearchException e) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (IndexStats indexStats : responseIndices.values()) {
            ImmutableList.Builder shardRouting = ImmutableList.builder();
            for (ShardStats shardStats : indexStats.getShards()) {
                shardRouting.add((Object)shardStats.getShardRouting());
            }
            IndexStatistics stats = IndexStatistics.create(indexStats.getIndex(), indexStats.getPrimaries(), indexStats.getTotal(), (List<ShardRouting>)shardRouting.build());
            result.add((Object)stats);
        }
        return result.build();
    }

    public boolean cycleAlias(String aliasName, String targetIndex) {
        return ((IndicesAliasesResponse)this.c.admin().indices().prepareAliases().addAlias(targetIndex, aliasName).execute().actionGet()).isAcknowledged();
    }

    public boolean cycleAlias(String aliasName, String targetIndex, String oldIndex) {
        return ((IndicesAliasesResponse)this.c.admin().indices().prepareAliases().removeAlias(oldIndex, aliasName).addAlias(targetIndex, aliasName).execute().actionGet()).isAcknowledged();
    }

    public void optimizeIndex(String index) {
        ForceMergeRequest request = (ForceMergeRequest)this.c.admin().indices().prepareForceMerge(new String[]{index}).setMaxNumSegments(this.configuration.getIndexOptimizationMaxNumSegments()).setOnlyExpungeDeletes(false).setFlush(true).request();
        this.c.admin().indices().forceMerge(request).actionGet(1L, TimeUnit.HOURS);
    }

    public ClusterHealthStatus waitForRecovery(String index) {
        return this.waitForStatus(index, ClusterHealthStatus.YELLOW);
    }

    public ClusterHealthStatus waitForStatus(String index, ClusterHealthStatus clusterHealthStatus) {
        ClusterHealthRequest request = (ClusterHealthRequest)this.c.admin().cluster().prepareHealth(new String[]{index}).setWaitForStatus(clusterHealthStatus).request();
        LOG.debug("Waiting until index health status of index {} is {}", (Object)index, (Object)clusterHealthStatus);
        ClusterHealthResponse response = (ClusterHealthResponse)this.c.admin().cluster().health(request).actionGet(5L, TimeUnit.MINUTES);
        return response.getStatus();
    }

    @Nullable
    public DateTime indexCreationDate(String index) {
        GetIndexRequest indexRequest = (GetIndexRequest)((GetIndexRequestBuilder)this.c.admin().indices().prepareGetIndex().addFeatures(new GetIndexRequest.Feature[]{GetIndexRequest.Feature.SETTINGS}).addIndices(new String[]{index})).request();
        try {
            GetIndexResponse response = (GetIndexResponse)this.c.admin().indices().getIndex(indexRequest).actionGet();
            Settings settings = (Settings)response.settings().get((Object)index);
            if (settings == null) {
                return null;
            }
            return new DateTime((Object)settings.getAsLong("index.creation_date", Long.valueOf(0L)), DateTimeZone.UTC);
        }
        catch (ElasticsearchException e) {
            LOG.warn("Unable to read creation_date for index " + index, e.getRootCause());
            return null;
        }
    }

    public TimestampStats timestampStatsOfIndex(String index) {
        SearchResponse response;
        FilterAggregationBuilder builder = (FilterAggregationBuilder)((FilterAggregationBuilder)AggregationBuilders.filter((String)"agg").filter((QueryBuilder)QueryBuilders.existsQuery((String)"timestamp")).subAggregation((AbstractAggregationBuilder)AggregationBuilders.min((String)"ts_min").field("timestamp"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.max((String)"ts_max").field("timestamp"));
        SearchRequestBuilder srb = this.c.prepareSearch(new String[0]).setIndices(new String[]{index}).setSearchType(SearchType.QUERY_THEN_FETCH).setSize(0).addAggregation((AbstractAggregationBuilder)builder);
        try {
            response = (SearchResponse)this.c.search(srb.request()).actionGet();
        }
        catch (org.elasticsearch.index.IndexNotFoundException e) {
            LOG.error("Error while calculating timestamp stats in index <" + index + ">", (Throwable)e);
            throw e;
        }
        catch (ElasticsearchException e) {
            LOG.error("Error while calculating timestamp stats in index <" + index + ">", (Throwable)e);
            throw new org.elasticsearch.index.IndexNotFoundException("Index " + index + " not found", (Throwable)e);
        }
        Filter f = (Filter)response.getAggregations().get("agg");
        if (f.getDocCount() == 0L) {
            LOG.debug("No documents with attribute \"timestamp\" found in index <{}>", (Object)index);
            return TimestampStats.EMPTY;
        }
        Min minAgg = (Min)f.getAggregations().get("ts_min");
        DateTime min = new DateTime((long)minAgg.getValue(), DateTimeZone.UTC);
        Max maxAgg = (Max)f.getAggregations().get("ts_max");
        DateTime max = new DateTime((long)maxAgg.getValue(), DateTimeZone.UTC);
        return TimestampStats.create(min, max);
    }
}

