/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.ranges;

import com.codahale.metrics.MetricRegistry;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.IndexNotFoundException;
import org.graylog2.database.NotFoundException;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.esplugin.IndicesDeletedEvent;
import org.graylog2.indexer.ranges.EsIndexRange;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.ranges.IndexRangeService;
import org.graylog2.metrics.CacheStatsSet;
import org.graylog2.shared.metrics.MetricUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Deprecated
public class EsIndexRangeService
implements IndexRangeService {
    private static final Logger LOG = LoggerFactory.getLogger(EsIndexRangeService.class);
    private final LoadingCache<String, IndexRange> cache;
    private final Client client;
    private final Deflector deflector;

    @Inject
    public EsIndexRangeService(Client client, Deflector deflector, EventBus eventBus, @ClusterEventBus EventBus clusterEventBus, MetricRegistry metricRegistry) {
        this.client = Objects.requireNonNull(client);
        this.deflector = Objects.requireNonNull(deflector);
        CacheLoader<String, IndexRange> cacheLoader = new CacheLoader<String, IndexRange>(){

            public IndexRange load(String indexName) throws Exception {
                IndexRange indexRange = EsIndexRangeService.this.loadIndexRange(indexName);
                if (indexRange == null) {
                    throw new NotFoundException("Couldn't load index range for index " + indexName);
                }
                return indexRange;
            }
        };
        this.cache = CacheBuilder.newBuilder().recordStats().build((CacheLoader)cacheLoader);
        MetricUtils.safelyRegisterAll(metricRegistry, new CacheStatsSet(MetricRegistry.name(this.getClass(), (String[])new String[]{"cache"}), (Cache)this.cache));
        eventBus.register((Object)this);
        clusterEventBus.register((Object)this);
    }

    @Override
    public IndexRange get(String index) throws NotFoundException {
        try {
            return (IndexRange)this.cache.get((Object)index);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NotFoundException) {
                throw (NotFoundException)cause;
            }
            throw new NotFoundException(e.getCause());
        }
    }

    private IndexRange loadIndexRange(String index) throws NotFoundException {
        GetResponse r;
        GetRequest request = (GetRequest)this.client.prepareGet(index, "index_range", index).request();
        try {
            r = (GetResponse)this.client.get(request).actionGet();
        }
        catch (NoShardAvailableActionException | IndexNotFoundException e) {
            throw new NotFoundException(e);
        }
        if (!r.isExists()) {
            throw new NotFoundException("Couldn't find index range for index " + index);
        }
        IndexRange indexRange = this.parseSource(r.getIndex(), r.getSource());
        if (indexRange == null) {
            throw new NotFoundException("Couldn't parse index range for index " + index);
        }
        return indexRange;
    }

    @Nullable
    private IndexRange parseSource(String index, Map<String, Object> fields) {
        try {
            return EsIndexRange.create(index, this.parseFromDateString((String)fields.get("gl2_index_range_begin")), this.parseFromDateString((String)fields.get("gl2_index_range_end")), this.parseFromDateString((String)fields.get("gl2_index_range_calculated_at")), (Integer)fields.get("gl2_index_range_took_ms"));
        }
        catch (Exception e) {
            LOG.debug("Couldn't create index range from fields: " + fields);
            return null;
        }
    }

    private DateTime parseFromDateString(String s) {
        return DateTime.parse((String)s);
    }

    @Override
    public SortedSet<IndexRange> find(DateTime begin, DateTime end) {
        ImmutableSortedSet.Builder indexRanges = ImmutableSortedSet.orderedBy(IndexRange.COMPARATOR);
        for (IndexRange indexRange : this.findAll()) {
            if (indexRange.begin().getMillis() > end.getMillis() || indexRange.end().getMillis() < begin.getMillis()) continue;
            indexRanges.add((Object)indexRange);
        }
        return indexRanges.build();
    }

    @Override
    public SortedSet<IndexRange> findAll() {
        ImmutableSortedSet.Builder indexRanges = ImmutableSortedSet.orderedBy(IndexRange.COMPARATOR);
        for (String index : this.deflector.getAllDeflectorIndexNames()) {
            try {
                indexRanges.add(this.cache.get((Object)index));
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof NotFoundException) {
                    LOG.debug("Couldn't find index range for index " + index);
                    continue;
                }
                LOG.warn("Couldn't load index range for index " + index, cause);
            }
        }
        return indexRanges.build();
    }

    @Override
    public IndexRange calculateRange(String index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save(IndexRange indexRange) {
        throw new UnsupportedOperationException();
    }

    @Subscribe
    @AllowConcurrentEvents
    public void handleIndexDeletion(IndicesDeletedEvent event) {
        for (String index : event.indices()) {
            this.cache.invalidate((Object)index);
        }
        this.cache.cleanUp();
    }
}

