/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.initializers;

import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.Configuration;
import org.graylog2.buffers.Buffers;
import org.graylog2.indexer.cluster.Cluster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BufferSynchronizerService
extends AbstractIdleService {
    private static final Logger LOG = LoggerFactory.getLogger(BufferSynchronizerService.class);
    private final Buffers bufferSynchronizer;
    private final Cluster cluster;
    private final Configuration configuration;
    private final MetricRegistry metricRegistry;

    @Inject
    public BufferSynchronizerService(Buffers buffers, Cluster cluster, Configuration configuration, MetricRegistry metricRegistry) {
        this.bufferSynchronizer = buffers;
        this.cluster = cluster;
        this.configuration = configuration;
        this.metricRegistry = metricRegistry;
    }

    protected void startUp() throws Exception {
    }

    protected void shutDown() throws Exception {
        LOG.debug("Stopping BufferSynchronizerService");
        if (this.cluster.isConnected() && this.cluster.isHealthy()) {
            ExecutorService executorService = this.executorService(this.metricRegistry);
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    BufferSynchronizerService.this.bufferSynchronizer.waitForEmptyBuffers(BufferSynchronizerService.this.configuration.getShutdownTimeout(), TimeUnit.MILLISECONDS);
                }
            });
            executorService.shutdown();
            executorService.awaitTermination(this.configuration.getShutdownTimeout(), TimeUnit.MILLISECONDS);
        } else {
            LOG.warn("Elasticsearch is unavailable. Not waiting to clear buffers and caches, as we have no healthy cluster.");
        }
        LOG.debug("Stopped BufferSynchronizerService");
    }

    private ExecutorService executorService(MetricRegistry metricRegistry) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("buffer-synchronizer-%d").build();
        return new InstrumentedExecutorService(Executors.newSingleThreadExecutor(threadFactory), metricRegistry, MetricRegistry.name(((Object)((Object)this)).getClass(), (String[])new String[]{"executor-service"}));
    }
}

