/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.codecs;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.ResolvableInetSocketAddress;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.BooleanField;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.inputs.annotations.Codec;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.AbstractCodec;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.inputs.codecs.CodecAggregator;
import org.graylog2.plugin.journal.RawMessage;
import org.graylog2.syslog4j.server.SyslogServerEventIF;
import org.graylog2.syslog4j.server.impl.event.SyslogServerEvent;
import org.graylog2.syslog4j.server.impl.event.structured.StructuredSyslogServerEvent;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Codec(name="syslog", displayName="Syslog")
public class SyslogCodec
extends AbstractCodec {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogCodec.class);
    private static final Pattern STRUCTURED_SYSLOG_PATTERN = Pattern.compile("<\\d+>\\d.*", 32);
    public static final String CK_FORCE_RDNS = "force_rdns";
    public static final String CK_ALLOW_OVERRIDE_DATE = "allow_override_date";
    public static final String CK_EXPAND_STRUCTURED_DATA = "expand_structured_data";
    public static final String CK_STORE_FULL_MESSAGE = "store_full_message";
    private final Timer resolveTime;
    private final Timer decodeTime;

    @AssistedInject
    public SyslogCodec(@Assisted Configuration configuration, MetricRegistry metricRegistry) {
        super(configuration);
        this.resolveTime = metricRegistry.timer(MetricRegistry.name(SyslogCodec.class, (String[])new String[]{"resolveTime"}));
        this.decodeTime = metricRegistry.timer(MetricRegistry.name(SyslogCodec.class, (String[])new String[]{"decodeTime"}));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Message decode(@Nonnull RawMessage rawMessage) {
        String msg = new String(rawMessage.getPayload(), StandardCharsets.UTF_8);
        try (Timer.Context ignored = this.decodeTime.time();){
            ResolvableInetSocketAddress address = rawMessage.getRemoteAddress();
            InetSocketAddress remoteAddress = address == null ? null : address.getInetSocketAddress();
            Message message = this.parse(msg, remoteAddress == null ? null : remoteAddress.getAddress(), rawMessage.getTimestamp());
            return message;
        }
        catch (ClassCastException e) {
            Throwables.propagate((Throwable)e);
            return null;
        }
    }

    private Message parse(String msg, InetAddress remoteAddress, DateTime receivedTimestamp) {
        String structMessage;
        Object e = STRUCTURED_SYSLOG_PATTERN.matcher(msg).matches() ? new StructuredSyslogServerEvent(msg, remoteAddress) : new SyslogServerEvent(msg, remoteAddress);
        String syslogMessage = e instanceof StructuredSyslogServerEvent ? (Strings.isNullOrEmpty((String)(structMessage = e.getStructuredMessage().getMessage())) ? e.getMessage() : structMessage) : e.getMessage();
        Message m = new Message(syslogMessage, this.parseHost((SyslogServerEventIF)e, remoteAddress), this.parseDate((SyslogServerEventIF)e, receivedTimestamp));
        m.addField("facility", (Object)Tools.syslogFacilityToReadable((int)e.getFacility()));
        m.addField("level", (Object)e.getLevel());
        if (this.configuration.getBoolean(CK_STORE_FULL_MESSAGE)) {
            m.addField("full_message", (Object)new String(e.getRaw(), StandardCharsets.UTF_8));
        }
        boolean expandStructuredData = this.configuration.getBoolean(CK_EXPAND_STRUCTURED_DATA);
        m.addFields(this.parseAdditionalData((SyslogServerEventIF)e, expandStructuredData));
        return m;
    }

    private Map<String, Object> parseAdditionalData(SyslogServerEventIF msg, boolean expand) {
        if (msg instanceof StructuredSyslogServerEvent) {
            StructuredSyslogServerEvent sMsg = (StructuredSyslogServerEvent)msg;
            HashMap<String, Object> structuredData = new HashMap<String, Object>(this.extractFields(sMsg, expand));
            if (!Strings.isNullOrEmpty((String)sMsg.getApplicationName())) {
                structuredData.put("application_name", sMsg.getApplicationName());
            }
            if (!Strings.isNullOrEmpty((String)sMsg.getProcessId())) {
                structuredData.put("process_id", sMsg.getProcessId());
            }
            return structuredData;
        }
        return Collections.emptyMap();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String parseHost(SyslogServerEventIF msg, InetAddress remoteAddress) {
        if (remoteAddress == null) return msg.getHost();
        if (!this.configuration.getBoolean(CK_FORCE_RDNS)) return msg.getHost();
        try (Timer.Context ignored = this.resolveTime.time();){
            String string = Tools.rdnsLookup((InetAddress)remoteAddress);
            return string;
        }
        catch (UnknownHostException e) {
            LOG.warn("Reverse DNS lookup failed. Falling back to parsed hostname.", (Throwable)e);
        }
        return msg.getHost();
    }

    private DateTime parseDate(SyslogServerEventIF msg, DateTime receivedTimestamp) throws IllegalStateException {
        if (msg.getDate() == null) {
            if (this.configuration.getBoolean(CK_ALLOW_OVERRIDE_DATE)) {
                LOG.debug("Date could not be parsed. Was set to NOW because {} is true.", (Object)CK_ALLOW_OVERRIDE_DATE);
                return receivedTimestamp;
            }
            LOG.warn("Syslog message is missing date or date could not be parsed. (Possibly set {} to true) Not further handling. Message was: {}", (Object)CK_ALLOW_OVERRIDE_DATE, (Object)new String(msg.getRaw(), StandardCharsets.UTF_8));
            throw new IllegalStateException("Syslog message is missing date or date could not be parsed.");
        }
        return new DateTime((Object)msg.getDate());
    }

    @Nullable
    public CodecAggregator getAggregator() {
        return null;
    }

    @VisibleForTesting
    Map<String, Object> extractFields(StructuredSyslogServerEvent msg, boolean expand) {
        try {
            Map raw = msg.getStructuredMessage().getStructuredData();
            if (raw != null && !raw.isEmpty()) {
                HashMap<String, Object> fields = new HashMap<String, Object>();
                for (Map.Entry entry : raw.entrySet()) {
                    if (expand) {
                        fields.putAll(this.prefixElements((String)entry.getKey(), (Map)entry.getValue()));
                        continue;
                    }
                    fields.putAll((Map)entry.getValue());
                }
                return fields;
            }
        }
        catch (Exception e) {
            LOG.debug("Could not extract structured syslog", (Throwable)e);
        }
        return Collections.emptyMap();
    }

    private Map<String, String> prefixElements(String prefix, Map<String, String> elements) {
        if (elements == null || elements.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> prefixedMap = new HashMap<String, String>(elements.size());
        for (Map.Entry<String, String> entry : elements.entrySet()) {
            prefixedMap.put(prefix.trim() + "_" + entry.getKey(), entry.getValue());
        }
        return prefixedMap;
    }

    @ConfigClass
    public static class Config
    extends AbstractCodec.Config {
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest r = super.getRequestedConfiguration();
            r.addField((ConfigurationField)new BooleanField(SyslogCodec.CK_FORCE_RDNS, "Force rDNS?", false, "Force rDNS resolution of hostname? Use if hostname cannot be parsed."));
            r.addField((ConfigurationField)new BooleanField(SyslogCodec.CK_ALLOW_OVERRIDE_DATE, "Allow overriding date?", true, "Allow to override with current date if date could not be parsed?"));
            r.addField((ConfigurationField)new BooleanField(SyslogCodec.CK_STORE_FULL_MESSAGE, "Store full message?", false, "Store the full original syslog message as full_message?"));
            r.addField((ConfigurationField)new BooleanField(SyslogCodec.CK_EXPAND_STRUCTURED_DATA, "Expand structured data?", false, "Expand structured data elements by prefixing attributes with their SD-ID?"));
            return r;
        }

        public void overrideDefaultValues(@Nonnull ConfigurationRequest cr) {
            if (cr.containsField("port")) {
                cr.getField("port").setDefaultValue((Object)514);
            }
        }
    }

    @FactoryClass
    public static interface Factory
    extends Codec.Factory<SyslogCodec> {
        public SyslogCodec create(Configuration var1);

        public Config getConfig();
    }
}

