/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.codecs.gelf;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.graylog2.plugin.ResolvableInetSocketAddress;
import org.graylog2.plugin.Tools;

public class GELFMessage {
    private final byte[] payload;
    private final ResolvableInetSocketAddress sourceAddress;

    public GELFMessage(byte[] payload) {
        this(payload, null);
    }

    public GELFMessage(byte[] payload, ResolvableInetSocketAddress sourceAddress) {
        this.payload = payload;
        this.sourceAddress = sourceAddress;
    }

    public Type getGELFType() {
        if (this.payload.length < 2) {
            throw new IllegalStateException("GELF message is too short. Not even the type header would fit.");
        }
        return Type.determineType(this.payload[0], this.payload[1]);
    }

    public String getJSON() {
        try {
            switch (this.getGELFType()) {
                case ZLIB: {
                    return Tools.decompressZlib((byte[])this.payload);
                }
                case GZIP: {
                    return Tools.decompressGzip((byte[])this.payload);
                }
                case UNCOMPRESSED: {
                    return new String(this.payload, StandardCharsets.UTF_8);
                }
                case CHUNKED: 
                case UNSUPPORTED: {
                    throw new IllegalStateException("Unknown GELF type. Not supported.");
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to decompress the GELF message payload", e);
        }
        return null;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    @Nullable
    public ResolvableInetSocketAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public static enum Type {
        UNSUPPORTED(0, 0),
        ZLIB(120, -100),
        GZIP(31, -117),
        CHUNKED(30, 15),
        UNCOMPRESSED(-1, -1);

        private static final int HEADER_SIZE = 2;
        private final byte[] bytes;

        private Type(byte first, byte second) {
            this.bytes = new byte[]{first, second};
        }

        static Type determineType(byte first, byte second) {
            if (first == ZLIB.first()) {
                int secondInt = ZLIB.second();
                if (second < 0) {
                    secondInt += 256;
                }
                if ((256 * first + secondInt) % 31 == 0) {
                    return ZLIB;
                }
                return UNSUPPORTED;
            }
            if (first == GZIP.first()) {
                if (second == GZIP.second()) {
                    return GZIP;
                }
                return UNSUPPORTED;
            }
            if (first == CHUNKED.first()) {
                if (second == CHUNKED.second()) {
                    return CHUNKED;
                }
                return UNSUPPORTED;
            }
            return UNCOMPRESSED;
        }

        public byte first() {
            return this.bytes[0];
        }

        public byte second() {
            return this.bytes[1];
        }
    }
}

