/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.converters;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import java.util.Map;
import org.graylog2.plugin.inputs.Converter;
import org.joda.time.DateTimeZone;

public abstract class AbstractDateConverter
extends Converter {
    private static final DateTimeZone DEFAULT_TIME_ZONE = DateTimeZone.forID((String)"Etc/UTC");
    protected final DateTimeZone timeZone;

    public AbstractDateConverter(Converter.Type type, Map<String, Object> config) {
        super(type, config);
        this.timeZone = AbstractDateConverter.buildTimeZone(config.get("time_zone"));
    }

    private static DateTimeZone buildTimeZone(Object timeZoneId) {
        if (timeZoneId instanceof String) {
            try {
                String timeZoneString = (String)timeZoneId;
                String zoneId = (String)MoreObjects.firstNonNull((Object)Strings.emptyToNull((String)timeZoneString.trim()), (Object)"Etc/UTC");
                return DateTimeZone.forID((String)zoneId);
            }
            catch (IllegalArgumentException e) {
                return DEFAULT_TIME_ZONE;
            }
        }
        return DEFAULT_TIME_ZONE;
    }

    public boolean buildsMultipleFields() {
        return false;
    }
}

