/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.misc.metrics.agent;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.graylog2.inputs.misc.metrics.agent.GELFTarget;

public class Graylog2Reporter
extends ScheduledReporter {
    private final GELFTarget sender;
    private final String source;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private Graylog2Reporter(MetricRegistry registry, GELFTarget sender, Clock clock, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter, String source) {
        super(registry, "graylog2-reporter", filter, rateUnit, durationUnit);
        this.sender = sender;
        this.source = source;
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        this.reportGauges(gauges);
        this.reportCounters(counters);
        this.reportHistograms(histograms);
        this.reportMeters(meters);
        this.reportTimers(timers);
    }

    private void reportMeters(SortedMap<String, Meter> meters) {
        for (Map.Entry<String, Meter> x : meters.entrySet()) {
            Meter meter = x.getValue();
            HashMap fields = Maps.newHashMap();
            fields.put("count", meter.getCount());
            fields.put("mean_rate", this.convertRate(meter.getMeanRate()));
            fields.put("one_minute_rate", this.convertRate(meter.getOneMinuteRate()));
            fields.put("five_minute_rate", this.convertRate(meter.getFiveMinuteRate()));
            fields.put("fifteen_minute_rate", this.convertRate(meter.getFifteenMinuteRate()));
            fields.put("name", x.getKey());
            fields.put("metrics_type", "meter");
            fields.put("type", "metrics");
            this.sender.deliver(this.buildShortMessage(x.getKey()), this.source, fields);
        }
    }

    private void reportGauges(SortedMap<String, Gauge> gauges) {
        for (Map.Entry<String, Gauge> x : gauges.entrySet()) {
            Gauge gauge = x.getValue();
            HashMap fields = Maps.newHashMap();
            fields.put("value", gauge.getValue());
            fields.put("name", x.getKey());
            fields.put("metrics_type", "gauge");
            fields.put("type", "metrics");
            this.sender.deliver(this.buildShortMessage(x.getKey()), this.source, fields);
        }
    }

    private void reportCounters(SortedMap<String, Counter> counters) {
        for (Map.Entry<String, Counter> x : counters.entrySet()) {
            Counter counter = x.getValue();
            HashMap fields = Maps.newHashMap();
            fields.put("count", counter.getCount());
            fields.put("name", x.getKey());
            fields.put("metrics_type", "counter");
            fields.put("type", "metrics");
            this.sender.deliver(this.buildShortMessage(x.getKey()), this.source, fields);
        }
    }

    private void reportHistograms(SortedMap<String, Histogram> histograms) {
        for (Map.Entry<String, Histogram> x : histograms.entrySet()) {
            Snapshot snapshot = x.getValue().getSnapshot();
            HashMap fields = Maps.newHashMap();
            fields.put("count", x.getValue().getCount());
            fields.put("75th_percentile", snapshot.get75thPercentile());
            fields.put("95th_percentile", snapshot.get95thPercentile());
            fields.put("98th_percentile", snapshot.get98thPercentile());
            fields.put("999th_percentile", snapshot.get999thPercentile());
            fields.put("99th_percentile", snapshot.get99thPercentile());
            fields.put("max", snapshot.getMax());
            fields.put("mean", snapshot.getMean());
            fields.put("median", snapshot.getMedian());
            fields.put("min", snapshot.getMin());
            fields.put("std_deviation", snapshot.getStdDev());
            fields.put("name", x.getKey());
            fields.put("metrics_type", "histogram");
            fields.put("type", "metrics");
            this.sender.deliver(this.buildShortMessage(x.getKey()), this.source, fields);
        }
    }

    private void reportTimers(SortedMap<String, Timer> timers) {
        for (Map.Entry<String, Timer> x : timers.entrySet()) {
            Timer timer = x.getValue();
            Snapshot snapshot = timer.getSnapshot();
            HashMap fields = Maps.newHashMap();
            fields.put("count", timer.getCount());
            fields.put("one_minute_rate", this.convertRate(timer.getOneMinuteRate()));
            fields.put("five_minute_rate", this.convertRate(timer.getFiveMinuteRate()));
            fields.put("fifteen_minute_rate", this.convertRate(timer.getFifteenMinuteRate()));
            fields.put("mean_rate", this.convertRate(timer.getMeanRate()));
            fields.put("75th_percentile", this.convertDuration(snapshot.get75thPercentile()));
            fields.put("95th_percentile", this.convertDuration(snapshot.get95thPercentile()));
            fields.put("98th_percentile", this.convertDuration(snapshot.get98thPercentile()));
            fields.put("999th_percentile", this.convertDuration(snapshot.get999thPercentile()));
            fields.put("99th_percentile", this.convertDuration(snapshot.get99thPercentile()));
            fields.put("max", this.convertDuration(snapshot.getMax()));
            fields.put("mean", this.convertDuration(snapshot.getMean()));
            fields.put("median", this.convertDuration(snapshot.getMedian()));
            fields.put("min", this.convertDuration(snapshot.getMin()));
            fields.put("std_deviation", this.convertDuration(snapshot.getStdDev()));
            fields.put("name", x.getKey());
            fields.put("metrics_type", "timer");
            fields.put("type", "metrics");
            this.sender.deliver(this.buildShortMessage(x.getKey()), this.source, fields);
        }
    }

    public String buildShortMessage(String name) {
        return "metrics";
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Clock clock;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;
        private String source;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.clock = Clock.defaultClock();
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
            this.source = "metrics";
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder useSource(String source) {
            this.source = source;
            return this;
        }

        public Graylog2Reporter build(GELFTarget sender) {
            return new Graylog2Reporter(this.registry, sender, this.clock, this.rateUnit, this.durationUnit, this.filter, this.source);
        }
    }
}

