/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import javax.inject.Inject;
import org.graylog2.alarmcallbacks.AlarmCallbackConfigurationAVImpl;
import org.graylog2.database.CollectionName;
import org.graylog2.database.MongoConnection;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmCallbacksMigrationPeriodical
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmCallbacksMigrationPeriodical.class);
    private final DBCollection dbCollection;

    @Inject
    public AlarmCallbacksMigrationPeriodical(MongoConnection mongoConnection) {
        String collectionName = AlarmCallbackConfigurationAVImpl.class.getAnnotation(CollectionName.class).value();
        this.dbCollection = mongoConnection.getDatabase().getCollection(collectionName);
    }

    public void doRun() {
        LOG.debug("Starting alarm callbacks migration");
        DBObject selection = QueryBuilder.start((String)"id").exists((Object)true).get();
        BasicDBObject modifications = new BasicDBObject("$unset", (Object)new BasicDBObject("id", (Object)""));
        this.dbCollection.updateMulti(selection, (DBObject)modifications);
        LOG.debug("Done with alarm callbacks migration");
    }

    public boolean runsForever() {
        return true;
    }

    public boolean stopOnGracefulShutdown() {
        return false;
    }

    public boolean masterOnly() {
        return true;
    }

    public boolean startOnThisNode() {
        return true;
    }

    public boolean isDaemon() {
        return false;
    }

    public int getInitialDelaySeconds() {
        return 0;
    }

    public int getPeriodSeconds() {
        return 0;
    }

    protected Logger getLogger() {
        return LOG;
    }
}

