/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import javax.inject.Inject;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.management.IndexManagementConfig;
import org.graylog2.indexer.retention.strategies.ClosingRetentionStrategy;
import org.graylog2.indexer.retention.strategies.ClosingRetentionStrategyConfig;
import org.graylog2.indexer.retention.strategies.DeletionRetentionStrategy;
import org.graylog2.indexer.retention.strategies.DeletionRetentionStrategyConfig;
import org.graylog2.indexer.rotation.strategies.MessageCountRotationStrategy;
import org.graylog2.indexer.rotation.strategies.MessageCountRotationStrategyConfig;
import org.graylog2.indexer.rotation.strategies.SizeBasedRotationStrategy;
import org.graylog2.indexer.rotation.strategies.SizeBasedRotationStrategyConfig;
import org.graylog2.indexer.rotation.strategies.TimeBasedRotationStrategy;
import org.graylog2.indexer.rotation.strategies.TimeBasedRotationStrategyConfig;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationManagementPeriodical
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationManagementPeriodical.class);
    private final ElasticsearchConfiguration elasticsearchConfiguration;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public ConfigurationManagementPeriodical(ElasticsearchConfiguration elasticsearchConfiguration, ClusterConfigService clusterConfigService) {
        this.elasticsearchConfiguration = elasticsearchConfiguration;
        this.clusterConfigService = clusterConfigService;
    }

    public void migrateElasticsearchConfig() {
        Class retentionStrategyClass;
        Class rotationStrategyClass;
        MessageCountRotationStrategyConfig messageCountRotationStrategyConfig = (MessageCountRotationStrategyConfig)this.clusterConfigService.get(MessageCountRotationStrategyConfig.class);
        SizeBasedRotationStrategyConfig sizeBasedRotationStrategyConfig = (SizeBasedRotationStrategyConfig)this.clusterConfigService.get(SizeBasedRotationStrategyConfig.class);
        TimeBasedRotationStrategyConfig timeBasedRotationStrategyConfig = (TimeBasedRotationStrategyConfig)this.clusterConfigService.get(TimeBasedRotationStrategyConfig.class);
        MessageCountRotationStrategyConfig countConfig = MessageCountRotationStrategyConfig.create(this.elasticsearchConfiguration.getMaxDocsPerIndex());
        this.clusterConfigService.write((Object)countConfig);
        LOG.info("Migrated \"{}\" setting: {}", (Object)"elasticsearch_max_docs_per_index", (Object)countConfig);
        SizeBasedRotationStrategyConfig sizeConfig = SizeBasedRotationStrategyConfig.create(this.elasticsearchConfiguration.getMaxSizePerIndex());
        this.clusterConfigService.write((Object)sizeConfig);
        LOG.info("Migrated \"{}\" setting: {}", (Object)"elasticsearch_max_size_per_index", (Object)sizeConfig);
        TimeBasedRotationStrategyConfig timeConfig = TimeBasedRotationStrategyConfig.create(this.elasticsearchConfiguration.getMaxTimePerIndex());
        this.clusterConfigService.write((Object)timeConfig);
        LOG.info("Migrated \"{}\" setting: {}", (Object)"elasticsearch_max_time_per_index", (Object)timeConfig);
        ClosingRetentionStrategyConfig closingRetentionStrategyConfig = (ClosingRetentionStrategyConfig)this.clusterConfigService.get(ClosingRetentionStrategyConfig.class);
        DeletionRetentionStrategy deletionRetentionStrategy = (DeletionRetentionStrategy)this.clusterConfigService.get(DeletionRetentionStrategy.class);
        ClosingRetentionStrategyConfig closingConfig = ClosingRetentionStrategyConfig.create(this.elasticsearchConfiguration.getMaxNumberOfIndices());
        this.clusterConfigService.write((Object)closingConfig);
        LOG.info("Migrated \"{}\" setting: {}", (Object)"elasticsearch_max_number_of_indices", (Object)closingConfig);
        DeletionRetentionStrategyConfig deletionConfig = DeletionRetentionStrategyConfig.create(this.elasticsearchConfiguration.getMaxNumberOfIndices());
        this.clusterConfigService.write((Object)deletionConfig);
        LOG.info("Migrated \"{}\" setting: {}", (Object)"elasticsearch_max_number_of_indices", (Object)deletionConfig);
        IndexManagementConfig indexManagementConfig = (IndexManagementConfig)this.clusterConfigService.get(IndexManagementConfig.class);
        switch (this.elasticsearchConfiguration.getRotationStrategy()) {
            case "size": {
                rotationStrategyClass = SizeBasedRotationStrategy.class;
                break;
            }
            case "time": {
                rotationStrategyClass = TimeBasedRotationStrategy.class;
                break;
            }
            default: {
                rotationStrategyClass = MessageCountRotationStrategy.class;
            }
        }
        switch (this.elasticsearchConfiguration.getRetentionStrategy()) {
            case "close": {
                retentionStrategyClass = ClosingRetentionStrategy.class;
                break;
            }
            default: {
                retentionStrategyClass = DeletionRetentionStrategy.class;
            }
        }
        IndexManagementConfig config = IndexManagementConfig.create(rotationStrategyClass.getCanonicalName(), retentionStrategyClass.getCanonicalName());
        this.clusterConfigService.write((Object)config);
        LOG.info("Migrated \"{}\" and \"{}\" setting: {}", new Object[]{"rotation_strategy", "retention_strategy", config});
    }

    public void doRun() {
        this.migrateElasticsearchConfig();
    }

    public boolean runsForever() {
        return true;
    }

    public boolean stopOnGracefulShutdown() {
        return false;
    }

    public boolean masterOnly() {
        return true;
    }

    public boolean startOnThisNode() {
        return true;
    }

    public boolean isDaemon() {
        return true;
    }

    public int getInitialDelaySeconds() {
        return 0;
    }

    public int getPeriodSeconds() {
        return 0;
    }

    protected Logger getLogger() {
        return LOG;
    }
}

