/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Provider;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.cluster.Cluster;
import org.graylog2.indexer.management.IndexManagementConfig;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.indexer.retention.RetentionStrategy;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexRetentionThread
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(IndexRetentionThread.class);
    private final ElasticsearchConfiguration configuration;
    private final Cluster cluster;
    private final ClusterConfigService clusterConfigService;
    private final Map<String, Provider<RetentionStrategy>> retentionStrategyMap;

    @Inject
    public IndexRetentionThread(ElasticsearchConfiguration configuration, Cluster cluster, ClusterConfigService clusterConfigService, Map<String, Provider<RetentionStrategy>> retentionStrategyMap) {
        this.configuration = configuration;
        this.cluster = cluster;
        this.clusterConfigService = clusterConfigService;
        this.retentionStrategyMap = retentionStrategyMap;
    }

    public void doRun() {
        if (!this.cluster.isConnected() || !this.cluster.isHealthy()) {
            LOG.info("Elasticsearch cluster not available, skipping index retention checks.");
            return;
        }
        IndexManagementConfig config = (IndexManagementConfig)this.clusterConfigService.get(IndexManagementConfig.class);
        if (config == null) {
            LOG.warn("No index management configuration found, not running index retention!");
            return;
        }
        Provider<RetentionStrategy> retentionStrategyProvider = this.retentionStrategyMap.get(config.retentionStrategy());
        if (retentionStrategyProvider == null) {
            LOG.warn("Retention strategy \"{}\" not found, not running index retention!", (Object)config.retentionStrategy());
            return;
        }
        RetentionStrategy retentionStrategy = (RetentionStrategy)retentionStrategyProvider.get();
        retentionStrategy.retain();
    }

    protected Logger getLogger() {
        return LOG;
    }

    public boolean runsForever() {
        return false;
    }

    public boolean stopOnGracefulShutdown() {
        return true;
    }

    public boolean masterOnly() {
        return true;
    }

    public boolean startOnThisNode() {
        return this.configuration.performRetention();
    }

    public boolean isDaemon() {
        return false;
    }

    public int getInitialDelaySeconds() {
        return 0;
    }

    public int getPeriodSeconds() {
        return (int)TimeUnit.MINUTES.toSeconds(5L);
    }
}

