/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.alarmcallbacks;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.alarmcallbacks.AlarmCallbackConfiguration;
import org.graylog2.alarmcallbacks.AlarmCallbackConfigurationAVImpl;
import org.graylog2.alarmcallbacks.AlarmCallbackConfigurationService;
import org.graylog2.alarmcallbacks.AlarmCallbackFactory;
import org.graylog2.plugin.alarms.callbacks.AlarmCallback;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.rest.models.alarmcallbacks.AlarmCallbackListSummary;
import org.graylog2.rest.models.alarmcallbacks.AlarmCallbackSummary;
import org.graylog2.rest.models.alarmcallbacks.requests.CreateAlarmCallbackRequest;
import org.graylog2.rest.models.alarmcallbacks.responses.AvailableAlarmCallbackSummaryResponse;
import org.graylog2.rest.models.alarmcallbacks.responses.AvailableAlarmCallbacksResponse;
import org.graylog2.rest.models.alarmcallbacks.responses.CreateAlarmCallbackResponse;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.StreamService;
import org.graylog2.utilities.ConfigurationMapConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="AlarmCallbacks", description="Manage stream alarm callbacks")
@Path(value="/streams/{streamid}/alarmcallbacks")
public class AlarmCallbackResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmCallbackResource.class);
    private final AlarmCallbackConfigurationService alarmCallbackConfigurationService;
    private final StreamService streamService;
    private final Set<AlarmCallback> availableAlarmCallbacks;
    private final AlarmCallbackFactory alarmCallbackFactory;

    @Inject
    public AlarmCallbackResource(AlarmCallbackConfigurationService alarmCallbackConfigurationService, StreamService streamService, Set<AlarmCallback> availableAlarmCallbacks, AlarmCallbackFactory alarmCallbackFactory) {
        this.alarmCallbackConfigurationService = alarmCallbackConfigurationService;
        this.streamService = streamService;
        this.availableAlarmCallbacks = availableAlarmCallbacks;
        this.alarmCallbackFactory = alarmCallbackFactory;
    }

    @GET
    @Timed
    @ApiOperation(value="Get a list of all alarm callbacks for this stream")
    @Produces(value={"application/json"})
    public AlarmCallbackListSummary get(@ApiParam(name="streamid", value="The id of the stream whose alarm callbacks we want.", required=true) @PathParam(value="streamid") String streamid) throws org.graylog2.database.NotFoundException {
        this.checkPermission("streams:read", streamid);
        Stream stream = this.streamService.load(streamid);
        ArrayList alarmCallbacks = Lists.newArrayList();
        for (AlarmCallbackConfiguration callback : this.alarmCallbackConfigurationService.getForStream(stream)) {
            alarmCallbacks.add(AlarmCallbackSummary.create(callback.getId(), callback.getStreamId(), callback.getType(), callback.getConfiguration(), callback.getCreatedAt(), callback.getCreatorUserId()));
        }
        return AlarmCallbackListSummary.create(alarmCallbacks);
    }

    @GET
    @Path(value="/{alarmCallbackId}")
    @Timed
    @ApiOperation(value="Get a single specified alarm callback for this stream")
    @Produces(value={"application/json"})
    public AlarmCallbackSummary get(@ApiParam(name="streamid", value="The id of the stream whose alarm callbacks we want.", required=true) @PathParam(value="streamid") String streamid, @ApiParam(name="alarmCallbackId", value="The alarm callback id we are getting", required=true) @PathParam(value="alarmCallbackId") String alarmCallbackId) throws org.graylog2.database.NotFoundException {
        this.checkPermission("streams:read", streamid);
        Stream stream = this.streamService.load(streamid);
        AlarmCallbackConfiguration result = this.alarmCallbackConfigurationService.load(alarmCallbackId);
        if (result == null || !result.getStreamId().equals(stream.getId())) {
            throw new NotFoundException();
        }
        return AlarmCallbackSummary.create(result.getId(), result.getStreamId(), result.getType(), result.getConfiguration(), result.getCreatedAt(), result.getCreatorUserId());
    }

    @POST
    @Timed
    @ApiOperation(value="Create an alarm callback", response=CreateAlarmCallbackResponse.class)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(@ApiParam(name="streamid", value="The stream id this new alarm callback belongs to.", required=true) @PathParam(value="streamid") String streamid, @ApiParam(name="JSON body", required=true) CreateAlarmCallbackRequest cr) throws org.graylog2.database.NotFoundException {
        String id;
        this.checkPermission("streams:edit", streamid);
        cr.configuration = this.convertConfigurationValues(cr);
        AlarmCallbackConfiguration alarmCallbackConfiguration = this.alarmCallbackConfigurationService.create(streamid, cr, this.getCurrentUser().getName());
        try {
            id = this.alarmCallbackConfigurationService.save(alarmCallbackConfiguration);
        }
        catch (ValidationException e) {
            LOG.error("Validation error.", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
        URI alarmCallbackUri = this.getUriBuilderToSelf().path(AlarmCallbackResource.class).path("{alarmCallbackId}").build(new Object[]{streamid, id});
        return Response.created((URI)alarmCallbackUri).entity((Object)CreateAlarmCallbackResponse.create(id)).build();
    }

    @GET
    @Path(value="/available")
    @Timed
    @ApiOperation(value="Get a list of all alarm callback types")
    @Produces(value={"application/json"})
    public AvailableAlarmCallbacksResponse available(@ApiParam(name="streamid", value="The id of the stream whose alarm callbacks we want.", required=true) @PathParam(value="streamid") String streamid) {
        this.checkPermission("streams:read", streamid);
        HashMap types = Maps.newHashMapWithExpectedSize((int)this.availableAlarmCallbacks.size());
        for (AlarmCallback availableAlarmCallback : this.availableAlarmCallbacks) {
            AvailableAlarmCallbackSummaryResponse type = new AvailableAlarmCallbackSummaryResponse();
            type.name = availableAlarmCallback.getName();
            type.requested_configuration = availableAlarmCallback.getRequestedConfiguration().asList();
            types.put(availableAlarmCallback.getClass().getCanonicalName(), type);
        }
        AvailableAlarmCallbacksResponse response = new AvailableAlarmCallbacksResponse();
        response.types = types;
        return response;
    }

    @DELETE
    @Path(value="/{alarmCallbackId}")
    @Timed
    @ApiOperation(value="Delete an alarm callback")
    @ApiResponses(value={@ApiResponse(code=404, message="Alarm callback not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    public void delete(@ApiParam(name="streamid", value="The stream id this alarm callback belongs to.", required=true) @PathParam(value="streamid") String streamid, @ApiParam(name="alarmCallbackId", required=true) @PathParam(value="alarmCallbackId") String alarmCallbackId) throws org.graylog2.database.NotFoundException {
        this.checkPermission("streams:edit", streamid);
        Stream stream = this.streamService.load(streamid);
        AlarmCallbackConfiguration result = this.alarmCallbackConfigurationService.load(alarmCallbackId);
        if (result == null || !result.getStreamId().equals(stream.getId())) {
            throw new NotFoundException();
        }
        if (this.alarmCallbackConfigurationService.destroy(result) == 0) {
            LOG.error("Couldn't remove alarm callback with id {}", (Object)result.getId());
            throw new InternalServerErrorException();
        }
    }

    @PUT
    @Path(value="/{alarmCallbackId}")
    @Timed
    @ApiOperation(value="Update an alarm callback")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void update(@ApiParam(name="streamid", value="The stream id this alarm callback belongs to.", required=true) @PathParam(value="streamid") String streamid, @ApiParam(name="alarmCallbackId", required=true) @PathParam(value="alarmCallbackId") String alarmCallbackId, @ApiParam(name="JSON body", required=true) CreateAlarmCallbackRequest alarmCallbackRequest) throws org.graylog2.database.NotFoundException {
        this.checkPermission("streams:edit", streamid);
        AlarmCallbackConfiguration aCC = this.alarmCallbackConfigurationService.load(alarmCallbackId);
        if (aCC == null) {
            throw new org.graylog2.database.NotFoundException("Unable to find alarm callback configuration " + alarmCallbackId);
        }
        Map<String, Object> configuration = this.convertConfigurationValues(alarmCallbackRequest);
        AlarmCallbackConfigurationAVImpl newConfig = AlarmCallbackConfigurationAVImpl.create(alarmCallbackId, aCC.getStreamId(), aCC.getType(), configuration, aCC.getCreatedAt(), aCC.getCreatorUserId());
        try {
            this.alarmCallbackConfigurationService.save(newConfig);
        }
        catch (ValidationException e) {
            throw new BadRequestException("Unable to save alarm callback configuration", (Throwable)e);
        }
    }

    private Map<String, Object> convertConfigurationValues(CreateAlarmCallbackRequest alarmCallbackRequest) {
        Map<String, Object> configuration;
        ConfigurationRequest requestedConfiguration;
        try {
            AlarmCallback alarmCallback = this.alarmCallbackFactory.create(alarmCallbackRequest.type);
            requestedConfiguration = alarmCallback.getRequestedConfiguration();
        }
        catch (ClassNotFoundException e) {
            throw new BadRequestException("Unable to load alarm callback of type " + alarmCallbackRequest.type, (Throwable)e);
        }
        try {
            configuration = ConfigurationMapConverter.convertValues(alarmCallbackRequest.configuration, requestedConfiguration);
        }
        catch (ValidationException e) {
            throw new BadRequestException("Invalid configuration map", (Throwable)e);
        }
        return configuration;
    }
}

