/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.cluster;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Optional;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.rest.models.system.inputs.responses.InputCreated;
import org.graylog2.rest.models.system.inputs.responses.InputDeleted;
import org.graylog2.rest.models.system.inputs.responses.InputStateSummary;
import org.graylog2.rest.models.system.inputs.responses.InputStatesList;
import org.graylog2.rest.resources.system.inputs.RemoteInputStatesResource;
import org.graylog2.shared.rest.resources.ProxiedResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

@RequiresAuthentication
@Api(value="Cluster/InputState", description="Cluster-wide input states")
@Path(value="/cluster/inputstates")
@Produces(value={"application/json"})
public class ClusterInputStatesResource
extends ProxiedResource {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterInputStatesResource.class);
    private final NodeService nodeService;
    private final RemoteInterfaceProvider remoteInterfaceProvider;

    @Inject
    public ClusterInputStatesResource(NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, @Context HttpHeaders httpHeaders) throws NodeNotFoundException {
        super(httpHeaders);
        this.nodeService = nodeService;
        this.remoteInterfaceProvider = remoteInterfaceProvider;
    }

    @GET
    @Timed
    @ApiOperation(value="Get all input states")
    @RequiresPermissions(value={"inputs:read"})
    public Map<String, Set<InputStateSummary>> get() {
        Map<String, Node> nodes = this.nodeService.allActive();
        return ((Stream)nodes.entrySet().stream().parallel()).collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            RemoteInputStatesResource remoteInputStatesResource = this.remoteInterfaceProvider.get((Node)entry.getValue(), this.authenticationToken, RemoteInputStatesResource.class);
            try {
                Response response = remoteInputStatesResource.list().execute();
                if (response.isSuccess()) {
                    return ((InputStatesList)response.body()).states();
                }
                LOG.warn("Unable to fetch input states from node {}: {}", entry.getKey(), (Object)response.message());
            }
            catch (IOException e) {
                LOG.warn("Unable to fetch input states from node {}:", entry.getKey(), (Object)e);
            }
            return Collections.emptySet();
        }));
    }

    @PUT
    @Path(value="/{inputId}")
    @Timed
    @ApiOperation(value="Start or restart specified input in all nodes")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input.")})
    public Map<String, Optional<InputCreated>> start(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) {
        Map<String, Node> nodes = this.nodeService.allActive();
        return ((Stream)nodes.entrySet().stream().parallel()).collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            RemoteInputStatesResource remoteInputStatesResource = this.remoteInterfaceProvider.get((Node)entry.getValue(), this.authenticationToken, RemoteInputStatesResource.class);
            try {
                Response response = remoteInputStatesResource.start(inputId).execute();
                if (response.isSuccess()) {
                    return Optional.of((Object)response.body());
                }
                LOG.warn("Unable to start input on node {}: {}", entry.getKey(), (Object)response.message());
            }
            catch (IOException e) {
                LOG.warn("Unable to start input on node {}:", entry.getKey(), (Object)e);
            }
            return Optional.absent();
        }));
    }

    @DELETE
    @Path(value="/{inputId}")
    @Timed
    @ApiOperation(value="Stop specified input in all nodes")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input.")})
    public Map<String, Optional<InputDeleted>> stop(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) {
        Map<String, Node> nodes = this.nodeService.allActive();
        return ((Stream)nodes.entrySet().stream().parallel()).collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            RemoteInputStatesResource remoteInputStatesResource = this.remoteInterfaceProvider.get((Node)entry.getValue(), this.authenticationToken, RemoteInputStatesResource.class);
            try {
                Response response = remoteInputStatesResource.stop(inputId).execute();
                if (response.isSuccess()) {
                    return Optional.of((Object)response.body());
                }
                LOG.warn("Unable to stop input on node {}: {}", entry.getKey(), (Object)response.message());
            }
            catch (IOException e) {
                LOG.warn("Unable to stop input on node {}:", entry.getKey(), (Object)e);
            }
            return Optional.absent();
        }));
    }
}

