/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.search;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.database.NotFoundException;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.rest.resources.search.SearchResource;
import org.graylog2.rest.resources.search.requests.CreateSavedSearchRequest;
import org.graylog2.savedsearches.SavedSearch;
import org.graylog2.savedsearches.SavedSearchService;

@RequiresAuthentication
@Api(value="Search/Saved", description="Saved searches")
@Path(value="/search/saved")
public class SavedSearchesResource
extends SearchResource {
    private final SavedSearchService savedSearchService;

    @Inject
    public SavedSearchesResource(Searches searches, SavedSearchService savedSearchService) {
        super(searches);
        this.savedSearchService = savedSearchService;
    }

    @POST
    @Timed
    @ApiOperation(value="Create a new saved search")
    @RequiresPermissions(value={"savedsearches:create"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiResponse(code=400, message="Validation error")
    public Response create(@ApiParam(name="JSON body", required=true) @Valid CreateSavedSearchRequest cr) throws ValidationException {
        if (!this.isTitleTaken("", cr.title())) {
            String msg = "Cannot save search " + cr.title() + ". Title is already taken.";
            throw new BadRequestException(msg);
        }
        SavedSearch search = this.savedSearchService.create(cr.title(), cr.query(), this.getCurrentUser().getName(), Tools.nowUTC());
        String id = this.savedSearchService.save(search);
        URI searchUri = this.getUriBuilderToSelf().path(SavedSearchesResource.class).path("{searchId}").build(new Object[]{id});
        return Response.created((URI)searchUri).build();
    }

    @GET
    @Timed
    @ApiOperation(value="Get a list of all saved searches")
    @Produces(value={"application/json"})
    public Map<String, Object> list() {
        ArrayList searches = Lists.newArrayList();
        for (SavedSearch search : this.savedSearchService.all()) {
            if (!this.isPermitted("savedsearches:read", search.getId())) continue;
            searches.add(search.asMap());
        }
        return ImmutableMap.of((Object)"total", (Object)searches.size(), (Object)"searches", (Object)searches);
    }

    @PUT
    @Path(value="/{searchId}")
    @Timed
    @RequiresPermissions(value={"savedsearches:edit"})
    @ApiOperation(value="Update a saved search")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="Saved search not found."), @ApiResponse(code=400, message="Invalid ObjectId."), @ApiResponse(code=400, message="Validation error")})
    public Map<String, Object> update(@ApiParam(name="searchId", required=true) @PathParam(value="searchId") String searchId, @ApiParam(name="JSON body", required=true) @Valid CreateSavedSearchRequest cr) throws NotFoundException, ValidationException {
        SavedSearch search = this.savedSearchService.load(searchId);
        if (!this.isTitleTaken(searchId, cr.title())) {
            String msg = "Cannot save search " + cr.title() + ". Title is already taken.";
            throw new BadRequestException(msg);
        }
        this.savedSearchService.update(search, cr.title(), cr.query());
        return search.asMap();
    }

    @GET
    @Path(value="/{searchId}")
    @Timed
    @ApiOperation(value="Get a single saved search")
    @ApiResponses(value={@ApiResponse(code=404, message="Saved search not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    public Map<String, Object> get(@ApiParam(name="searchId", required=true) @PathParam(value="searchId") String searchId) throws NotFoundException {
        this.checkPermission("savedsearches:read", searchId);
        return this.savedSearchService.load(searchId).asMap();
    }

    @DELETE
    @Path(value="/{searchId}")
    @Timed
    @ApiOperation(value="Delete a saved search")
    @ApiResponses(value={@ApiResponse(code=404, message="Saved search not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    public void delete(@ApiParam(name="searchId", required=true) @PathParam(value="searchId") String searchId) throws NotFoundException {
        this.checkPermission("savedsearches:edit", searchId);
        SavedSearch search = this.savedSearchService.load(searchId);
        this.savedSearchService.destroy(search);
    }

    private boolean isTitleTaken(String searchId, String title) {
        for (SavedSearch savedSearch : this.savedSearchService.all()) {
            if (savedSearch.getId().equals(searchId) || !savedSearch.getTitle().equals(title)) continue;
            return false;
        }
        return true;
    }
}

