/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.Configuration;
import org.graylog2.buffers.OutputBuffer;
import org.graylog2.plugin.buffers.InputBuffer;
import org.graylog2.rest.models.system.buffers.responses.BufferClasses;
import org.graylog2.rest.models.system.buffers.responses.BuffersUtilizationSummary;
import org.graylog2.rest.models.system.buffers.responses.RingSummary;
import org.graylog2.rest.models.system.buffers.responses.SingleRingUtilization;
import org.graylog2.shared.buffers.ProcessBuffer;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="System/Buffers", description="Buffer information of this node.")
@Path(value="/system/buffers")
@Produces(value={"application/json"})
public class BuffersResource
extends RestResource {
    private final Configuration configuration;
    private final InputBuffer inputBuffer;
    private final ProcessBuffer processBuffer;
    private final OutputBuffer outputBuffer;

    @Inject
    public BuffersResource(Configuration configuration, InputBuffer inputBuffer, ProcessBuffer processBuffer, OutputBuffer outputBuffer) {
        this.configuration = configuration;
        this.inputBuffer = inputBuffer;
        this.processBuffer = processBuffer;
        this.outputBuffer = outputBuffer;
    }

    @GET
    @Timed
    @ApiOperation(value="Get current utilization of buffers and caches of this node.")
    @RequiresPermissions(value={"buffers:read"})
    public BuffersUtilizationSummary utilization() {
        int ringSize = this.configuration.getRingSize();
        long inputSize = this.processBuffer.getUsage();
        long inputUtil = inputSize / (long)ringSize * 100L;
        long outputSize = this.outputBuffer.getUsage();
        long outputUtil = outputSize / (long)ringSize * 100L;
        return BuffersUtilizationSummary.create(RingSummary.create(SingleRingUtilization.create(inputSize, inputUtil), SingleRingUtilization.create(outputSize, outputUtil)));
    }

    @GET
    @Timed
    @Path(value="/classes")
    @ApiOperation(value="Get classnames of current buffer implementations.")
    @RequiresPermissions(value={"buffers:read"})
    public BufferClasses getBufferClasses() {
        return BufferClasses.create(this.inputBuffer.getClass().getCanonicalName(), ((Object)((Object)this.processBuffer)).getClass().getCanonicalName(), ((Object)((Object)this.outputBuffer)).getClass().getCanonicalName());
    }
}

