/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.management.IndexManagementConfig;
import org.graylog2.indexer.rotation.strategies.RotationStrategyConfig;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.indexer.rotation.RotationStrategy;
import org.graylog2.rest.models.system.deflector.responses.DeflectorSummary;
import org.graylog2.rest.models.system.responses.DeflectorConfigResponse;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.security.RestrictToMaster;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/Deflector", description="Index deflector management")
@Path(value="/system/deflector")
public class DeflectorResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(DeflectorResource.class);
    private final Deflector deflector;
    private final ActivityWriter activityWriter;
    private final Map<String, Provider<RotationStrategy>> rotationStrategies;
    private final ClusterConfigService clusterConfigService;
    private final ElasticsearchConfiguration configuration;

    @Inject
    public DeflectorResource(Deflector deflector, ActivityWriter activityWriter, Map<String, Provider<RotationStrategy>> rotationStrategies, ClusterConfigService clusterConfigService, ElasticsearchConfiguration configuration) {
        this.deflector = deflector;
        this.activityWriter = activityWriter;
        this.rotationStrategies = rotationStrategies;
        this.clusterConfigService = clusterConfigService;
        this.configuration = configuration;
    }

    @GET
    @Timed
    @ApiOperation(value="Get current deflector status")
    @RequiresPermissions(value={"deflector:read"})
    @Produces(value={"application/json"})
    public DeflectorSummary deflector() throws ClassNotFoundException {
        return DeflectorSummary.create(this.deflector.isUp(), this.deflector.getCurrentActualTargetIndex(), this.config());
    }

    @GET
    @Timed
    @ApiOperation(value="Get deflector configuration. Only available on master nodes.")
    @RequiresPermissions(value={"deflector:read"})
    @Path(value="/config")
    @Produces(value={"application/json"})
    @RestrictToMaster
    public DeflectorConfigResponse config() throws ClassNotFoundException {
        IndexManagementConfig indexManagementConfig = (IndexManagementConfig)this.clusterConfigService.get(IndexManagementConfig.class);
        if (indexManagementConfig == null) {
            throw new InternalServerErrorException("Invalid index management configuration");
        }
        Provider<RotationStrategy> provider = this.rotationStrategies.get(indexManagementConfig.rotationStrategy());
        if (provider == null) {
            throw new InternalServerErrorException("Unknown index rotation strategy: " + indexManagementConfig.rotationStrategy());
        }
        Class strategy = ((RotationStrategy)provider.get()).configurationClass();
        RotationStrategyConfig config = (RotationStrategyConfig)this.clusterConfigService.get(strategy);
        return config.toDeflectorConfigResponse(this.configuration.getMaxNumberOfIndices());
    }

    @POST
    @Timed
    @ApiOperation(value="Cycle deflector to new/next index")
    @RequiresPermissions(value={"deflector:cycle"})
    @Path(value="/cycle")
    @RestrictToMaster
    public void cycle() {
        String msg = "Cycling deflector. Reason: REST request.";
        LOG.info("Cycling deflector. Reason: REST request.");
        this.activityWriter.write(new Activity("Cycling deflector. Reason: REST request.", DeflectorResource.class));
        this.deflector.cycle();
    }
}

