/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.collector;

import com.codahale.metrics.annotation.Timed;
import com.github.joschi.jadconfig.util.Duration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.primitives.Ints;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.collectors.Collector;
import org.graylog2.collectors.CollectorService;
import org.graylog2.collectors.Collectors;
import org.graylog2.rest.models.collector.requests.CollectorRegistrationRequest;
import org.graylog2.rest.models.collector.responses.CollectorList;
import org.graylog2.rest.models.collector.responses.CollectorSummary;
import org.graylog2.shared.rest.resources.RestResource;
import org.hibernate.validator.constraints.NotEmpty;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@Api(value="System/Collectors", description="Management of Graylog Collectors.")
@Path(value="/system/collectors")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CollectorResource
extends RestResource {
    private final CollectorService collectorService;
    private final LostCollectorFunction lostCollectorFunction;

    @Inject
    public CollectorResource(CollectorService collectorService, @Named(value="collector_inactive_threshold") Duration inactiveThreshold) {
        this.collectorService = collectorService;
        this.lostCollectorFunction = new LostCollectorFunction(inactiveThreshold.toSeconds());
    }

    @GET
    @Timed
    @ApiOperation(value="Lists all existing collector registrations")
    @RequiresAuthentication
    @RequiresPermissions(value={"collectors:read"})
    public CollectorList list() {
        List<Collector> collectors = this.collectorService.all();
        List<CollectorSummary> collectorSummaries = Collectors.toSummaryList(collectors, this.lostCollectorFunction);
        return CollectorList.create(collectorSummaries);
    }

    @GET
    @Timed
    @Path(value="/{collectorId}")
    @ApiOperation(value="Returns at most one collector summary for the specified collector id")
    @ApiResponses(value={@ApiResponse(code=404, message="No collector with the specified id exists")})
    @RequiresAuthentication
    @RequiresPermissions(value={"collectors:read"})
    public CollectorSummary get(@ApiParam(name="collectorId", required=true) @PathParam(value="collectorId") @NotEmpty String collectorId) {
        Collector collector = this.collectorService.findById(collectorId);
        if (collector != null) {
            return collector.toSummary(this.lostCollectorFunction);
        }
        throw new NotFoundException("Collector <" + collectorId + "> not found!");
    }

    @PUT
    @Timed
    @Path(value="/{collectorId}")
    @ApiOperation(value="Create/update an collector registration", notes="This is a stateless method which upserts a collector registration")
    @ApiResponses(value={@ApiResponse(code=400, message="The supplied request is not valid.")})
    public Response register(@ApiParam(name="collectorId", value="The collector id this collector is registering as.", required=true) @PathParam(value="collectorId") @NotEmpty String collectorId, @ApiParam(name="JSON body", required=true) @Valid @NotNull CollectorRegistrationRequest request, @HeaderParam(value="X-Graylog-Collector-Version") @NotEmpty String collectorVersion) {
        Collector collector = this.collectorService.fromRequest(collectorId, request, collectorVersion);
        this.collectorService.save(collector);
        return Response.accepted().build();
    }

    @VisibleForTesting
    protected static class LostCollectorFunction
    implements Function<Collector, Boolean> {
        private final long timeOutInSeconds;

        @Inject
        public LostCollectorFunction(long timeOutInSeconds) {
            this.timeOutInSeconds = timeOutInSeconds;
        }

        public Boolean apply(Collector collector) {
            DateTime threshold = DateTime.now().minusSeconds(Ints.saturatedCast((long)this.timeOutInSeconds));
            return collector.getLastSeen().isAfter((ReadableInstant)threshold);
        }
    }
}

