/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.tools;

import com.codahale.metrics.annotation.Timed;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.rest.models.tools.requests.RegexTestRequest;
import org.graylog2.rest.models.tools.responses.RegexTesterResponse;
import org.graylog2.shared.rest.resources.RestResource;
import org.hibernate.validator.constraints.NotEmpty;

@RequiresAuthentication
@Path(value="/tools/regex_tester")
public class RegexTesterResource
extends RestResource {
    @GET
    @Timed
    @Produces(value={"application/json"})
    public RegexTesterResponse regexTester(@QueryParam(value="regex") @NotEmpty String regex, @QueryParam(value="string") @NotNull String string) {
        return this.doTestRegex(string, regex);
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public RegexTesterResponse testRegex(@Valid @NotNull RegexTestRequest regexTestRequest) {
        return this.doTestRegex(regexTestRequest.string(), regexTestRequest.regex());
    }

    private RegexTesterResponse doTestRegex(String example, String regex) {
        Matcher matcher = Pattern.compile(regex, 32).matcher(example);
        boolean matched = matcher.find();
        RegexTesterResponse.Match match = matched && matcher.groupCount() > 0 ? RegexTesterResponse.Match.create(matcher.group(1), matcher.start(1), matcher.end(1)) : null;
        return RegexTesterResponse.create(matched, match, regex, example);
    }
}

