/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.bson.types.ObjectId;
import org.graylog2.database.CollectionName;
import org.graylog2.database.PersistedImpl;
import org.graylog2.database.validators.FilledStringValidator;
import org.graylog2.plugin.database.validators.Validator;
import org.graylog2.security.AccessToken;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CollectionName(value="access_tokens")
public class AccessTokenImpl
extends PersistedImpl
implements AccessToken {
    private static final Logger LOG = LoggerFactory.getLogger(AccessTokenImpl.class);
    public static final String USERNAME = "username";
    public static final String TOKEN = "token";
    public static final String NAME = "NAME";
    public static final String LAST_ACCESS = "last_access";

    public AccessTokenImpl(Map<String, Object> fields) {
        super(fields);
    }

    public AccessTokenImpl(ObjectId id, Map<String, Object> fields) {
        super(id, fields);
    }

    public Map<String, Validator> getValidations() {
        HashMap validations = Maps.newHashMap();
        validations.put(USERNAME, new FilledStringValidator());
        validations.put(TOKEN, new FilledStringValidator());
        validations.put(NAME, new FilledStringValidator());
        return validations;
    }

    public Map<String, Validator> getEmbeddedValidations(String key) {
        return null;
    }

    @Override
    public DateTime getLastAccess() {
        Object o = this.fields.get(LAST_ACCESS);
        return (DateTime)o;
    }

    @Override
    public String getUserName() {
        return String.valueOf(this.fields.get(USERNAME));
    }

    @Override
    public void setUserName(String userName) {
        this.fields.put(USERNAME, userName);
    }

    @Override
    public String getToken() {
        return String.valueOf(this.fields.get(TOKEN));
    }

    @Override
    public void setToken(String token) {
        this.fields.put(TOKEN, token);
    }

    @Override
    public String getName() {
        return String.valueOf(this.fields.get(NAME));
    }

    @Override
    public void setName(String name) {
        this.fields.put(NAME, name);
    }
}

