/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.buffers.processors;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.lmax.disruptor.WorkHandler;
import java.util.Collection;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.buffers.MessageEvent;
import org.graylog2.shared.buffers.processors.DecodingProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProcessBufferProcessor
implements WorkHandler<MessageEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessBufferProcessor.class);
    private final Meter incomingMessages;
    private final Timer processTime;
    private final Meter outgoingMessages;
    protected final MetricRegistry metricRegistry;
    private DecodingProcessor decodingProcessor;

    public ProcessBufferProcessor(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        this.incomingMessages = metricRegistry.meter(MetricRegistry.name(ProcessBufferProcessor.class, (String[])new String[]{"incomingMessages"}));
        this.outgoingMessages = metricRegistry.meter(MetricRegistry.name(ProcessBufferProcessor.class, (String[])new String[]{"outgoingMessages"}));
        this.processTime = metricRegistry.timer(MetricRegistry.name(ProcessBufferProcessor.class, (String[])new String[]{"processTime"}));
    }

    public void onEvent(MessageEvent event) throws Exception {
        this.decodingProcessor.onEvent(event, 0L, false);
        if (event.isSingleMessage()) {
            this.dispatchMessage(event.getMessage());
        } else {
            Collection messageList = event.getMessages();
            if (messageList == null) {
                return;
            }
            for (Message message : messageList) {
                this.dispatchMessage(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchMessage(Message msg) {
        this.incomingMessages.mark();
        LOG.debug("Starting to process message <{}>.", (Object)msg.getId());
        try (Timer.Context ignored = this.processTime.time();){
            LOG.debug("Finished processing message <{}>. Writing to output buffer.", (Object)msg.getId());
            this.handleMessage(msg);
        }
        catch (Exception e) {
            LOG.warn("Unable to process message <{}>: {}", (Object)msg.getId(), (Object)e);
        }
        finally {
            this.outgoingMessages.mark();
        }
    }

    protected abstract void handleMessage(Message var1);

    public void setDecodingProcessor(DecodingProcessor decodingProcessor) {
        this.decodingProcessor = decodingProcessor;
    }
}

