/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.initializers;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Path;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.ext.ExceptionMapper;
import org.glassfish.jersey.server.model.Resource;
import org.graylog2.plugin.BaseConfiguration;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.initializers.AbstractJerseyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RestApiService
extends AbstractJerseyService {
    private static final Logger LOG = LoggerFactory.getLogger(RestApiService.class);
    public static final String PLUGIN_PREFIX = "/plugins";
    private final BaseConfiguration configuration;
    private final Map<String, Set<PluginRestResource>> pluginRestResources;
    private final String[] restControllerPackages;

    @Inject
    private RestApiService(BaseConfiguration configuration, MetricRegistry metricRegistry, Set<Class<? extends DynamicFeature>> dynamicFeatures, Set<Class<? extends ContainerResponseFilter>> containerResponseFilters, Set<Class<? extends ExceptionMapper>> exceptionMappers, @Named(value="additionalJerseyComponents") Set<Class> additionalComponents, Map<String, Set<PluginRestResource>> pluginRestResources, @Named(value="RestControllerPackages") String[] restControllerPackages, ObjectMapper objectMapper) {
        super(dynamicFeatures, containerResponseFilters, exceptionMappers, additionalComponents, objectMapper, metricRegistry);
        this.configuration = configuration;
        this.pluginRestResources = pluginRestResources;
        this.restControllerPackages = restControllerPackages;
    }

    protected void startUp() throws Exception {
        this.httpServer = this.setUp("rest", this.configuration.getRestListenUri(), this.configuration.isRestEnableTls(), this.configuration.getRestTlsCertFile(), this.configuration.getRestTlsKeyFile(), this.configuration.getRestTlsKeyPassword(), this.configuration.getRestThreadPoolSize(), this.configuration.getRestMaxInitialLineLength(), this.configuration.getRestMaxHeaderSize(), this.configuration.isRestEnableGzip(), this.configuration.isRestEnableCors(), this.prefixPluginResources(PLUGIN_PREFIX, this.pluginRestResources), this.restControllerPackages);
        this.httpServer.start();
        LOG.info("Started REST API at <{}>", (Object)this.configuration.getRestListenUri());
    }

    private Set<Resource> prefixPluginResources(String pluginPrefix, Map<String, Set<PluginRestResource>> pluginResourceMap) {
        HashSet<Resource> result = new HashSet<Resource>();
        for (Map.Entry<String, Set<PluginRestResource>> entry : pluginResourceMap.entrySet()) {
            for (PluginRestResource pluginRestResource : entry.getValue()) {
                String path;
                StringBuilder resourcePath = new StringBuilder(pluginPrefix).append("/").append(entry.getKey());
                Path pathAnnotation = Resource.getPath(pluginRestResource.getClass());
                String string = path = pathAnnotation.value() == null ? "" : pathAnnotation.value();
                if (!path.startsWith("/")) {
                    resourcePath.append("/");
                }
                Resource.Builder resourceBuilder = Resource.builder(pluginRestResource.getClass()).path(resourcePath.append(path).toString());
                Resource resource = resourceBuilder.build();
                result.add(resource);
            }
        }
        return result;
    }

    protected void shutDown() throws Exception {
        if (this.httpServer != null && this.httpServer.isStarted()) {
            LOG.info("Shutting down REST API at <{}>", (Object)this.configuration.getRestListenUri());
            this.httpServer.shutdownNow();
        }
    }
}

