/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources.documentation;

import com.codahale.metrics.annotation.Timed;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.graylog2.plugin.BaseConfiguration;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.documentation.generator.Generator;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="Documentation", description="Documentation of this API in JSON format.")
@Path(value="/api-docs")
public class DocumentationResource
extends RestResource {
    private BaseConfiguration configuration;
    private final Set<String> restControllerPackages = new HashSet<String>();
    private final Map<Class<?>, String> pluginRestControllerMapping = new HashMap();

    @Inject
    public DocumentationResource(BaseConfiguration configuration, @Named(value="RestControllerPackages") String[] restControllerPackages, Map<String, Set<PluginRestResource>> pluginRestResources) {
        this.configuration = configuration;
        this.restControllerPackages.addAll(Arrays.asList(restControllerPackages));
        for (Map.Entry<String, Set<PluginRestResource>> entry : pluginRestResources.entrySet()) {
            String pluginPackage = entry.getKey();
            this.restControllerPackages.add(pluginPackage);
            for (PluginRestResource pluginRestResource : entry.getValue()) {
                this.pluginRestControllerMapping.put(pluginRestResource.getClass(), pluginPackage);
            }
        }
    }

    @GET
    @Timed
    @ApiOperation(value="Get API documentation")
    @Produces(value={"application/json"})
    public Response overview() {
        return this.buildSuccessfulCORSResponse(new Generator(this.restControllerPackages, this.pluginRestControllerMapping, "/plugins", this.objectMapper).generateOverview());
    }

    @GET
    @Timed
    @ApiOperation(value="Get detailed API documentation of a single resource")
    @Produces(value={"application/json"})
    @Path(value="/{route: .+}")
    public Response route(@ApiParam(name="route", value="Route to fetch. For example /system", required=true) @PathParam(value="route") String route) {
        return this.buildSuccessfulCORSResponse(new Generator(this.restControllerPackages, this.pluginRestControllerMapping, "/plugins", this.objectMapper).generateForRoute(route, this.configuration.getRestTransportUri().toString()));
    }

    private Response buildSuccessfulCORSResponse(Map<String, Object> result) {
        return Response.ok(result).header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"GET").header("Access-Control-Allow-Headers", (Object)"Content-Type, api_key, Authorization").build();
    }
}

