/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;
import org.graylog2.shared.security.AccessTokenAuthToken;
import org.graylog2.shared.security.SessionIdToken;
import org.graylog2.shared.security.ShiroSecurityContext;

@Priority(value=1000)
public class ShiroSecurityContextFilter
implements ContainerRequestFilter {
    private final DefaultSecurityManager securityManager;

    @Inject
    public ShiroSecurityContextFilter(DefaultSecurityManager securityManager) {
        this.securityManager = Objects.requireNonNull(securityManager);
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        SecurityContext securityContext;
        boolean secure = requestContext.getSecurityContext().isSecure();
        MultivaluedMap headers = requestContext.getHeaders();
        String host = (String)headers.getFirst((Object)"Host");
        String authHeader = (String)headers.getFirst((Object)"Authorization");
        if (authHeader != null && authHeader.startsWith("Basic")) {
            String base64UserPass = authHeader.substring(authHeader.indexOf(32) + 1);
            String userPass = this.decodeBase64(base64UserPass);
            String[] split = userPass.split(":");
            if (split.length != 2) {
                throw new BadRequestException("Invalid credentials in Authorization header");
            }
            securityContext = this.createSecurityContext(split[0], split[1], secure, "BASIC", host, (MultivaluedMap<String, String>)headers);
        } else {
            securityContext = this.createSecurityContext(null, null, secure, null, host, (MultivaluedMap<String, String>)headers);
        }
        requestContext.setSecurityContext(securityContext);
    }

    private String decodeBase64(String s) {
        try {
            return new String(Base64.getDecoder().decode(s), StandardCharsets.US_ASCII);
        }
        catch (IllegalArgumentException e) {
            return "";
        }
    }

    private SecurityContext createSecurityContext(String userName, String credential, boolean isSecure, String authcScheme, String host, MultivaluedMap<String, String> headers) {
        Object authToken = "session".equalsIgnoreCase(credential) ? new SessionIdToken(userName, host) : ("token".equalsIgnoreCase(credential) ? new AccessTokenAuthToken(userName, host) : new UsernamePasswordToken(userName, credential, host));
        Subject subject = new Subject.Builder((SecurityManager)this.securityManager).host(host).sessionCreationEnabled(false).buildSubject();
        return new ShiroSecurityContext(subject, (AuthenticationToken)authToken, isSecure, authcScheme, headers);
    }
}

