/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.streams;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;
import org.graylog2.database.CollectionName;
import org.graylog2.database.PersistedImpl;
import org.graylog2.database.validators.DateValidator;
import org.graylog2.database.validators.FilledStringValidator;
import org.graylog2.database.validators.MapValidator;
import org.graylog2.database.validators.OptionalStringValidator;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.validators.Validator;
import org.graylog2.plugin.streams.Output;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.plugin.streams.StreamRule;
import org.joda.time.DateTime;

@CollectionName(value="streams")
public class StreamImpl
extends PersistedImpl
implements Stream {
    public static final String FIELD_TITLE = "title";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_RULES = "rules";
    public static final String FIELD_OUTPUTS = "outputs";
    public static final String FIELD_CONTENT_PACK = "content_pack";
    public static final String FIELD_ALERT_RECEIVERS = "alert_receivers";
    public static final String FIELD_DISABLED = "disabled";
    public static final String FIELD_CREATED_AT = "created_at";
    public static final String FIELD_CREATOR_USER_ID = "creator_user_id";
    public static final String FIELD_MATCHING_TYPE = "matching_type";
    public static final String EMBEDDED_ALERT_CONDITIONS = "alert_conditions";
    private final List<StreamRule> streamRules;
    private final Set<Output> outputs;

    public StreamImpl(Map<String, Object> fields) {
        super(fields);
        this.streamRules = null;
        this.outputs = null;
    }

    protected StreamImpl(ObjectId id, Map<String, Object> fields) {
        super(id, fields);
        this.streamRules = null;
        this.outputs = null;
    }

    public StreamImpl(ObjectId id, Map<String, Object> fields, List<StreamRule> streamRules, Set<Output> outputs) {
        super(id, fields);
        this.streamRules = streamRules;
        this.outputs = outputs;
    }

    @Override
    public String toString() {
        return this.id.toString() + ": \"" + this.getTitle() + "\"";
    }

    public List<StreamRule> getStreamRules() {
        return this.streamRules;
    }

    public Set<Output> getOutputs() {
        return this.outputs;
    }

    public String getTitle() {
        return (String)this.fields.get(FIELD_TITLE);
    }

    public String getDescription() {
        return (String)this.fields.get(FIELD_DESCRIPTION);
    }

    public void setTitle(String title) {
        this.fields.put(FIELD_TITLE, title);
    }

    public void setDescription(String description) {
        this.fields.put(FIELD_DESCRIPTION, description);
    }

    public Boolean getDisabled() {
        return (Boolean)this.fields.get(FIELD_DISABLED);
    }

    public void setDisabled(Boolean disabled) {
        this.fields.put(FIELD_DISABLED, disabled);
    }

    public String getContentPack() {
        return (String)this.fields.get(FIELD_CONTENT_PACK);
    }

    public void setContentPack(String contentPack) {
        this.fields.put(FIELD_CONTENT_PACK, contentPack);
    }

    public Boolean isPaused() {
        Boolean disabled = this.getDisabled();
        return disabled != null && disabled != false;
    }

    public Map<String, Object> asMap(List<StreamRule> streamRules) {
        Map<String, Object> result = this.asMap();
        ArrayList streamRulesMap = Lists.newArrayList();
        for (StreamRule streamRule : streamRules) {
            streamRulesMap.add(streamRule.asMap());
        }
        result.put(FIELD_RULES, streamRulesMap);
        return result;
    }

    @Override
    @JsonValue
    public Map<String, Object> asMap() {
        HashMap result = Maps.newHashMap((Map)this.fields);
        result.remove("_id");
        result.put("id", ((ObjectId)this.fields.get("_id")).toHexString());
        result.remove(FIELD_CREATED_AT);
        result.put(FIELD_CREATED_AT, Tools.getISO8601String((DateTime)((DateTime)this.fields.get(FIELD_CREATED_AT))));
        result.put(FIELD_RULES, this.streamRules);
        result.put(FIELD_OUTPUTS, this.outputs);
        result.put(FIELD_MATCHING_TYPE, this.getMatchingType());
        return result;
    }

    public Map<String, Validator> getValidations() {
        return ImmutableMap.builder().put((Object)FIELD_TITLE, (Object)new FilledStringValidator()).put((Object)FIELD_CREATOR_USER_ID, (Object)new FilledStringValidator()).put((Object)FIELD_CREATED_AT, (Object)new DateValidator()).put((Object)FIELD_CONTENT_PACK, (Object)new OptionalStringValidator()).build();
    }

    public Map<String, Validator> getEmbeddedValidations(String key) {
        if (key.equals(EMBEDDED_ALERT_CONDITIONS)) {
            return ImmutableMap.of((Object)"id", (Object)new FilledStringValidator(), (Object)"parameters", (Object)new MapValidator());
        }
        return Collections.emptyMap();
    }

    public Map<String, List<String>> getAlertReceivers() {
        if (!this.fields.containsKey(FIELD_ALERT_RECEIVERS)) {
            return Collections.emptyMap();
        }
        return (Map)this.fields.get(FIELD_ALERT_RECEIVERS);
    }

    public Stream.MatchingType getMatchingType() {
        String matchingTypeString = (String)this.fields.get(FIELD_MATCHING_TYPE);
        if (matchingTypeString == null) {
            return Stream.MatchingType.AND;
        }
        return Stream.MatchingType.valueOf((String)matchingTypeString);
    }

    public void setMatchingType(Stream.MatchingType matchingType) {
        Preconditions.checkNotNull((Object)matchingType);
        this.fields.put(FIELD_MATCHING_TYPE, matchingType.toString());
    }
}

