/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.web;

import com.floreysoft.jmte.Engine;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.web.PluginAssets;

@Singleton
public class IndexHtmlGenerator {
    private static final String title = "Graylog Web Interface";
    private final Engine engine = new Engine();
    private final String content;

    @Inject
    public IndexHtmlGenerator(final PluginAssets pluginAssets) throws IOException {
        URL templateUrl = this.getClass().getResource("/web-interface/index.html.template");
        String template = Resources.toString((URL)templateUrl, (Charset)StandardCharsets.UTF_8);
        HashMap<String, Object> model = new HashMap<String, Object>(){
            {
                this.put("title", IndexHtmlGenerator.title);
                this.put("cssFiles", pluginAssets.cssFiles());
                this.put("jsFiles", pluginAssets.jsFiles());
            }
        };
        this.content = this.engine.transform(template, (Map)model);
    }

    public String get() {
        return this.content;
    }
}

