/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.web.resources;

import com.floreysoft.jmte.Engine;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.graylog2.Configuration;

@Path(value="/config.js")
public class AppConfigResource {
    private static final Engine engine = new Engine();
    private final String content;

    @Inject
    public AppConfigResource(final Configuration configuration) {
        String template;
        URL templateUrl = this.getClass().getResource("/web-interface/config.js.template");
        try {
            template = Resources.toString((URL)templateUrl, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read AppConfig template while generating web interface configuration: ", e);
        }
        HashMap<String, Object> model = new HashMap<String, Object>(){
            {
                this.put("rootTimeZone", configuration.getRootTimeZone());
                this.put("serverUri", configuration.getRestTransportUri());
                this.put("appPathPrefix", "");
            }
        };
        this.content = engine.transform(template, (Map)model);
    }

    @GET
    @Produces(value={"application/octet-stream"})
    public String get() {
        return this.content;
    }
}

