/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.web.resources;

import com.google.common.base.MoreObjects;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.graylog2.plugin.Plugin;

@Path(value="/plugin/{plugin}/{filename}")
public class PluginAssetsResource {
    private final Set<Plugin> plugins;

    @Inject
    public PluginAssetsResource(Set<Plugin> plugins) {
        this.plugins = plugins;
    }

    @GET
    public Response get(@PathParam(value="plugin") String pluginName, @PathParam(value="filename") String filename) {
        Optional<Plugin> plugin = this.getPluginForName(pluginName);
        if (!plugin.isPresent()) {
            throw new NotFoundException();
        }
        InputStream stream = this.getStreamForPluginFile(plugin.get(), filename);
        if (stream == null) {
            throw new NotFoundException();
        }
        String contentType = (String)MoreObjects.firstNonNull((Object)URLConnection.guessContentTypeFromName(filename), (Object)"application/octet-stream");
        return Response.ok((Object)stream).header("Content-Type", (Object)contentType).build();
    }

    private InputStream getStreamForPluginFile(Plugin plugin, String filename) {
        return plugin.metadata().getClass().getResourceAsStream("/" + filename);
    }

    private Optional<Plugin> getPluginForName(String pluginName) {
        return this.plugins.stream().filter(plugin -> plugin.metadata().getUniqueId().equals(pluginName)).findFirst();
    }
}

