webpackJsonp([29],{51:function(module,exports,__webpack_require__){eval("/// <reference path=\"../../../declarations/bluebird/bluebird.d.ts\" />\n'use strict';\n\nvar moment = __webpack_require__(21);\nvar jsRoutes = __webpack_require__(9);\nvar fetch = __webpack_require__(6)['default'];\nvar UserNotification = __webpack_require__(5);\nvar URLUtils = __webpack_require__(7);\nvar MessageFieldsFilter = __webpack_require__(101);\nvar MessagesStore = {\n    loadMessage: function loadMessage(index, messageId) {\n        var url = jsRoutes.controllers.MessagesController.single(index.trim(), messageId.trim()).url;\n        var promise = fetch('GET', URLUtils.qualifyUrl(url)).then(function (response) {\n            var message = response.message;\n            var fields = message.fields;\n            var filteredFields = MessageFieldsFilter.filterFields(fields);\n            var newMessage = {\n                id: message.id,\n                timestamp: moment(message.timestamp).unix(),\n                filtered_fields: filteredFields,\n                formatted_fields: filteredFields,\n                fields: fields,\n                index: response.index,\n                source_node_id: fields.gl2_source_node,\n                source_input_id: fields.gl2_source_input,\n                stream_ids: message.streams\n            };\n            return newMessage;\n        })['catch'](function (errorThrown) {\n            UserNotification.error(\"Loading message information failed with status: \" + errorThrown, \"Could not load message information\");\n        });\n        return promise;\n    },\n    fieldTerms: function fieldTerms(index, string) {\n        var url = jsRoutes.controllers.MessagesController.analyze(index, string).url;\n        var promise = fetch('GET', URLUtils.qualifyUrl(url)).then(function (response) {\n            return response.tokens;\n        })['catch'](function (error) {\n            UserNotification.error(\"Loading field terms failed with status: \" + error, \"Could not load field terms.\");\n        });\n        return promise;\n    }\n};\nmodule.exports = MessagesStore;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/stores/messages/MessagesStore.ts\n ** module id = 51\n ** module chunks = 4 10 11 13 20 29\n **/\n//# sourceURL=webpack:///./src/stores/messages/MessagesStore.ts?")},78:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nObject.defineProperty(exports, '__esModule', {\n  value: true\n});\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _reactBootstrap = __webpack_require__(2);\n\nvar _immutable = __webpack_require__(10);\n\nvar _immutable2 = _interopRequireDefault(_immutable);\n\nvar _reactRouterBootstrap = __webpack_require__(17);\n\nvar _storesStreamsStreamsStore = __webpack_require__(31);\n\nvar _storesStreamsStreamsStore2 = _interopRequireDefault(_storesStreamsStreamsStore);\n\nvar _componentsStreamsStreamLink = __webpack_require__(100);\n\nvar _componentsStreamsStreamLink2 = _interopRequireDefault(_componentsStreamsStreamLink);\n\nvar _componentsSearchMessageFields = __webpack_require__(88);\n\nvar _componentsSearchMessageFields2 = _interopRequireDefault(_componentsSearchMessageFields);\n\nvar _componentsCommon = __webpack_require__(4);\n\nvar _routingJsRoutes = __webpack_require__(9);\n\nvar _routingJsRoutes2 = _interopRequireDefault(_routingJsRoutes);\n\nvar _routingRoutes = __webpack_require__(11);\n\nvar _routingRoutes2 = _interopRequireDefault(_routingRoutes);\n\nvar MessageDetail = _react2['default'].createClass({\n  displayName: 'MessageDetail',\n\n  propTypes: {\n    allStreams: _react.PropTypes.object,\n    allStreamsLoaded: _react.PropTypes.bool,\n    disableTestAgainstStream: _react.PropTypes.bool,\n    expandAllRenderAsync: _react.PropTypes.bool,\n    showTimestamp: _react.PropTypes.bool,\n    disableFieldActions: _react.PropTypes.bool,\n    possiblyHighlight: _react.PropTypes.func,\n    inputs: _react.PropTypes.object,\n    nodes: _react.PropTypes.object,\n    message: _react.PropTypes.object,\n    streams: _react.PropTypes.object,\n    customFieldActions: _react.PropTypes.node\n  },\n\n  getInitialState: function getInitialState() {\n    return {\n      allStreamsLoaded: false,\n      allStreams: _immutable2['default'].List()\n    };\n  },\n  componentDidMount: function componentDidMount() {\n    var _this = this;\n\n    if (this.props.allStreams === undefined) {\n      // our parent does not provide allStreams for the test against stream menu, we have to load it ourselves\n      // this can happen if the component is used outside the regular search result\n      // only load the streams per page\n      if (this.state.allStreamsLoaded || this.props.disableTestAgainstStream) {\n        return;\n      }\n      var promise = _storesStreamsStreamsStore2['default'].listStreams();\n      promise.done(function (streams) {\n        return _this._onStreamsLoaded(streams);\n      });\n    }\n  },\n  _onStreamsLoaded: function _onStreamsLoaded(streams) {\n    this.setState({ allStreamsLoaded: true, allStreams: _immutable2['default'].List(streams).sortBy(function (stream) {\n        return stream.title;\n      }) });\n  },\n\n  _inputName: function _inputName(inputId) {\n    var input = this.props.inputs.get(inputId);\n    return input ? _react2['default'].createElement(\n      'span',\n      { style: { wordBreak: 'break-word' } },\n      input.title\n    ) : 'deleted input';\n  },\n  _nodeName: function _nodeName(nodeId) {\n    var node = this.props.nodes.get(nodeId);\n    var nodeInformation = undefined;\n\n    if (node) {\n      var nodeURL = node.radio ? _routingJsRoutes2['default'].controllers.RadiosController.show(nodeId).url : _routingJsRoutes2['default'].controllers.NodesController.node(nodeId).url;\n      nodeInformation = _react2['default'].createElement(\n        'a',\n        { href: nodeURL },\n        _react2['default'].createElement('i', { className: 'fa fa-code-fork' }),\n        ' ',\n        _react2['default'].createElement(\n          'span',\n          { style: { wordBreak: 'break-word' } },\n          node.short_node_id\n        ),\n        ' / ',\n        _react2['default'].createElement(\n          'span',\n          {\n            style: { wordBreak: 'break-word' } },\n          node.hostname\n        )\n      );\n    } else {\n      nodeInformation = _react2['default'].createElement(\n        'span',\n        { style: { wordBreak: 'break-word' } },\n        'stopped node'\n      );\n    }\n    return nodeInformation;\n  },\n\n  _getAllStreams: function _getAllStreams() {\n    if (this.props.allStreams) {\n      return this.props.allStreams;\n    } else {\n      return this.state.allStreams;\n    }\n  },\n  render: function render() {\n    var _this2 = this;\n\n    // Short circuit when all messages are being expanded at the same time\n    if (this.props.expandAllRenderAsync) {\n      return _react2['default'].createElement(\n        _reactBootstrap.Row,\n        null,\n        _react2['default'].createElement(\n          _reactBootstrap.Col,\n          { md: 12 },\n          _react2['default'].createElement(_componentsCommon.Spinner, null)\n        )\n      );\n    }\n\n    var messageUrl = _routingJsRoutes2['default'].controllers.SearchController.showMessage(this.props.message.index, this.props.message.id).url;\n\n    var streamList = null;\n    this._getAllStreams().forEach(function (stream) {\n      if (!streamList) {\n        streamList = [];\n      }\n      streamList.push(_react2['default'].createElement(\n        _reactRouterBootstrap.LinkContainer,\n        { key: stream.id, to: _routingRoutes2['default'].stream_edit_example(stream.id, _this2.props.message.index, _this2.props.message.id) },\n        _react2['default'].createElement(\n          _reactBootstrap.MenuItem,\n          null,\n          stream.title\n        )\n      ));\n    });\n\n    var streamIds = _immutable2['default'].Set(this.props.message.stream_ids);\n    var streams = streamIds.map(function (id) {\n      var stream = _this2.props.streams.get(id);\n      if (stream !== undefined) {\n        return _react2['default'].createElement(\n          'li',\n          { key: stream.id },\n          _react2['default'].createElement(_componentsStreamsStreamLink2['default'], { stream: stream })\n        );\n      }\n    });\n\n    var viaRadio = this.props.message.source_radio_id;\n    if (viaRadio) {\n      viaRadio = _react2['default'].createElement(\n        'span',\n        null,\n        'via ',\n        _react2['default'].createElement(\n          'em',\n          null,\n          this._inputName(this.props.message.source_radio_input_id)\n        ),\n        ' on radio ',\n        this._nodeName(this.props.message.source_radio_id)\n      );\n    }\n\n    var timestamp = null;\n    if (this.props.showTimestamp) {\n      timestamp = [];\n      var rawTimestamp = this.props.message.fields.timestamp;\n\n      timestamp.push(_react2['default'].createElement(\n        'dt',\n        { key: 'dt-' + rawTimestamp },\n        'Timestamp'\n      ));\n      timestamp.push(_react2['default'].createElement(\n        'dd',\n        { key: 'dd-' + rawTimestamp },\n        _react2['default'].createElement(_componentsCommon.Timestamp, { dateTime: rawTimestamp })\n      ));\n    }\n\n    var receivedBy = undefined;\n    if (this.props.message.source_input_id && this.props.message.source_node_id && this.props.nodes) {\n      receivedBy = _react2['default'].createElement(\n        'div',\n        null,\n        _react2['default'].createElement(\n          'dt',\n          null,\n          'Received by'\n        ),\n        _react2['default'].createElement(\n          'dd',\n          null,\n          _react2['default'].createElement(\n            'em',\n            null,\n            this._inputName(this.props.message.source_input_id)\n          ),\n          ' on ',\n          this._nodeName(this.props.message.source_node_id),\n          viaRadio && _react2['default'].createElement('br', null),\n          viaRadio\n        )\n      );\n    } else {\n      receivedBy = null;\n    }\n\n    var testAgainstStream = this.props.disableTestAgainstStream ? null : _react2['default'].createElement(\n      _reactBootstrap.DropdownButton,\n      { ref: 'streamDropdown', pullRight: true, bsSize: 'small', title: 'Test against stream',\n        id: 'select-stream-dropdown' },\n      streamList,\n      !streamList && !this.props.allStreamsLoaded && _react2['default'].createElement(\n        _reactBootstrap.MenuItem,\n        { header: true },\n        _react2['default'].createElement('i', { className: 'fa fa-spin fa-spinner' }),\n        'Loading streams'\n      ),\n      !streamList && this.props.allStreamsLoaded && _react2['default'].createElement(\n        _reactBootstrap.MenuItem,\n        { header: true },\n        'No streams available'\n      )\n    );\n\n    return _react2['default'].createElement(\n      'div',\n      null,\n      _react2['default'].createElement(\n        _reactBootstrap.Row,\n        { className: 'row-sm' },\n        _react2['default'].createElement(\n          _reactBootstrap.Col,\n          { md: 12 },\n          _react2['default'].createElement(\n            _reactBootstrap.ButtonGroup,\n            { className: 'pull-right', bsSize: 'small' },\n            _react2['default'].createElement(\n              _reactBootstrap.Button,\n              { href: messageUrl },\n              'Permalink'\n            ),\n            _react2['default'].createElement(_componentsCommon.ClipboardButton, { title: 'Copy ID', text: this.props.message.id }),\n            testAgainstStream\n          ),\n          _react2['default'].createElement(\n            'h3',\n            null,\n            _react2['default'].createElement('i', { className: 'fa fa-envelope' }),\n            ' ',\n            _react2['default'].createElement(\n              _reactRouterBootstrap.LinkContainer,\n              { to: _routingRoutes2['default'].message_show(this.props.message.index, this.props.message.id) },\n              _react2['default'].createElement(\n                'a',\n                { href: '#', style: { color: '#000' } },\n                this.props.message.id\n              )\n            )\n          )\n        )\n      ),\n      _react2['default'].createElement(\n        _reactBootstrap.Row,\n        null,\n        _react2['default'].createElement(\n          _reactBootstrap.Col,\n          { md: 3 },\n          _react2['default'].createElement(\n            'dl',\n            { className: 'message-details' },\n            timestamp,\n            receivedBy,\n            _react2['default'].createElement(\n              'dt',\n              null,\n              'Stored in index'\n            ),\n            _react2['default'].createElement(\n              'dd',\n              null,\n              this.props.message.index\n            ),\n            streamIds.size > 0 && _react2['default'].createElement(\n              'dt',\n              null,\n              'Routed into streams'\n            ),\n            streamIds.size > 0 && _react2['default'].createElement(\n              'dd',\n              { className: 'stream-list' },\n              _react2['default'].createElement(\n                'ul',\n                null,\n                streams\n              )\n            )\n          )\n        ),\n        _react2['default'].createElement(\n          _reactBootstrap.Col,\n          { md: 9 },\n          _react2['default'].createElement(\n            'div',\n            { ref: 'messageList' },\n            _react2['default'].createElement(_componentsSearchMessageFields2['default'], { message: this.props.message, possiblyHighlight: this.props.possiblyHighlight,\n              disableFieldActions: this.props.disableFieldActions,\n              customFieldActions: this.props.customFieldActions })\n          )\n        )\n      )\n    );\n  }\n});\n\nexports['default'] = MessageDetail;\nmodule.exports = exports['default'];\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"MessageDetail.jsx\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/components/search/MessageDetail.jsx\n ** module id = 78\n ** module chunks = 4 13 20 29\n **/\n//# sourceURL=webpack:///./src/components/search/MessageDetail.jsx?")},86:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nObject.defineProperty(exports, '__esModule', {\n  value: true\n});\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }\n\nvar _jquery = __webpack_require__(8);\n\nvar _jquery2 = _interopRequireDefault(_jquery);\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _reactBootstrap = __webpack_require__(2);\n\nvar _immutable = __webpack_require__(10);\n\nvar _immutable2 = _interopRequireDefault(_immutable);\n\nvar _storesMessagesMessagesStore = __webpack_require__(51);\n\nvar _storesMessagesMessagesStore2 = _interopRequireDefault(_storesMessagesMessagesStore);\n\nvar _MessageFieldSearchActions = __webpack_require__(87);\n\nvar _MessageFieldSearchActions2 = _interopRequireDefault(_MessageFieldSearchActions);\n\nvar MessageFieldDescription = _react2['default'].createClass({\n  displayName: 'MessageFieldDescription',\n\n  propTypes: {\n    message: _react.PropTypes.object.isRequired,\n    fieldName: _react.PropTypes.string.isRequired,\n    fieldValue: _react.PropTypes.any.isRequired,\n    possiblyHighlight: _react.PropTypes.func.isRequired,\n    disableFieldActions: _react.PropTypes.bool,\n    customFieldActions: _react.PropTypes.node\n  },\n  getInitialState: function getInitialState() {\n    return {\n      messageTerms: _immutable2['default'].List()\n    };\n  },\n  loadTerms: function loadTerms(field) {\n    var _this = this;\n\n    return function () {\n      var promise = _storesMessagesMessagesStore2['default'].fieldTerms(_this.props.message.index, _this.props.message.fields[field]);\n      promise.then(function (terms) {\n        return _this._onTermsLoaded(terms);\n      });\n    };\n  },\n  _onTermsLoaded: function _onTermsLoaded(terms) {\n    this.setState({ messageTerms: _immutable2['default'].fromJS(terms) });\n  },\n  _shouldShowTerms: function _shouldShowTerms() {\n    return this.state.messageTerms.size !== 0;\n  },\n  addFieldToSearchBar: function addFieldToSearchBar(event) {\n    event.preventDefault();\n    (0, _jquery2['default'])(document).trigger('add-search-term.graylog.search', { field: this.props.fieldName, value: this.props.fieldValue });\n  },\n  _getFormattedTerms: function _getFormattedTerms() {\n    var termsMarkup = [];\n    this.state.messageTerms.forEach(function (term, idx) {\n      termsMarkup.push(_react2['default'].createElement(\n        'span',\n        { key: idx, className: 'message-terms' },\n        term\n      ));\n    });\n\n    return termsMarkup;\n  },\n  render: function render() {\n    var _this2 = this;\n\n    var className = this.props.fieldName === 'message' || this.props.fieldName === 'full_message' ? 'message-field' : '';\n    var fieldActions = undefined;\n    if (!this.props.disableFieldActions) {\n      if (this.props.customFieldActions) {\n        fieldActions = _react2['default'].cloneElement(this.props.customFieldActions, { fieldName: this.props.fieldName, message: this.props.message });\n      } else {\n        fieldActions = _react2['default'].createElement(_MessageFieldSearchActions2['default'], { fieldName: this.props.fieldName,\n          message: this.props.message,\n          onAddFieldToSearchBar: this.addFieldToSearchBar,\n          onLoadTerms: this.loadTerms });\n      }\n    }\n\n    return _react2['default'].createElement(\n      'dd',\n      { className: className, key: this.props.fieldName + 'dd' },\n      fieldActions,\n      _react2['default'].createElement(\n        'div',\n        { className: 'field-value' },\n        this.props.possiblyHighlight(this.props.fieldName)\n      ),\n      this._shouldShowTerms() && _react2['default'].createElement(\n        _reactBootstrap.Alert,\n        { bsStyle: 'info', onDismiss: function () {\n            return _this2.setState({ messageTerms: _immutable2['default'].Map() });\n          } },\n        'Field terms:  ',\n        this._getFormattedTerms()\n      )\n    );\n  }\n});\n\nexports['default'] = MessageFieldDescription;\nmodule.exports = exports['default'];\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"MessageFieldDescription.jsx\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/components/search/MessageFieldDescription.jsx\n ** module id = 86\n ** module chunks = 4 13 20 29\n **/\n//# sourceURL=webpack:///./src/components/search/MessageFieldDescription.jsx?")},87:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nObject.defineProperty(exports, '__esModule', {\n  value: true\n});\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _reactBootstrap = __webpack_require__(2);\n\nvar _utilExtractorUtils = __webpack_require__(39);\n\nvar _utilExtractorUtils2 = _interopRequireDefault(_utilExtractorUtils);\n\nvar MessageFieldSearchActions = _react2['default'].createClass({\n  displayName: 'MessageFieldSearchActions',\n\n  propTypes: {\n    fieldName: _react.PropTypes.string.isRequired,\n    message: _react.PropTypes.object.isRequired,\n    onLoadTerms: _react.PropTypes.func.isRequired,\n    onAddFieldToSearchBar: _react.PropTypes.func.isRequired\n  },\n  getInitialState: function getInitialState() {\n    this.newExtractorRoutes = _utilExtractorUtils2['default'].getNewExtractorRoutes(this.props.message.source_node_id, this.props.message.source_input_id, this.props.fieldName, this.props.message.index, this.props.message.id);\n\n    return null;\n  },\n  _formatExtractorMenuItem: function _formatExtractorMenuItem(extractorType) {\n    return _react2['default'].createElement(\n      _reactBootstrap.MenuItem,\n      { key: 'menu-item-' + extractorType, href: this.newExtractorRoutes[extractorType] },\n      _utilExtractorUtils2['default'].getReadableExtractorTypeName(extractorType)\n    );\n  },\n  render: function render() {\n    var _this = this;\n\n    return _react2['default'].createElement(\n      'div',\n      { className: 'message-field-actions pull-right' },\n      _react2['default'].createElement(\n        _reactBootstrap.SplitButton,\n        { pullRight: true,\n          bsSize: 'xsmall',\n          title: _react2['default'].createElement('i', { className: 'fa fa-search-plus' }),\n          key: 1,\n          onClick: this.props.onAddFieldToSearchBar,\n          id: 'more-actions-dropdown-field-' + this.props.fieldName },\n        _react2['default'].createElement(\n          'li',\n          { className: 'dropdown-submenu left-submenu' },\n          _react2['default'].createElement(\n            'a',\n            { href: '#' },\n            'Create extractor for field ',\n            this.props.fieldName\n          ),\n          _react2['default'].createElement(\n            'ul',\n            { className: 'dropdown-menu' },\n            _utilExtractorUtils2['default'].EXTRACTOR_TYPES.map(function (extractorType) {\n              return _this._formatExtractorMenuItem(extractorType);\n            })\n          )\n        ),\n        _react2['default'].createElement(\n          _reactBootstrap.MenuItem,\n          { onSelect: this.props.onLoadTerms(this.props.fieldName) },\n          'Show terms of ',\n          this.props.fieldName\n        )\n      )\n    );\n  }\n});\n\nexports['default'] = MessageFieldSearchActions;\nmodule.exports = exports['default'];\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"MessageFieldSearchActions.jsx\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/components/search/MessageFieldSearchActions.jsx\n ** module id = 87\n ** module chunks = 4 13 20 29\n **/\n//# sourceURL=webpack:///./src/components/search/MessageFieldSearchActions.jsx?")},88:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nObject.defineProperty(exports, '__esModule', {\n  value: true\n});\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _immutable = __webpack_require__(10);\n\nvar _immutable2 = _interopRequireDefault(_immutable);\n\nvar _MessageFieldDescription = __webpack_require__(86);\n\nvar _MessageFieldDescription2 = _interopRequireDefault(_MessageFieldDescription);\n\nvar MessageFields = _react2['default'].createClass({\n  displayName: 'MessageFields',\n\n  propTypes: {\n    message: _react.PropTypes.object.isRequired,\n    possiblyHighlight: _react.PropTypes.func.isRequired,\n    disableFieldActions: _react.PropTypes.bool,\n    customFieldActions: _react.PropTypes.node\n  },\n  SPECIAL_FIELDS: ['full_message', 'level'],\n  render: function render() {\n    var _this = this;\n\n    var fields = [];\n    var formattedFields = _immutable2['default'].Map(this.props.message.formatted_fields).sortBy(function (value, key) {\n      return key;\n    }, function (fieldA, fieldB) {\n      return fieldA.localeCompare(fieldB);\n    });\n    formattedFields.forEach(function (value, key) {\n      var innerValue = value;\n      if (_this.SPECIAL_FIELDS.indexOf(key) !== -1) {\n        innerValue = _this.props.message.fields[key];\n      }\n      fields.push(_react2['default'].createElement(\n        'dt',\n        { key: key + 'Title' },\n        key\n      ));\n      fields.push(_react2['default'].createElement(_MessageFieldDescription2['default'], { key: key + 'Description',\n        message: _this.props.message,\n        fieldName: key,\n        fieldValue: innerValue,\n        possiblyHighlight: _this.props.possiblyHighlight,\n        disableFieldActions: _this.props.disableFieldActions,\n        customFieldActions: _this.props.customFieldActions }));\n    });\n\n    return _react2['default'].createElement(\n      'dl',\n      { className: 'message-details message-details-fields' },\n      fields\n    );\n  }\n});\n\nexports['default'] = MessageFields;\nmodule.exports = exports['default'];\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"MessageFields.jsx\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/components/search/MessageFields.jsx\n ** module id = 88\n ** module chunks = 4 13 20 29\n **/\n//# sourceURL=webpack:///./src/components/search/MessageFields.jsx?")},99:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nObject.defineProperty(exports, '__esModule', {\n  value: true\n});\n\nvar _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _MessageDetail = __webpack_require__(78);\n\nvar _MessageDetail2 = _interopRequireDefault(_MessageDetail);\n\nvar MessageShow = _react2['default'].createClass({\n  displayName: 'MessageShow',\n\n  propTypes: {\n    message: _react.PropTypes.object,\n    inputs: _react.PropTypes.object,\n    streams: _react.PropTypes.object,\n    nodes: _react.PropTypes.object\n  },\n  possiblyHighlight: function possiblyHighlight(fieldName) {\n    // No highlighting for the message details view.\n    return this.props.message.fields[fieldName];\n  },\n  render: function render() {\n    return _react2['default'].createElement(\n      'div',\n      { className: 'row content' },\n      _react2['default'].createElement(\n        'div',\n        { className: 'col-md-12' },\n        _react2['default'].createElement(_MessageDetail2['default'], _extends({}, this.props, { message: this.props.message,\n          inputs: this.props.inputs,\n          streams: this.props.streams,\n          nodes: this.props.nodes,\n          possiblyHighlight: this.possiblyHighlight,\n          showTimestamp: true }))\n      )\n    );\n  }\n});\n\nexports['default'] = MessageShow;\nmodule.exports = exports['default'];\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"MessageShow.jsx\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/components/search/MessageShow.jsx\n ** module id = 99\n ** module chunks = 4 13 20 29\n **/\n//# sourceURL=webpack:///./src/components/search/MessageShow.jsx?");
},100:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nObject.defineProperty(exports, '__esModule', {\n  value: true\n});\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _reactRouter = __webpack_require__(105);\n\nvar _routingRoutes = __webpack_require__(11);\n\nvar _routingRoutes2 = _interopRequireDefault(_routingRoutes);\n\nvar StreamLink = _react2['default'].createClass({\n  displayName: 'StreamLink',\n\n  render: function render() {\n    var stream = this.props.stream;\n    var route = _routingRoutes2['default'].stream_search(stream.id);\n    return _react2['default'].createElement(\n      _reactRouter.Link,\n      { to: route },\n      stream.title\n    );\n  }\n});\n\nexports['default'] = StreamLink;\nmodule.exports = exports['default'];\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"StreamLink.jsx\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/components/streams/StreamLink.jsx\n ** module id = 100\n ** module chunks = 4 13 20 29\n **/\n//# sourceURL=webpack:///./src/components/streams/StreamLink.jsx?")},695:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nObject.defineProperty(exports, '__esModule', {\n  value: true\n});\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _reflux = __webpack_require__(3);\n\nvar _reflux2 = _interopRequireDefault(_reflux);\n\nvar _immutable = __webpack_require__(10);\n\nvar _immutable2 = _interopRequireDefault(_immutable);\n\nvar _componentsSearchMessageShow = __webpack_require__(99);\n\nvar _componentsSearchMessageShow2 = _interopRequireDefault(_componentsSearchMessageShow);\n\nvar _componentsCommonSpinner = __webpack_require__(27);\n\nvar _componentsCommonSpinner2 = _interopRequireDefault(_componentsCommonSpinner);\n\nvar _storesStreamsStreamsStore = __webpack_require__(31);\n\nvar _storesStreamsStreamsStore2 = _interopRequireDefault(_storesStreamsStreamsStore);\n\nvar _actionsNodesNodesActions = __webpack_require__(127);\n\nvar _actionsNodesNodesActions2 = _interopRequireDefault(_actionsNodesNodesActions);\n\nvar _storesNodesNodesStore = __webpack_require__(42);\n\nvar _storesNodesNodesStore2 = _interopRequireDefault(_storesNodesNodesStore);\n\nvar _actionsInputsInputsActions = __webpack_require__(43);\n\nvar _actionsInputsInputsActions2 = _interopRequireDefault(_actionsInputsInputsActions);\n\nvar _storesInputsInputsStore = __webpack_require__(57);\n\nvar _storesInputsInputsStore2 = _interopRequireDefault(_storesInputsInputsStore);\n\nvar _storesMessagesMessagesStore = __webpack_require__(51);\n\nvar _storesMessagesMessagesStore2 = _interopRequireDefault(_storesMessagesMessagesStore);\n\nvar ShowMessagePage = _react2['default'].createClass({\n  displayName: 'ShowMessagePage',\n\n  propTypes: {\n    params: _react.PropTypes.object\n  },\n  mixins: [_reflux2['default'].connect(_storesNodesNodesStore2['default']), _reflux2['default'].listenTo(_storesInputsInputsStore2['default'], '_formatInput')],\n  getInitialState: function getInitialState() {\n    return {\n      streams: undefined,\n      inputs: undefined,\n      message: undefined\n    };\n  },\n  componentDidMount: function componentDidMount() {\n    var _this = this;\n\n    _storesMessagesMessagesStore2['default'].loadMessage(this.props.params.index, this.props.params.messageId).then(function (message) {\n      _this.setState({ message: message });\n      _actionsInputsInputsActions2['default'].get.triggerPromise(message.source_input_id);\n    });\n    _storesStreamsStreamsStore2['default'].listStreams().then(function (streams) {\n      var streamsMap = {};\n      streams.forEach(function (stream) {\n        return streamsMap[stream.id] = stream;\n      });\n      _this.setState({ streams: _immutable2['default'].Map(streamsMap) });\n    });\n    _actionsNodesNodesActions2['default'].list.triggerPromise();\n  },\n  _formatInput: function _formatInput(state) {\n    var input = {};\n    input[state.input.id] = state.input;\n    this.setState({ inputs: _immutable2['default'].Map(input) });\n  },\n  _isLoaded: function _isLoaded() {\n    return this.state.message && this.state.streams && this.state.nodes && this.state.inputs;\n  },\n  render: function render() {\n    if (this._isLoaded()) {\n      return _react2['default'].createElement(_componentsSearchMessageShow2['default'], { message: this.state.message, inputs: this.state.inputs, nodes: _immutable2['default'].Map(this.state.nodes),\n        streams: this.state.streams, allStreamsLoaded: true });\n    } else {\n      return _react2['default'].createElement(_componentsCommonSpinner2['default'], null);\n    }\n  }\n});\n\nexports['default'] = ShowMessagePage;\nmodule.exports = exports['default'];\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"ShowMessagePage.jsx\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./~/react-hot-loader!./~/babel-loader!./src/pages/ShowMessagePage.jsx\n ** module id = 695\n ** module chunks = 29\n **/\n//# sourceURL=webpack:///./src/pages/ShowMessagePage.jsx?./~/react-hot-loader!./~/babel-loader")}});