webpackJsonp([32],{33:function(module,exports,__webpack_require__){eval('/// <reference path=\'../../../node_modules/immutable/dist/immutable.d.ts\'/>\n/// <reference path=\'../../routing/jsRoutes.d.ts\' />\n/// <reference path="../../../declarations/bluebird/bluebird.d.ts" />\n\'use strict\';\n\nvar Immutable = __webpack_require__(10);\nvar UserNotification = __webpack_require__(5);\nvar jsRoutes = __webpack_require__(9);\nvar URLUtils = __webpack_require__(7);\nvar Builder = __webpack_require__(6).Builder;\nvar fetch = __webpack_require__(6)[\'default\'];\nvar PermissionsMixin = __webpack_require__(18);\nvar CurrentUserStore = __webpack_require__(24);\nvar DashboardsStore = (function () {\n    function DashboardsStore() {\n        this._onWritableDashboardsChanged = [];\n        this._onDashboardsChanged = [];\n        this._dashboards = Immutable.List();\n        this._writableDashboards = Immutable.Map();\n    }\n    Object.defineProperty(DashboardsStore.prototype, "dashboards", {\n        get: function get() {\n            return this._dashboards;\n        },\n        set: function set(newDashboards) {\n            this._dashboards = newDashboards;\n            this._emitDashboardsChange();\n        },\n        enumerable: true,\n        configurable: true\n    });\n    DashboardsStore.prototype._emitDashboardsChange = function () {\n        var _this = this;\n        this._onDashboardsChanged.forEach(function (callback) {\n            return callback(_this.dashboards);\n        });\n    };\n    Object.defineProperty(DashboardsStore.prototype, "writableDashboards", {\n        get: function get() {\n            return this._writableDashboards;\n        },\n        set: function set(newDashboards) {\n            this._writableDashboards = newDashboards;\n            this._emitWritableDashboardsChange();\n        },\n        enumerable: true,\n        configurable: true\n    });\n    DashboardsStore.prototype._emitWritableDashboardsChange = function () {\n        var _this = this;\n        this._onWritableDashboardsChanged.forEach(function (callback) {\n            return callback(_this.writableDashboards);\n        });\n    };\n    DashboardsStore.prototype.addOnWritableDashboardsChangedCallback = function (dashboardChangeCallback) {\n        this._onWritableDashboardsChanged.push(dashboardChangeCallback);\n    };\n    DashboardsStore.prototype.addOnDashboardsChangedCallback = function (dashboardChangeCallback) {\n        this._onDashboardsChanged.push(dashboardChangeCallback);\n    };\n    DashboardsStore.prototype.updateWritableDashboards = function () {\n        var permissions = CurrentUserStore.get().permissions;\n        var dashboards = {};\n        this.updateDashboards();\n        this.getWritableDashboardList(permissions).forEach(function (dashboard) {\n            dashboards[dashboard.id] = dashboard;\n        });\n        this.writableDashboards = Immutable.Map(dashboards);\n    };\n    DashboardsStore.prototype.updateDashboards = function () {\n        var _this = this;\n        this.listDashboards().then(function (dashboardList) {\n            _this.dashboards = dashboardList;\n            return dashboardList;\n        });\n    };\n    DashboardsStore.prototype.listDashboards = function () {\n        var url = URLUtils.qualifyUrl(jsRoutes.controllers.api.DashboardsApiController.index().url);\n        var promise = fetch(\'GET\', url).then(function (response) {\n            var dashboardList = Immutable.List(response.dashboards);\n            return dashboardList;\n        }, function (error) {\n            if (error.additional.status !== 404) {\n                UserNotification.error("Loading dashboard list failed with status: " + error, "Could not load dashboards");\n            }\n        });\n        return promise;\n    };\n    DashboardsStore.prototype.getWritableDashboardList = function (permissions) {\n        return this.dashboards.toArray().filter(function (dashboard) {\n            return PermissionsMixin.isPermitted(permissions, \'dashboards:edit:\' + dashboard.id);\n        });\n    };\n    DashboardsStore.prototype.get = function (id) {\n        var url = URLUtils.qualifyUrl(jsRoutes.controllers.api.DashboardsApiController.get(id).url);\n        var promise = new Builder(\'GET\', url).authenticated().setHeader(\'X-Graylog-No-Session-Extension\', \'true\').json().build();\n        promise[\'catch\'](function (error) {\n            if (error.additional.status !== 404) {\n                UserNotification.error("Loading your dashboard failed with status: " + error.message, "Could not load your dashboard");\n            }\n        });\n        return promise;\n    };\n    DashboardsStore.prototype.createDashboard = function (title, description) {\n        var _this = this;\n        var url = URLUtils.qualifyUrl(jsRoutes.controllers.api.DashboardsApiController.create().url);\n        var promise = fetch(\'POST\', url, { title: title, description: description }).then(function (response) {\n            UserNotification.success("Dashboard successfully created");\n            if (_this._onDashboardsChanged.length > 0) {\n                _this.updateDashboards();\n            } else if (_this._onWritableDashboardsChanged.length > 0) {\n                _this.updateWritableDashboards();\n            }\n            return response.dashboard_id;\n        }, function (error) {\n            UserNotification.error("Creating dashboard \\"" + title + "\\" failed with status: " + error, "Could not create dashboard");\n        });\n        return promise;\n    };\n    DashboardsStore.prototype.saveDashboard = function (dashboard) {\n        var _this = this;\n        var url = URLUtils.qualifyUrl(jsRoutes.controllers.api.DashboardsApiController.update(dashboard.id).url);\n        var promise = fetch(\'PUT\', url, { title: dashboard.title, description: dashboard.description });\n        promise.then(function () {\n            UserNotification.success("Dashboard successfully updated");\n            if (_this._onDashboardsChanged.length > 0) {\n                _this.updateDashboards();\n            } else if (_this._onWritableDashboardsChanged.length > 0) {\n                _this.updateWritableDashboards();\n            }\n        }, function (error) {\n            UserNotification.error("Saving dashboard \\"" + dashboard.title + "\\" failed with status: " + error, "Could not save dashboard");\n        });\n        return promise;\n    };\n    DashboardsStore.prototype.remove = function (dashboard) {\n        var _this = this;\n        var url = URLUtils.qualifyUrl(jsRoutes.controllers.api.DashboardsApiController[\'delete\'](dashboard.id).url);\n        var promise = fetch(\'DELETE\', url);\n        promise.then(function () {\n            UserNotification.success("Dashboard successfully deleted");\n            if (_this._onDashboardsChanged.length > 0) {\n                _this.updateDashboards();\n            } else if (_this._onWritableDashboardsChanged.length > 0) {\n                _this.updateWritableDashboards();\n            }\n        }, function (error) {\n            UserNotification.error("Deleting dashboard \\"" + dashboard.title + "\\" failed with status: " + error, "Could not delete dashboard");\n        });\n        return promise;\n    };\n    DashboardsStore.prototype.updatePositions = function (dashboard, positions) {\n        var url = URLUtils.qualifyUrl(jsRoutes.controllers.api.DashboardsApiController.updatePositions(dashboard.id).url);\n        var promise = fetch(\'PUT\', url, { positions: positions })[\'catch\'](function (error) {\n            UserNotification.error("Updating widget positions for dashboard \\"" + dashboard.title + "\\" failed with status: " + error.message, "Could not update dashboard");\n        });\n        return promise;\n    };\n    return DashboardsStore;\n})();\nvar dashboardsStore = new DashboardsStore();\nmodule.exports = dashboardsStore;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/stores/dashboards/DashboardsStore.ts\n ** module id = 33\n ** module chunks = 4 6 7 23 32 33\n **/\n//# sourceURL=webpack:///./src/stores/dashboards/DashboardsStore.ts?')},62:function(module,exports,__webpack_require__){eval('/// <reference path="../../../declarations/bluebird/bluebird.d.ts" />\n\'use strict\';\n\nvar UserNotification = __webpack_require__(5);\nvar URLUtils = __webpack_require__(7);\nvar jsRoutes = __webpack_require__(9);\nvar fetch = __webpack_require__(6)[\'default\'];\nexports.RolesStore = {\n    loadRoles: function loadRoles() {\n        var promise = fetch(\'GET\', URLUtils.qualifyUrl(jsRoutes.controllers.api.RolesApiController.listRoles().url)).then(function (response) {\n            return response.roles;\n        }, function (error) {\n            if (error.additional.status !== 404) {\n                UserNotification.error("Loading role list failed with status: " + error, "Could not load role list");\n            }\n        });\n        return promise;\n    },\n    createRole: function createRole(role) {\n        var url = URLUtils.qualifyUrl(jsRoutes.controllers.api.RolesApiController.createRole().url);\n        var promise = fetch(\'POST\', url, role);\n        promise.then(function (newRole) {\n            UserNotification.success("Role \\"" + newRole.name + "\\" was created successfully");\n        }, function (error) {\n            UserNotification.error("Creating role \\"" + role.name + "\\" failed with status: " + error, "Could not create role");\n        });\n        return promise;\n    },\n    updateRole: function updateRole(rolename, role) {\n        var promise = fetch(\'PUT\', URLUtils.qualifyUrl(jsRoutes.controllers.api.RolesApiController.updateRole(rolename).url), role);\n        promise.then(function (newRole) {\n            UserNotification.success("Role \\"" + newRole.name + "\\" was updated successfully");\n        }, function (error) {\n            if (error.additional.status !== 404) {\n                UserNotification.error("Updating role failed with status: " + error, "Could not update role");\n            }\n        });\n        return promise;\n    },\n    deleteRole: function deleteRole(rolename) {\n        var url = URLUtils.qualifyUrl(jsRoutes.controllers.api.RolesApiController.deleteRole(rolename).url);\n        var promise = fetch(\'DELETE\', url);\n        promise.then(function () {\n            UserNotification.success("Role \\"" + rolename + "\\" was deleted successfully");\n        }, function (error) {\n            if (error.additional.status !== 404) {\n                UserNotification.error("Deleting role failed with status: " + error, "Could not delete role");\n            }\n        });\n        return promise;\n    },\n    getMembers: function getMembers(rolename) {\n        var url = URLUtils.qualifyUrl(jsRoutes.controllers.api.RolesApiController.loadMembers(rolename).url);\n        var promise = fetch(\'GET\', url);\n        promise[\'catch\'](function (error) {\n            if (error.additional.status !== 404) {\n                UserNotification.error("Could not load role\'s members with status: " + error, "Could not load role members");\n            }\n        });\n        return promise;\n    }\n};\nObject.defineProperty(exports, "__esModule", { value: true });\nexports[\'default\'] = exports.RolesStore;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/stores/users/RolesStore.ts\n ** module id = 62\n ** module chunks = 22 23 28 31 32 34\n **/\n//# sourceURL=webpack:///./src/stores/users/RolesStore.ts?')},653:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nvar React = __webpack_require__(1);\nvar Immutable = __webpack_require__(10);\nvar Row = __webpack_require__(2).Row;\nvar Col = __webpack_require__(2).Col;\nvar Button = __webpack_require__(2).Button;\nvar Input = __webpack_require__(2).Input;\nvar FormControls = __webpack_require__(2).FormControls;\nvar Alert = __webpack_require__(2).Alert;\n\nvar PermissionSelector = __webpack_require__(655);\nvar RolesStore = __webpack_require__(62).RolesStore;\nvar PermissionsMixin = __webpack_require__(18);\n\nvar EditRole = React.createClass({\n  displayName: 'EditRole',\n\n  mixins: [PermissionsMixin],\n\n  propTypes: {\n    initialRole: React.PropTypes.object,\n    onSave: React.PropTypes.func.isRequired,\n    cancelEdit: React.PropTypes.func.isRequired,\n    streams: React.PropTypes.object,\n    dashboards: React.PropTypes.object\n  },\n\n  getInitialState: function getInitialState() {\n    var role = this.props.initialRole;\n    if (role === null) {\n      // for the create dialog\n      role = { name: null, description: null, permissions: [] };\n    }\n    return {\n      role: role,\n      initialName: this._safeRoleName(this.props.initialRole)\n    };\n  },\n\n  _safeRoleName: function _safeRoleName(role) {\n    return role === null ? null : role.name;\n  },\n\n  componentWillReceiveProps: function componentWillReceiveProps(newProps) {\n    this.setState({ role: newProps.initialRole, initialName: this._safeRoleName(newProps.initialRole) });\n  },\n\n  _setName: function _setName(ev) {\n    var role = this.state.role;\n    role.name = ev.target.value;\n    this.setState({ role: this.state.role });\n  },\n  _setDescription: function _setDescription(ev) {\n    var role = this.state.role;\n    role.description = ev.target.value;\n    this.setState({ role: this.state.role });\n  },\n\n  _updatePermissions: function _updatePermissions(addedPerms, deletedPerms) {\n    var role = this.state.role;\n    role.permissions = Immutable.Set(role.permissions).subtract(deletedPerms).union(addedPerms).toJS();\n    this.setState({ role: role });\n  },\n\n  _saveDisabled: function _saveDisabled() {\n    return this.state.role === null || this.state.role.name === null || this.state.role.name === '' || this.state.role.permissions.length === 0;\n  },\n\n  render: function render() {\n    var _this = this;\n\n    var titleText = undefined;\n    if (this.state.initialName === null) {\n      titleText = 'Create a new role';\n    } else {\n      titleText = 'Edit role ' + this.state.initialName;\n    }\n\n    var saveDisabled = this._saveDisabled();\n    var saveDisabledAlert = null;\n    if (saveDisabled) {\n      saveDisabledAlert = React.createElement(\n        Alert,\n        { bsStyle: 'warning', style: { marginBottom: 10 } },\n        'Please name the role and select at least one permission to save it.'\n      );\n    }\n\n    return React.createElement(\n      Row,\n      null,\n      React.createElement(\n        Col,\n        { md: 12 },\n        React.createElement(\n          'h1',\n          null,\n          titleText\n        ),\n        React.createElement(\n          'div',\n          { style: { marginTop: 10 } },\n          React.createElement(Input, { id: 'role-name', type: 'text', label: 'Name', onChange: this._setName, value: this.state.role.name,\n            required: true }),\n          React.createElement(Input, { id: 'role-description', type: 'text', label: 'Description', onChange: this._setDescription,\n            value: this.state.role.description }),\n          React.createElement(FormControls.Static, { label: 'Permissions', help: 'Select the permissions for this role', className: 'hidden' }),\n          React.createElement(PermissionSelector, { streams: this.props.streams,\n            dashboards: this.props.dashboards,\n            permissions: Immutable.Set(this.state.role.permissions),\n            onChange: this._updatePermissions\n          }),\n          React.createElement('hr', null),\n          saveDisabledAlert,\n          React.createElement(\n            Button,\n            { onClick: function (ev) {\n                return _this.props.onSave(_this.state.initialName, _this.state.role);\n              }, style: { marginRight: 5 }, bsStyle: 'primary', disabled: saveDisabled },\n            'Save'\n          ),\n          React.createElement(\n            Button,\n            { onClick: this.props.cancelEdit },\n            'Cancel'\n          )\n        )\n      )\n    );\n  }\n});\n\nmodule.exports = EditRole;\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"EditRole.jsx\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/components/users/EditRole.jsx\n ** module id = 653\n ** module chunks = 32\n **/\n//# sourceURL=webpack:///./src/components/users/EditRole.jsx?")},655:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nObject.defineProperty(exports, '__esModule', {\n  value: true\n});\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _immutable = __webpack_require__(10);\n\nvar _immutable2 = _interopRequireDefault(_immutable);\n\nvar _reactBootstrap = __webpack_require__(2);\n\nvar _commonTableList = __webpack_require__(332);\n\nvar _commonTableList2 = _interopRequireDefault(_commonTableList);\n\nvar PermissionSelector = _react2['default'].createClass({\n  displayName: 'PermissionSelector',\n\n  propTypes: {\n    onChange: _react2['default'].PropTypes.func,\n    streams: _react2['default'].PropTypes.object,\n    dashboards: _react2['default'].PropTypes.object,\n    permissions: _react2['default'].PropTypes.object\n  },\n\n  render: function render() {\n    var _this = this;\n\n    var streamItemButtons = function streamItemButtons(stream) {\n      var isRead = _this.props.permissions.contains('streams:read:' + stream.id);\n      var isEdit = _this.props.permissions.contains('streams:edit:' + stream.id);\n      return _react2['default'].createElement(\n        _reactBootstrap.ButtonGroup,\n        { bsSize: 'small' },\n        _react2['default'].createElement(\n          _reactBootstrap.Button,\n          { bsStyle: isRead ? 'info' : 'default', onClick: function () {\n              return _this._toggleStreamReadPermissions(stream);\n            },\n            active: isRead },\n          'Allow reading'\n        ),\n        _react2['default'].createElement(\n          _reactBootstrap.Button,\n          { bsStyle: isEdit ? 'info' : 'default', onClick: function () {\n              return _this._toggleStreamEditPermissions(stream);\n            },\n            active: isEdit },\n          'Allow editing'\n        )\n      );\n    };\n\n    var multiStreamButtons = function multiStreamButtons(streamIds) {\n      return _react2['default'].createElement(\n        'div',\n        { className: 'pull-right', style: { marginTop: 10, marginBottom: 10 } },\n        _react2['default'].createElement(\n          _reactBootstrap.Button,\n          { bsSize: 'xsmall', bsStyle: 'info', onClick: function () {\n              return _this._toggleAllStreamsRead(streamIds);\n            } },\n          'Toggle read permissions'\n        ),\n        ' ',\n        _react2['default'].createElement(\n          _reactBootstrap.Button,\n          { bsSize: 'xsmall', bsStyle: 'info', onClick: function () {\n              return _this._toggleAllStreamsEdit(streamIds);\n            } },\n          'Toggle edit permissions'\n        )\n      );\n    };\n\n    var dashboardItemButtons = function dashboardItemButtons(dashboard) {\n      var isRead = _this.props.permissions.contains('dashboards:read:' + dashboard.id);\n      var isEdit = _this.props.permissions.contains('dashboards:edit:' + dashboard.id);\n      return _react2['default'].createElement(\n        _reactBootstrap.ButtonGroup,\n        { bsSize: 'small' },\n        _react2['default'].createElement(\n          _reactBootstrap.Button,\n          { bsStyle: isRead ? 'info' : 'default', onClick: function () {\n              return _this._toggleDashboardReadPermissions(dashboard);\n            },\n            active: isRead },\n          'Allow reading'\n        ),\n        _react2['default'].createElement(\n          _reactBootstrap.Button,\n          { bsStyle: isEdit ? 'info' : 'default', onClick: function () {\n              return _this._toggleDashboardEditPermissions(dashboard);\n            },\n            active: isEdit },\n          'Allow editing'\n        )\n      );\n    };\n\n    var multiDashboardButtons = function multiDashboardButtons(dashboardIds) {\n      return _react2['default'].createElement(\n        'div',\n        { className: 'pull-right', style: { marginTop: 10, marginBottom: 10 } },\n        _react2['default'].createElement(\n          _reactBootstrap.Button,\n          { bsSize: 'xsmall', bsStyle: 'info', onClick: function () {\n              return _this._toggleAllDashboardsRead(dashboardIds);\n            } },\n          'Toggle read permissions'\n        ),\n        ' ',\n        _react2['default'].createElement(\n          _reactBootstrap.Button,\n          { bsSize: 'xsmall', bsStyle: 'info', onClick: function () {\n              return _this._toggleAllDashboardsEdit(dashboardIds);\n            } },\n          'Toggle edit permissions'\n        )\n      );\n    };\n\n    return _react2['default'].createElement(\n      'div',\n      null,\n      _react2['default'].createElement(\n        _reactBootstrap.Tabs,\n        { defaultActiveKey: 1, animation: false },\n        _react2['default'].createElement(\n          _reactBootstrap.Tab,\n          { eventKey: 1, title: 'Streams' },\n          _react2['default'].createElement(\n            'div',\n            { style: { marginTop: 10 } },\n            _react2['default'].createElement(_commonTableList2['default'], {\n              items: this.props.streams,\n              filterLabel: 'Filter Streams',\n              filterKeys: ['title'],\n              itemActionsFactory: streamItemButtons,\n              headerActionsFactory: multiStreamButtons\n            })\n          )\n        ),\n        _react2['default'].createElement(\n          _reactBootstrap.Tab,\n          { eventKey: 2, title: 'Dashboards' },\n          _react2['default'].createElement(\n            'div',\n            { style: { marginTop: 10 } },\n            _react2['default'].createElement(_commonTableList2['default'], {\n              items: this.props.dashboards,\n              filterLabel: 'Filter Dashboards',\n              filterKeys: ['title'],\n              itemActionsFactory: dashboardItemButtons,\n              headerActionsFactory: multiDashboardButtons\n            })\n          )\n        )\n      )\n    );\n  },\n\n  /*\n   * onClick actions for single edits\n   */\n  _toggleStreamReadPermissions: function _toggleStreamReadPermissions(stream) {\n    this._toggleReadPermissions('streams', _immutable2['default'].Set.of(stream.id));\n  },\n\n  _toggleStreamEditPermissions: function _toggleStreamEditPermissions(stream) {\n    this._toggleEditPermissions('streams', _immutable2['default'].Set.of(stream.id));\n  },\n\n  _toggleDashboardReadPermissions: function _toggleDashboardReadPermissions(dashboard) {\n    this._toggleReadPermissions('dashboards', _immutable2['default'].Set.of(dashboard.id));\n  },\n\n  _toggleDashboardEditPermissions: function _toggleDashboardEditPermissions(dashboard) {\n    this._toggleEditPermissions('dashboards', _immutable2['default'].Set.of(dashboard.id));\n  },\n\n  /*\n   * onClick actions for bulk edits\n   */\n\n  _toggleAllStreamsRead: function _toggleAllStreamsRead(streamIds) {\n    this._toggleReadPermissions('streams', streamIds);\n  },\n\n  _toggleAllStreamsEdit: function _toggleAllStreamsEdit(streamIds) {\n    this._toggleEditPermissions('streams', streamIds);\n  },\n\n  _toggleAllDashboardsRead: function _toggleAllDashboardsRead(dashboardIds) {\n    this._toggleReadPermissions('dashboards', dashboardIds);\n  },\n\n  _toggleAllDashboardsEdit: function _toggleAllDashboardsEdit(dashboardIds) {\n    this._toggleEditPermissions('dashboards', dashboardIds);\n  },\n\n  _toggleReadPermissions: function _toggleReadPermissions(target, idList) {\n    var _this2 = this;\n\n    var added = _immutable2['default'].Set.of();\n    var deleted = _immutable2['default'].Set.of();\n\n    idList.forEach(function (id) {\n      var readTarget = target + ':read:' + id;\n      var editTarget = target + ':edit:' + id;\n\n      if (_this2.props.permissions.contains(readTarget)) {\n        deleted = deleted.add(readTarget).add(editTarget);\n      } else {\n        added = added.add(readTarget);\n      }\n    }, this);\n    this.props.onChange(added, deleted);\n  },\n  _toggleEditPermissions: function _toggleEditPermissions(target, idList) {\n    var _this3 = this;\n\n    var added = _immutable2['default'].Set.of();\n    var deleted = _immutable2['default'].Set.of();\n\n    idList.forEach(function (id) {\n      var readTarget = target + ':read:' + id;\n      var editTarget = target + ':edit:' + id;\n\n      if (_this3.props.permissions.contains(editTarget)) {\n        deleted = deleted.add(editTarget);\n      } else {\n        added = added.add(readTarget).add(editTarget);\n      }\n    }, this);\n    this.props.onChange(added, deleted);\n  }\n});\n\nexports['default'] = PermissionSelector;\nmodule.exports = exports['default'];\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"PermissionSelector.jsx\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/components/users/PermissionSelector.jsx\n ** module id = 655\n ** module chunks = 32\n **/\n//# sourceURL=webpack:///./src/components/users/PermissionSelector.jsx?")},656:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nvar React = __webpack_require__(1);\nvar Immutable = __webpack_require__(10);\n\nvar Button = __webpack_require__(2).Button;\n\nvar DataTable = __webpack_require__(178);\nvar PermissionsMixin = __webpack_require__(18);\n\nvar RoleList = React.createClass({\n    displayName: 'RoleList',\n\n    mixins: [PermissionsMixin],\n\n    propTypes: {\n        roles: React.PropTypes.instanceOf(Immutable.Set).isRequired,\n        showEditRole: React.PropTypes.func.isRequired,\n        deleteRole: React.PropTypes.func.isRequired,\n        createRole: React.PropTypes.func.isRequired\n    },\n\n    _headerCellFormatter: function _headerCellFormatter(header) {\n        return React.createElement(\n            'th',\n            null,\n            header\n        );\n    },\n    _roleInfoFormatter: function _roleInfoFormatter(role) {\n        var _this = this;\n\n        var actions = [React.createElement(\n            'button',\n            { key: 'delete', className: 'btn btn-primary btn-xs', onClick: function () {\n                    return _this.props.deleteRole(role);\n                }, title: 'Delete role' },\n            'Delete'\n        ), React.createElement(\n            'span',\n            { key: 'space' },\n            ' '\n        ), React.createElement(\n            'button',\n            { key: 'edit', className: 'btn btn-info btn-xs', onClick: function () {\n                    return _this.props.showEditRole(role);\n                }, title: 'Edit role' },\n            'Edit'\n        )];\n\n        return React.createElement(\n            'tr',\n            { key: role.name },\n            React.createElement(\n                'td',\n                null,\n                role.name\n            ),\n            React.createElement(\n                'td',\n                { className: 'limited' },\n                role.description\n            ),\n            React.createElement(\n                'td',\n                { style: { width: 150 } },\n                role.read_only ? null : actions\n            )\n        );\n    },\n    render: function render() {\n        var filterKeys = [\"name\", \"description\"];\n        var headers = [\"Name\", \"Description\", \"Actions\"];\n\n        return React.createElement(\n            'div',\n            null,\n            React.createElement(\n                DataTable,\n                { id: 'role-list',\n                    className: 'table-hover',\n                    headers: headers,\n                    headerCellFormatter: this._headerCellFormatter,\n                    sortByKey: \"name\",\n                    rows: this.props.roles.toJS(),\n                    filterBy: 'Name',\n                    dataRowFormatter: this._roleInfoFormatter,\n                    filterLabel: 'Filter Roles',\n                    filterKeys: filterKeys },\n                React.createElement(\n                    'div',\n                    { className: 'pull-right' },\n                    React.createElement(\n                        Button,\n                        { bsStyle: 'success', onClick: this.props.createRole },\n                        'Add new role'\n                    )\n                )\n            )\n        );\n    }\n});\n\nmodule.exports = RoleList;\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"RoleList.jsx\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/components/users/RoleList.jsx\n ** module id = 656\n ** module chunks = 32\n **/\n//# sourceURL=webpack:///./src/components/users/RoleList.jsx?");
},657:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nObject.defineProperty(exports, '__esModule', {\n  value: true\n});\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _immutable = __webpack_require__(10);\n\nvar _immutable2 = _interopRequireDefault(_immutable);\n\nvar _reactBootstrap = __webpack_require__(2);\n\nvar _storesStreamsStreamsStore = __webpack_require__(31);\n\nvar _storesStreamsStreamsStore2 = _interopRequireDefault(_storesStreamsStreamsStore);\n\nvar _storesDashboardsDashboardsStore = __webpack_require__(33);\n\nvar _storesDashboardsDashboardsStore2 = _interopRequireDefault(_storesDashboardsDashboardsStore);\n\nvar _storesUsersRolesStore = __webpack_require__(62);\n\nvar _storesUsersRolesStore2 = _interopRequireDefault(_storesUsersRolesStore);\n\nvar _utilUserNotification = __webpack_require__(5);\n\nvar _utilUserNotification2 = _interopRequireDefault(_utilUserNotification);\n\nvar _componentsUsersRoleList = __webpack_require__(656);\n\nvar _componentsUsersRoleList2 = _interopRequireDefault(_componentsUsersRoleList);\n\nvar _componentsUsersEditRole = __webpack_require__(653);\n\nvar _componentsUsersEditRole2 = _interopRequireDefault(_componentsUsersEditRole);\n\nvar RolesComponent = _react2['default'].createClass({\n  displayName: 'RolesComponent',\n\n  getInitialState: function getInitialState() {\n    return {\n      roles: _immutable2['default'].Set(),\n      rolesLoaded: false,\n      editRole: null,\n      streams: _immutable2['default'].List(),\n      dashboards: _immutable2['default'].List()\n    };\n  },\n  componentDidMount: function componentDidMount() {\n    var _this = this;\n\n    this.loadRoles();\n    _storesStreamsStreamsStore2['default'].load(function (streams) {\n      return _this.setState({ streams: _immutable2['default'].List(streams) });\n    });\n    _storesDashboardsDashboardsStore2['default'].listDashboards().then(function (dashboards) {\n      return _this.setState({ dashboards: dashboards });\n    });\n  },\n\n  loadRoles: function loadRoles() {\n    var _this2 = this;\n\n    var promise = _storesUsersRolesStore2['default'].loadRoles();\n    promise.then(function (roles) {\n      _this2.setState({ roles: _immutable2['default'].Set(roles), rolesLoaded: true });\n    });\n  },\n\n  _showCreateRole: function _showCreateRole() {\n    this.setState({ showEditRole: true });\n  },\n  _showEditRole: function _showEditRole(role) {\n    this.setState({ showEditRole: true, editRole: role });\n  },\n  _deleteRole: function _deleteRole(role) {\n    var _this3 = this;\n\n    if (window.confirm('Do you really want to delete role ' + role.name + '?')) {\n      _storesUsersRolesStore2['default'].getMembers(role.name).then(function (membership) {\n        if (membership.users.length !== 0) {\n          _utilUserNotification2['default'].error('Cannot delete role ' + role.name + '. It is still assigned to ' + membership.users.length + ' users.');\n        } else {\n          _storesUsersRolesStore2['default'].deleteRole(role.name).then(_this3.loadRoles);\n        }\n      });\n    }\n  },\n  _saveRole: function _saveRole(initialName, role) {\n    if (initialName === null) {\n      _storesUsersRolesStore2['default'].createRole(role).then(this._clearEditRole).then(this.loadRoles);\n    } else {\n      _storesUsersRolesStore2['default'].updateRole(initialName, role).then(this._clearEditRole).then(this.loadRoles);\n    }\n  },\n  _clearEditRole: function _clearEditRole() {\n    this.setState({ showEditRole: false, editRole: null });\n  },\n\n  render: function render() {\n    var content = null;\n    if (!this.state.rolesLoaded) {\n      content = _react2['default'].createElement(\n        'span',\n        null,\n        'Loading roles...'\n      );\n    } else if (this.state.showEditRole) {\n      content = _react2['default'].createElement(_componentsUsersEditRole2['default'], { initialRole: this.state.editRole, streams: this.state.streams, dashboards: this.state.dashboards,\n        onSave: this._saveRole, cancelEdit: this._clearEditRole });\n    } else {\n      content = _react2['default'].createElement(_componentsUsersRoleList2['default'], { roles: this.state.roles,\n        showEditRole: this._showEditRole,\n        deleteRole: this._deleteRole,\n        createRole: this._showCreateRole });\n    }\n    return _react2['default'].createElement(\n      _reactBootstrap.Row,\n      null,\n      _react2['default'].createElement(\n        _reactBootstrap.Col,\n        { md: 12 },\n        content\n      )\n    );\n  }\n});\n\nexports['default'] = RolesComponent;\nmodule.exports = exports['default'];\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"RolesComponent.jsx\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/components/users/RolesComponent.jsx\n ** module id = 657\n ** module chunks = 32\n **/\n//# sourceURL=webpack:///./src/components/users/RolesComponent.jsx?")},692:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nObject.defineProperty(exports, '__esModule', {\n  value: true\n});\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _reactBootstrap = __webpack_require__(2);\n\nvar _utilDocsHelper = __webpack_require__(14);\n\nvar _utilDocsHelper2 = _interopRequireDefault(_utilDocsHelper);\n\nvar _componentsCommonPageHeader = __webpack_require__(41);\n\nvar _componentsCommonPageHeader2 = _interopRequireDefault(_componentsCommonPageHeader);\n\nvar _componentsSupportDocumentationLink = __webpack_require__(28);\n\nvar _componentsSupportDocumentationLink2 = _interopRequireDefault(_componentsSupportDocumentationLink);\n\nvar _componentsUsersRolesComponent = __webpack_require__(657);\n\nvar _componentsUsersRolesComponent2 = _interopRequireDefault(_componentsUsersRolesComponent);\n\nvar RolesPage = _react2['default'].createClass({\n  displayName: 'RolesPage',\n\n  render: function render() {\n    return _react2['default'].createElement(\n      'span',\n      null,\n      _react2['default'].createElement(\n        _componentsCommonPageHeader2['default'],\n        { title: 'Roles' },\n        _react2['default'].createElement(\n          'span',\n          null,\n          'Roles bundle permissions which can be assigned to multiple users at once'\n        ),\n        _react2['default'].createElement(\n          'span',\n          null,\n          'Read more about Graylog roles in the ',\n          _react2['default'].createElement(_componentsSupportDocumentationLink2['default'], { page: _utilDocsHelper2['default'].PAGES.USERS_ROLE, text: 'documentation' }),\n          '.'\n        )\n      ),\n      _react2['default'].createElement(\n        _reactBootstrap.Row,\n        { className: 'content' },\n        _react2['default'].createElement(\n          _reactBootstrap.Col,\n          { md: 12 },\n          _react2['default'].createElement(_componentsUsersRolesComponent2['default'], null)\n        )\n      )\n    );\n  }\n});\n\nexports['default'] = RolesPage;\nmodule.exports = exports['default'];\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"RolesPage.jsx\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./~/react-hot-loader!./~/babel-loader!./src/pages/RolesPage.jsx\n ** module id = 692\n ** module chunks = 32\n **/\n//# sourceURL=webpack:///./src/pages/RolesPage.jsx?./~/react-hot-loader!./~/babel-loader")}});