webpackJsonp([33],{33:function(module,exports,__webpack_require__){eval('/// <reference path=\'../../../node_modules/immutable/dist/immutable.d.ts\'/>\n/// <reference path=\'../../routing/jsRoutes.d.ts\' />\n/// <reference path="../../../declarations/bluebird/bluebird.d.ts" />\n\'use strict\';\n\nvar Immutable = __webpack_require__(10);\nvar UserNotification = __webpack_require__(5);\nvar jsRoutes = __webpack_require__(9);\nvar URLUtils = __webpack_require__(7);\nvar Builder = __webpack_require__(6).Builder;\nvar fetch = __webpack_require__(6)[\'default\'];\nvar PermissionsMixin = __webpack_require__(18);\nvar CurrentUserStore = __webpack_require__(24);\nvar DashboardsStore = (function () {\n    function DashboardsStore() {\n        this._onWritableDashboardsChanged = [];\n        this._onDashboardsChanged = [];\n        this._dashboards = Immutable.List();\n        this._writableDashboards = Immutable.Map();\n    }\n    Object.defineProperty(DashboardsStore.prototype, "dashboards", {\n        get: function get() {\n            return this._dashboards;\n        },\n        set: function set(newDashboards) {\n            this._dashboards = newDashboards;\n            this._emitDashboardsChange();\n        },\n        enumerable: true,\n        configurable: true\n    });\n    DashboardsStore.prototype._emitDashboardsChange = function () {\n        var _this = this;\n        this._onDashboardsChanged.forEach(function (callback) {\n            return callback(_this.dashboards);\n        });\n    };\n    Object.defineProperty(DashboardsStore.prototype, "writableDashboards", {\n        get: function get() {\n            return this._writableDashboards;\n        },\n        set: function set(newDashboards) {\n            this._writableDashboards = newDashboards;\n            this._emitWritableDashboardsChange();\n        },\n        enumerable: true,\n        configurable: true\n    });\n    DashboardsStore.prototype._emitWritableDashboardsChange = function () {\n        var _this = this;\n        this._onWritableDashboardsChanged.forEach(function (callback) {\n            return callback(_this.writableDashboards);\n        });\n    };\n    DashboardsStore.prototype.addOnWritableDashboardsChangedCallback = function (dashboardChangeCallback) {\n        this._onWritableDashboardsChanged.push(dashboardChangeCallback);\n    };\n    DashboardsStore.prototype.addOnDashboardsChangedCallback = function (dashboardChangeCallback) {\n        this._onDashboardsChanged.push(dashboardChangeCallback);\n    };\n    DashboardsStore.prototype.updateWritableDashboards = function () {\n        var permissions = CurrentUserStore.get().permissions;\n        var dashboards = {};\n        this.updateDashboards();\n        this.getWritableDashboardList(permissions).forEach(function (dashboard) {\n            dashboards[dashboard.id] = dashboard;\n        });\n        this.writableDashboards = Immutable.Map(dashboards);\n    };\n    DashboardsStore.prototype.updateDashboards = function () {\n        var _this = this;\n        this.listDashboards().then(function (dashboardList) {\n            _this.dashboards = dashboardList;\n            return dashboardList;\n        });\n    };\n    DashboardsStore.prototype.listDashboards = function () {\n        var url = URLUtils.qualifyUrl(jsRoutes.controllers.api.DashboardsApiController.index().url);\n        var promise = fetch(\'GET\', url).then(function (response) {\n            var dashboardList = Immutable.List(response.dashboards);\n            return dashboardList;\n        }, function (error) {\n            if (error.additional.status !== 404) {\n                UserNotification.error("Loading dashboard list failed with status: " + error, "Could not load dashboards");\n            }\n        });\n        return promise;\n    };\n    DashboardsStore.prototype.getWritableDashboardList = function (permissions) {\n        return this.dashboards.toArray().filter(function (dashboard) {\n            return PermissionsMixin.isPermitted(permissions, \'dashboards:edit:\' + dashboard.id);\n        });\n    };\n    DashboardsStore.prototype.get = function (id) {\n        var url = URLUtils.qualifyUrl(jsRoutes.controllers.api.DashboardsApiController.get(id).url);\n        var promise = new Builder(\'GET\', url).authenticated().setHeader(\'X-Graylog-No-Session-Extension\', \'true\').json().build();\n        promise[\'catch\'](function (error) {\n            if (error.additional.status !== 404) {\n                UserNotification.error("Loading your dashboard failed with status: " + error.message, "Could not load your dashboard");\n            }\n        });\n        return promise;\n    };\n    DashboardsStore.prototype.createDashboard = function (title, description) {\n        var _this = this;\n        var url = URLUtils.qualifyUrl(jsRoutes.controllers.api.DashboardsApiController.create().url);\n        var promise = fetch(\'POST\', url, { title: title, description: description }).then(function (response) {\n            UserNotification.success("Dashboard successfully created");\n            if (_this._onDashboardsChanged.length > 0) {\n                _this.updateDashboards();\n            } else if (_this._onWritableDashboardsChanged.length > 0) {\n                _this.updateWritableDashboards();\n            }\n            return response.dashboard_id;\n        }, function (error) {\n            UserNotification.error("Creating dashboard \\"" + title + "\\" failed with status: " + error, "Could not create dashboard");\n        });\n        return promise;\n    };\n    DashboardsStore.prototype.saveDashboard = function (dashboard) {\n        var _this = this;\n        var url = URLUtils.qualifyUrl(jsRoutes.controllers.api.DashboardsApiController.update(dashboard.id).url);\n        var promise = fetch(\'PUT\', url, { title: dashboard.title, description: dashboard.description });\n        promise.then(function () {\n            UserNotification.success("Dashboard successfully updated");\n            if (_this._onDashboardsChanged.length > 0) {\n                _this.updateDashboards();\n            } else if (_this._onWritableDashboardsChanged.length > 0) {\n                _this.updateWritableDashboards();\n            }\n        }, function (error) {\n            UserNotification.error("Saving dashboard \\"" + dashboard.title + "\\" failed with status: " + error, "Could not save dashboard");\n        });\n        return promise;\n    };\n    DashboardsStore.prototype.remove = function (dashboard) {\n        var _this = this;\n        var url = URLUtils.qualifyUrl(jsRoutes.controllers.api.DashboardsApiController[\'delete\'](dashboard.id).url);\n        var promise = fetch(\'DELETE\', url);\n        promise.then(function () {\n            UserNotification.success("Dashboard successfully deleted");\n            if (_this._onDashboardsChanged.length > 0) {\n                _this.updateDashboards();\n            } else if (_this._onWritableDashboardsChanged.length > 0) {\n                _this.updateWritableDashboards();\n            }\n        }, function (error) {\n            UserNotification.error("Deleting dashboard \\"" + dashboard.title + "\\" failed with status: " + error, "Could not delete dashboard");\n        });\n        return promise;\n    };\n    DashboardsStore.prototype.updatePositions = function (dashboard, positions) {\n        var url = URLUtils.qualifyUrl(jsRoutes.controllers.api.DashboardsApiController.updatePositions(dashboard.id).url);\n        var promise = fetch(\'PUT\', url, { positions: positions })[\'catch\'](function (error) {\n            UserNotification.error("Updating widget positions for dashboard \\"" + dashboard.title + "\\" failed with status: " + error.message, "Could not update dashboard");\n        });\n        return promise;\n    };\n    return DashboardsStore;\n})();\nvar dashboardsStore = new DashboardsStore();\nmodule.exports = dashboardsStore;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/stores/dashboards/DashboardsStore.ts\n ** module id = 33\n ** module chunks = 4 6 7 23 32 33\n **/\n//# sourceURL=webpack:///./src/stores/dashboards/DashboardsStore.ts?')},121:function(module,exports,__webpack_require__){eval('\'use strict\';\n\nvar UserNotification = __webpack_require__(5);\nvar URLUtils = __webpack_require__(7);\nvar jsRoutes = __webpack_require__(9);\nvar fetch = __webpack_require__(6)[\'default\'];\nvar OutputsStore = {\n    OUTPUTS_URL: URLUtils.qualifyUrl(jsRoutes.controllers.api.OutputsApiController.index().url),\n    load: function load(callback) {\n        fetch(\'GET\', this.OUTPUTS_URL).then(callback, this._failCallback);\n    },\n    loadForStreamId: function loadForStreamId(streamId, callback) {\n        var url = URLUtils.qualifyUrl(jsRoutes.controllers.api.StreamOutputsApiController.index(streamId).url);\n        fetch(\'GET\', url).then(callback, this._failCallback);\n    },\n    loadAvailableTypes: function loadAvailableTypes(callback) {\n        var url = URLUtils.qualifyUrl(jsRoutes.controllers.api.OutputsApiController.availableTypes().url);\n        fetch(\'GET\', url).then(callback, this._failCallback);\n    },\n    loadAvailable: function loadAvailable(typeName, callback) {\n        var url = URLUtils.qualifyUrl(jsRoutes.controllers.api.OutputsApiController.availableTypes().url);\n        fetch(\'GET\', url).then(function (resp) {\n            return resp.types[typeName];\n        }, this._failCallback).then(callback);\n    },\n    remove: function remove(outputId, callback) {\n        var url = URLUtils.qualifyUrl(jsRoutes.controllers.api.OutputsApiController[\'delete\'](outputId).url);\n        fetch(\'DELETE\', url).then(callback, function (error) {\n            UserNotification.error("Terminating output failed with status: " + error, "Could not terminate output");\n        });\n    },\n    save: function save(output, callback) {\n        var failCallback = function failCallback(error) {\n            UserNotification.error("Saving Output \\"" + output.title + "\\" failed with status: " + error, "Could not save Output");\n        };\n        var url = URLUtils.qualifyUrl(jsRoutes.controllers.api.OutputsApiController.create().url);\n        fetch(\'POST\', url, output).then(callback, failCallback);\n    },\n    update: function update(output, deltas, callback) {\n        var failCallback = function failCallback(error) {\n            UserNotification.error("Updating Output \\"" + output.title + "\\" failed with status: " + error, "Could not update Output");\n        };\n        var url = URLUtils.qualifyUrl(jsRoutes.controllers.api.OutputsApiController.update(output.id).url);\n        fetch(\'PUT\', url, deltas).then(callback, failCallback);\n    },\n    _failCallback: function _failCallback(error) {\n        UserNotification.error("Loading outputs failed with status: " + error, "Could not load outputs");\n    }\n};\nmodule.exports = OutputsStore;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/stores/outputs/OutputsStore.ts\n ** module id = 121\n ** module chunks = 17 18 33\n **/\n//# sourceURL=webpack:///./src/stores/outputs/OutputsStore.ts?')},162:function(module,exports,__webpack_require__){eval('\'use strict\';\n\nvar UserNotification = __webpack_require__(5);\nvar URLUtils = __webpack_require__(7);\nvar fetch = __webpack_require__(6)[\'default\'];\nvar GrokPatternsStore = {\n    URL: URLUtils.qualifyUrl(\'/system/grok\'),\n    loadPatterns: function loadPatterns(callback) {\n        var failCallback = function failCallback(error) {\n            UserNotification.error("Loading Grok patterns failed with status: " + error.message, "Could not load Grok patterns");\n        };\n        // get the current list of patterns and sort it by name\n        fetch(\'GET\', this.URL).then(function (resp) {\n            var patterns = resp.patterns;\n            patterns.sort(function (pattern1, pattern2) {\n                return pattern1.name.toLowerCase().localeCompare(pattern2.name.toLowerCase());\n            });\n            callback(patterns);\n        }, failCallback);\n    },\n    savePattern: function savePattern(pattern, callback) {\n        var failCallback = function failCallback(error) {\n            UserNotification.error("Saving Grok pattern \\"" + pattern.name + "\\" failed with status: " + error.message, "Could not save Grok pattern");\n        };\n        var requestPatterb = {\n            id: pattern.id,\n            pattern: pattern.pattern,\n            name: pattern.name,\n            \'content_pack\': pattern[\'content_pack\']\n        };\n        var url = this.URL;\n        var method;\n        if (pattern.id === "") {\n            method = \'POST\';\n        } else {\n            url += \'/\' + pattern.id;\n            method = \'PUT\';\n        }\n        fetch(method, url, requestPatterb).then(function () {\n            callback();\n            var action = pattern.id === "" ? "created" : "updated";\n            var message = "Grok pattern \\"" + pattern.name + "\\" successfully " + action;\n            UserNotification.success(message);\n        })[\'catch\'](failCallback);\n    },\n    deletePattern: function deletePattern(pattern, callback) {\n        var failCallback = function failCallback(error) {\n            UserNotification.error("Deleting Grok pattern \\"" + pattern.name + "\\" failed with status: " + error.message, "Could not delete Grok pattern");\n        };\n        fetch(\'DELETE\', this.URL + "/" + pattern.id).then(function () {\n            callback();\n            UserNotification.success("Grok pattern \\"" + pattern.name + "\\" successfully deleted");\n        })[\'catch\'](failCallback);\n    },\n    bulkImport: function bulkImport(patterns, replaceAll) {\n        var failCallback = function failCallback(error) {\n            UserNotification.error("Importing Grok pattern file failed with status: " + error.message, "Could not load Grok patterns");\n        };\n        var promise = fetch(\'PUT\', this.URL, { patterns: patterns });\n        promise[\'catch\'](failCallback);\n        return promise;\n    }\n};\nObject.defineProperty(exports, "__esModule", { value: true });\nexports[\'default\'] = GrokPatternsStore;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/stores/grok-patterns/GrokPatternsStore.ts\n ** module id = 162\n ** module chunks = 25 33\n **/\n//# sourceURL=webpack:///./src/stores/grok-patterns/GrokPatternsStore.ts?')},667:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nObject.defineProperty(exports, '__esModule', {\n  value: true\n});\nvar FileSaver = {\n  save: function save(data, filename, mime, charset) {\n    var link = document.createElement('a');\n\n    var effectiveCharset = charset ? ';charset=' + charset : '';\n    var contentType = charset ? '' + mime + effectiveCharset : mime;\n\n    // On modern browsers (Chrome and Firefox), use download property and a temporary link\n    if (link.download !== undefined) {\n      link.download = filename;\n      link.href = 'data:' + contentType + ',' + encodeURIComponent(data);\n      document.body.appendChild(link);\n      link.click();\n      document.body.removeChild(link);\n\n      return;\n    }\n\n    // On IE >= 10, use msSaveOrOpenBlob\n    if (window.navigator && typeof window.navigator.msSaveOrOpenBlob === 'function') {\n      var blob = new Blob([data], { type: contentType });\n      window.navigator.msSaveOrOpenBlob(blob, filename);\n\n      return;\n    }\n\n    try {\n      // On Safari and other browsers, try to open the JSON as attachment\n      location.href = 'data:application/attachment' + effectiveCharset + ',' + encodeURIComponent(data);\n    } catch (e) {\n      // If nothing else works, open the JSON as plain text in the browser\n      location.href = 'data:text/plain' + effectiveCharset + ',' + encodeURIComponent(data);\n    }\n  }\n};\n\nexports['default'] = FileSaver;\nmodule.exports = exports['default'];\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"FileSaver.js\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/logic/files/FileSaver.js\n ** module id = 667\n ** module chunks = 33\n **/\n//# sourceURL=webpack:///./src/logic/files/FileSaver.js?")},676:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nObject.defineProperty(exports, '__esModule', {\n  value: true\n});\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _reflux = __webpack_require__(3);\n\nvar _reflux2 = _interopRequireDefault(_reflux);\n\nvar _reactBootstrap = __webpack_require__(2);\n\nvar _logicFilesFileSaver = __webpack_require__(667);\n\nvar _logicFilesFileSaver2 = _interopRequireDefault(_logicFilesFileSaver);\n\nvar _utilUserNotification = __webpack_require__(5);\n\nvar _utilUserNotification2 = _interopRequireDefault(_utilUserNotification);\n\nvar _storesDashboardsDashboardsStore = __webpack_require__(33);\n\nvar _storesDashboardsDashboardsStore2 = _interopRequireDefault(_storesDashboardsDashboardsStore);\n\nvar _storesGrokPatternsGrokPatternsStore = __webpack_require__(162);\n\nvar _storesGrokPatternsGrokPatternsStore2 = _interopRequireDefault(_storesGrokPatternsGrokPatternsStore);\n\nvar _actionsInputsInputsActions = __webpack_require__(43);\n\nvar _actionsInputsInputsActions2 = _interopRequireDefault(_actionsInputsInputsActions);\n\nvar _storesInputsInputsStore = __webpack_require__(57);\n\nvar _storesInputsInputsStore2 = _interopRequireDefault(_storesInputsInputsStore);\n\nvar _storesOutputsOutputsStore = __webpack_require__(121);\n\nvar _storesOutputsOutputsStore2 = _interopRequireDefault(_storesOutputsOutputsStore);\n\nvar _storesStreamsStreamsStore = __webpack_require__(31);\n\nvar _storesStreamsStreamsStore2 = _interopRequireDefault(_storesStreamsStreamsStore);\n\nvar _actionsConfigurationBundlesConfigurationBundlesActions = __webpack_require__(126);\n\nvar _actionsConfigurationBundlesConfigurationBundlesActions2 = _interopRequireDefault(_actionsConfigurationBundlesConfigurationBundlesActions);\n\nvar _storesConfigurationBundlesConfigurationBundlesStore = __webpack_require__(286);\n\nvar _storesConfigurationBundlesConfigurationBundlesStore2 = _interopRequireDefault(_storesConfigurationBundlesConfigurationBundlesStore);\n\nvar _componentsCommonPageHeader = __webpack_require__(41);\n\nvar _componentsCommonPageHeader2 = _interopRequireDefault(_componentsCommonPageHeader);\n\nvar ExportContentPackPage = _react2['default'].createClass({\n  displayName: 'ExportContentPackPage',\n\n  mixins: [_reflux2['default'].connect(_storesInputsInputsStore2['default'])],\n  getInitialState: function getInitialState() {\n    return {};\n  },\n  componentDidMount: function componentDidMount() {\n    var _this = this;\n\n    _storesDashboardsDashboardsStore2['default'].listDashboards().then(function (dashboards) {\n      _this.setState({ dashboards: dashboards });\n    });\n    _storesGrokPatternsGrokPatternsStore2['default'].loadPatterns(function (grokPatterns) {\n      _this.setState({ grok_patterns: grokPatterns });\n    });\n    _actionsInputsInputsActions2['default'].list();\n    _storesOutputsOutputsStore2['default'].load(function (resp) {\n      _this.setState({ outputs: resp.outputs });\n    });\n    _storesStreamsStreamsStore2['default'].listStreams().then(function (streams) {\n      _this.setState({ streams: streams });\n    });\n  },\n  onSubmit: function onSubmit(evt) {\n    var _this2 = this;\n\n    evt.preventDefault();\n    var request = {\n      streams: [],\n      inputs: [],\n      outputs: [],\n      dashboards: [],\n      grok_patterns: []\n    };\n    Object.keys(this.refs).forEach(function (key) {\n      if (key.indexOf('.') === -1) {\n        request[key] = _this2.refs[key].value;\n      } else {\n        if (_this2.refs[key].checked) {\n          var group = key.split('.')[0];\n          var id = key.split('.')[1];\n\n          request[group].push(id);\n        }\n      }\n    });\n    _actionsConfigurationBundlesConfigurationBundlesActions2['default']['export'].triggerPromise(request).then(function (response) {\n      _utilUserNotification2['default'].success('Successfully export content pack. Starting download...', 'Success!');\n      _logicFilesFileSaver2['default'].save(response, 'content_pack.json', 'application/json', 'utf-8');\n    });\n  },\n  isEmpty: function isEmpty(obj) {\n    return obj === undefined || (typeof obj.count === 'function' ? obj.count() === 0 : obj.length === 0);\n  },\n  inputDetails: function inputDetails(input) {\n    var details = input.name;\n    if (input.attributes.bind_address) {\n      details += ' on ' + input.attributes.bind_address;\n      if (input.attributes.port) {\n        details += ' port ' + input.attributes.port;\n      }\n    }\n\n    return details;\n  },\n  formatDashboard: function formatDashboard(dashboard) {\n    return _react2['default'].createElement(\n      'div',\n      { className: 'checkbox', key: 'dashboard_checkbox-' + dashboard.id },\n      _react2['default'].createElement(\n        'label',\n        { className: 'checkbox' },\n        _react2['default'].createElement('input', { ref: 'dashboards.' + dashboard.id, type: 'checkbox', name: 'dashboards', id: 'dashboard_' + dashboard.id, value: dashboard.id }),\n        dashboard.title\n      )\n    );\n  },\n  formatGrokPattern: function formatGrokPattern(grokPattern) {\n    return _react2['default'].createElement(\n      'div',\n      { className: 'checkbox', key: 'grok_pattern_checkbox-' + grokPattern.id },\n      _react2['default'].createElement(\n        'label',\n        { className: 'checkbox' },\n        _react2['default'].createElement('input', { ref: 'grok_patterns.' + grokPattern.id, type: 'checkbox', name: 'grokPatterns', id: 'grokPattern_' + grokPattern.id, value: grokPattern.id }),\n        grokPattern.name\n      ),\n      _react2['default'].createElement(\n        'span',\n        { className: 'help-inline' },\n        'Pattern: ',\n        _react2['default'].createElement(\n          'tt',\n          null,\n          grokPattern.pattern\n        )\n      )\n    );\n  },\n  formatInput: function formatInput(input) {\n    return _react2['default'].createElement(\n      'div',\n      { className: 'checkbox', key: 'input_checkbox-' + input.id },\n      _react2['default'].createElement(\n        'label',\n        { className: 'checkbox' },\n        _react2['default'].createElement('input', { ref: 'inputs.' + input.id, type: 'checkbox', name: 'inputs', id: 'input_' + input.id, value: input.id }),\n        input.title\n      ),\n      _react2['default'].createElement(\n        'span',\n        { className: 'help-inline' },\n        '(',\n        this.inputDetails(input),\n        ')'\n      )\n    );\n  },\n  formatOutput: function formatOutput(output) {\n    return _react2['default'].createElement(\n      'div',\n      { className: 'checkbox', key: 'output_checkbox-' + output.id },\n      _react2['default'].createElement(\n        'label',\n        { className: 'checkbox' },\n        _react2['default'].createElement('input', { ref: 'outputs.' + output.id, type: 'checkbox', name: 'outputs', id: 'output_' + output.id, value: output.id }),\n        output.title\n      )\n    );\n  },\n  formatStream: function formatStream(stream) {\n    return _react2['default'].createElement(\n      'div',\n      { className: 'checkbox', key: 'stream_checkbox-' + stream.id },\n      _react2['default'].createElement(\n        'label',\n        { className: 'checkbox' },\n        _react2['default'].createElement('input', { ref: 'streams.' + stream.id, type: 'checkbox', name: 'streams', id: 'stream_' + stream.id, value: stream.id }),\n        stream.title\n      )\n    );\n  },\n  selectAll: function selectAll(group) {\n    var _this3 = this;\n\n    Object.keys(this.refs).forEach(function (key) {\n      if (key.indexOf(group) === 0) {\n        _this3.refs[key].checked = true;\n      }\n    });\n  },\n  render: function render() {\n    return _react2['default'].createElement(\n      'span',\n      null,\n      _react2['default'].createElement(\n        _componentsCommonPageHeader2['default'],\n        { title: 'Create a content pack' },\n        _react2['default'].createElement(\n          'span',\n          null,\n          'Export your inputs, outputs, streams and dashboards as a content pack and share it with the community or other setups.'\n        )\n      ),\n      _react2['default'].createElement(\n        _reactBootstrap.Row,\n        { className: 'content' },\n        _react2['default'].createElement(\n          _reactBootstrap.Col,\n          { md: 6 },\n          _react2['default'].createElement(\n            'form',\n            { className: 'form-horizontal build-content-pack', onSubmit: this.onSubmit },\n            _react2['default'].createElement(\n              'div',\n              { className: 'form-group' },\n              _react2['default'].createElement(\n                _reactBootstrap.Col,\n                { sm: 2 },\n                _react2['default'].createElement(\n                  'label',\n                  { className: 'control-label', htmlFor: 'name' },\n                  'Name'\n                )\n              ),\n              _react2['default'].createElement(\n                _reactBootstrap.Col,\n                { sm: 10 },\n                _react2['default'].createElement('input', { ref: 'name', type: 'text', id: 'name', className: 'input-xlarge form-control', name: 'name', required: true }),\n                _react2['default'].createElement(\n                  'span',\n                  { className: 'help-block' },\n                  'The name of your configuration bundle.'\n                )\n              )\n            ),\n            _react2['default'].createElement(\n              'div',\n              { className: 'form-group' },\n              _react2['default'].createElement(\n                _reactBootstrap.Col,\n                { sm: 2 },\n                _react2['default'].createElement(\n                  'label',\n                  { className: 'control-label', htmlFor: 'description' },\n                  'Description'\n                )\n              ),\n              _react2['default'].createElement(\n                _reactBootstrap.Col,\n                { sm: 10 },\n                _react2['default'].createElement('textarea', { ref: 'description', rows: '6', id: 'description', name: 'description', className: 'input-xlarge form-control', required: true }),\n                _react2['default'].createElement(\n                  'span',\n                  { className: 'help-block' },\n                  'A description of what your bundle does and possible special instructions for the user. You can use ',\n                  _react2['default'].createElement(\n                    'a',\n                    { href: 'http://daringfireball.net/projects/markdown/syntax', target: '_blank' },\n                    'Markdown'\n                  ),\n                  ' syntax.'\n                )\n              )\n            ),\n            _react2['default'].createElement(\n              'div',\n              { className: 'form-group' },\n              _react2['default'].createElement(\n                _reactBootstrap.Col,\n                { sm: 2 },\n                _react2['default'].createElement(\n                  'label',\n                  { className: 'control-label', htmlFor: 'category' },\n                  'Category'\n                )\n              ),\n              _react2['default'].createElement(\n                _reactBootstrap.Col,\n                { sm: 10 },\n                _react2['default'].createElement('input', { ref: 'category', type: 'text', id: 'category', name: 'category', className: 'input-xlarge form-control', required: true }),\n                _react2['default'].createElement(\n                  'span',\n                  { className: 'help-block' },\n                  'A category for your bundle, e.g. Operating Systems, Firewalls or Switches.'\n                )\n              )\n            ),\n            _react2['default'].createElement(\n              'div',\n              { className: 'form-group' },\n              _react2['default'].createElement(\n                _reactBootstrap.Col,\n                { sm: 2 },\n                _react2['default'].createElement(\n                  'label',\n                  { className: 'control-label', htmlFor: 'inputs' },\n                  'Inputs'\n                )\n              ),\n              _react2['default'].createElement(\n                _reactBootstrap.Col,\n                { sm: 10 },\n                this.isEmpty(this.state.inputs) ? _react2['default'].createElement(\n                  'span',\n                  { className: 'help-block help-standalone' },\n                  'There are no inputs to export.'\n                ) : _react2['default'].createElement(\n                  'span',\n                  null,\n                  _react2['default'].createElement(\n                    _reactBootstrap.Button,\n                    { className: 'btn btn-sm btn-link select-all', onClick: this.selectAll.bind(this, 'input') },\n                    'Select all'\n                  ),\n                  this.state.inputs.sort(function (i1, i2) {\n                    return i1.title.localeCompare(i2.title);\n                  }).map(this.formatInput)\n                )\n              )\n            ),\n            _react2['default'].createElement(\n              'div',\n              { className: 'form-group' },\n              _react2['default'].createElement(\n                _reactBootstrap.Col,\n                { sm: 2 },\n                _react2['default'].createElement(\n                  'label',\n                  { className: 'control-label', htmlFor: 'grokPatterns' },\n                  'Grok Patterns'\n                )\n              ),\n              _react2['default'].createElement(\n                _reactBootstrap.Col,\n                { sm: 10 },\n                this.isEmpty(this.state.grok_patterns) ? _react2['default'].createElement(\n                  'span',\n                  { className: 'help-block help-standalone' },\n                  'There are no grok patterns to export.'\n                ) : _react2['default'].createElement(\n                  'span',\n                  null,\n                  _react2['default'].createElement(\n                    _reactBootstrap.Button,\n                    { className: 'btn btn-sm btn-link select-all', onClick: this.selectAll.bind(this, 'grok_pattern') },\n                    'Select all'\n                  ),\n                  this.state.grok_patterns.sort(function (g1, g2) {\n                    return g1.name.localeCompare(g2.name);\n                  }).map(this.formatGrokPattern)\n                )\n              )\n            ),\n            _react2['default'].createElement(\n              'div',\n              { className: 'form-group' },\n              _react2['default'].createElement(\n                _reactBootstrap.Col,\n                { sm: 2 },\n                _react2['default'].createElement(\n                  'label',\n                  { className: 'control-label', htmlFor: 'outputs' },\n                  'Outputs'\n                )\n              ),\n              _react2['default'].createElement(\n                _reactBootstrap.Col,\n                { sm: 10 },\n                this.isEmpty(this.state.outputs) ? _react2['default'].createElement(\n                  'span',\n                  { className: 'help-block help-standalone' },\n                  'There are no outputs to export.'\n                ) : _react2['default'].createElement(\n                  'span',\n                  null,\n                  _react2['default'].createElement(\n                    _reactBootstrap.Button,\n                    { className: 'btn btn-sm btn-link select-all', onClick: this.selectAll.bind(this, 'output') },\n                    'Select all'\n                  ),\n                  this.state.outputs.sort(function (o1, o2) {\n                    return o1.title.localeCompare(o2.title);\n                  }).map(this.formatOutput)\n                )\n              )\n            ),\n            _react2['default'].createElement(\n              'div',\n              { className: 'form-group' },\n              _react2['default'].createElement(\n                _reactBootstrap.Col,\n                { sm: 2 },\n                _react2['default'].createElement(\n                  'label',\n                  { className: 'control-label', htmlFor: 'streams' },\n                  'Streams'\n                )\n              ),\n              _react2['default'].createElement(\n                _reactBootstrap.Col,\n                { sm: 10 },\n                this.isEmpty(this.state.streams) ? _react2['default'].createElement(\n                  'span',\n                  { className: 'help-block help-standalone' },\n                  'There are no streams to export.'\n                ) : _react2['default'].createElement(\n                  'span',\n                  null,\n                  _react2['default'].createElement(\n                    _reactBootstrap.Button,\n                    { className: 'btn btn-sm btn-link select-all', onClick: this.selectAll.bind(this, 'stream') },\n                    'Select all'\n                  ),\n                  this.state.streams.sort(function (s1, s2) {\n                    return s1.title.localeCompare(s2.title);\n                  }).map(this.formatStream)\n                )\n              )\n            ),\n            _react2['default'].createElement(\n              'div',\n              { className: 'form-group' },\n              _react2['default'].createElement(\n                _reactBootstrap.Col,\n                { sm: 2 },\n                _react2['default'].createElement(\n                  'label',\n                  { className: 'control-label', htmlFor: 'dashboards' },\n                  'Dashboards'\n                )\n              ),\n              _react2['default'].createElement(\n                _reactBootstrap.Col,\n                { sm: 10 },\n                this.isEmpty(this.state.dashboards) ? _react2['default'].createElement(\n                  'span',\n                  { className: 'help-block help-standalone' },\n                  'There are no dashboards to export.'\n                ) : _react2['default'].createElement(\n                  'span',\n                  null,\n                  _react2['default'].createElement(\n                    _reactBootstrap.Button,\n                    { className: 'btn btn-sm btn-link select-all', onClick: this.selectAll.bind(this, 'dashboard') },\n                    'Select all'\n                  ),\n                  this.state.dashboards.sort(function (d1, d2) {\n                    return d1.title.localeCompare(d2.title);\n                  }).map(this.formatDashboard)\n                )\n              )\n            ),\n            _react2['default'].createElement(\n              'div',\n              { className: 'form-group' },\n              _react2['default'].createElement(\n                _reactBootstrap.Col,\n                { smOffset: 2, sm: 10 },\n                _react2['default'].createElement(\n                  _reactBootstrap.Button,\n                  { bsStyle: 'success', type: 'submit' },\n                  _react2['default'].createElement('i', { className: 'fa fa-cloud-download' }),\n                  ' Download my content pack'\n                ),\n                _react2['default'].createElement('br', null),\n                _react2['default'].createElement('br', null),\n                _react2['default'].createElement(\n                  'p',\n                  null,\n                  _react2['default'].createElement('i', { className: 'fa fa-lightbulb-o' }),\n                  '  Share your content pack with the community on ',\n                  _react2['default'].createElement(\n                    'a',\n                    { href: 'https://www.graylog.org/resources/data-sources/', target: '_blank' },\n                    'graylog.org'\n                  ),\n                  ' after you have downloaded it.'\n                )\n              )\n            )\n          )\n        )\n      )\n    );\n  }\n});\n\nexports['default'] = ExportContentPackPage;\nmodule.exports = exports['default'];\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"ExportContentPackPage.jsx\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./~/react-hot-loader!./~/babel-loader!./src/pages/ExportContentPackPage.jsx\n ** module id = 676\n ** module chunks = 33\n **/\n//# sourceURL=webpack:///./src/pages/ExportContentPackPage.jsx?./~/react-hot-loader!./~/babel-loader");
}});