webpackJsonp([36],{374:function(module,exports,__webpack_require__){eval("'use strict';\n\nvar UserNotification = __webpack_require__(5);\nvar URLUtils = __webpack_require__(7);\nvar fetch = __webpack_require__(6)['default'];\nvar CollectorsStore = {\n    URL: URLUtils.qualifyUrl('/system/collectors'),\n    load: function load(callback) {\n        var failCallback = function failCallback(error) {\n            UserNotification.error(\"Loading collectors failed with status: \" + error.message, \"Could not load collectors\");\n        };\n        fetch('GET', this.URL).then(callback, failCallback);\n    }\n};\nObject.defineProperty(exports, \"__esModule\", { value: true });\nexports['default'] = CollectorsStore;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/stores/collectors/CollectorsStore.ts\n ** module id = 374\n ** module chunks = 36\n **/\n//# sourceURL=webpack:///./src/stores/collectors/CollectorsStore.ts?")},558:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nObject.defineProperty(exports, '__esModule', {\n  value: true\n});\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _reactBootstrap = __webpack_require__(2);\n\nvar _storesCollectorsCollectorsStore = __webpack_require__(374);\n\nvar _storesCollectorsCollectorsStore2 = _interopRequireDefault(_storesCollectorsCollectorsStore);\n\nvar _CollectorRow = __webpack_require__(559);\n\nvar _CollectorRow2 = _interopRequireDefault(_CollectorRow);\n\nvar _componentsCommon = __webpack_require__(4);\n\nvar CollectorList = _react2['default'].createClass({\n  displayName: 'CollectorList',\n\n  getInitialState: function getInitialState() {\n    return {\n      filter: '',\n      sort: undefined,\n      showInactive: false\n    };\n  },\n  componentDidMount: function componentDidMount() {\n    this.loadData();\n  },\n  componentWillUnmount: function componentWillUnmount() {\n    if (this.interval) {\n      clearInterval(this.interval);\n    }\n  },\n  COLLECTOR_DATA_REFRESH: 5 * 1000,\n\n  loadData: function loadData() {\n    var _this = this;\n\n    _storesCollectorsCollectorsStore2['default'].load(function (resp) {\n      if (_this.isMounted()) {\n        _this.setState({\n          collectors: resp.collectors\n        });\n      }\n    });\n\n    this.interval = setTimeout(this.loadData, this.COLLECTOR_DATA_REFRESH);\n  },\n  _getFilteredCollectors: function _getFilteredCollectors() {\n    var filter = this.state.filter.toLowerCase().trim();\n    return this.state.collectors.filter(function (collector) {\n      return !filter || collector.id.toLowerCase().indexOf(filter) !== -1 || collector.node_id.toLowerCase().indexOf(filter) !== -1 || collector.node_details.operating_system.toLowerCase().indexOf(filter) !== -1;\n    });\n  },\n  _bySortField: function _bySortField(collector1, collector2) {\n    var sort = this.state.sort || function (collector) {\n      return collector.id;\n    };\n    var field1 = sort(collector1);\n    var field2 = sort(collector2);\n    if (typeof field1 === 'number') {\n      return field2 - field1;\n    }\n\n    return field1.localeCompare(field2);\n  },\n  _formatCollectorList: function _formatCollectorList(collectors) {\n    return _react2['default'].createElement(\n      'div',\n      { className: 'table-responsive' },\n      _react2['default'].createElement(\n        'table',\n        { className: 'table table-striped collectors-list' },\n        _react2['default'].createElement(\n          'thead',\n          null,\n          _react2['default'].createElement(\n            'tr',\n            null,\n            _react2['default'].createElement(\n              'th',\n              { onClick: this.sortByNodeId },\n              'Host Name'\n            ),\n            _react2['default'].createElement(\n              'th',\n              { onClick: this.sortByOperatingSystem },\n              'Operating System'\n            ),\n            _react2['default'].createElement(\n              'th',\n              { onClick: this.sortByLastSeen },\n              'Last Seen'\n            ),\n            _react2['default'].createElement(\n              'th',\n              { className: 'name', onClick: this.sortById },\n              'Collector Id'\n            ),\n            _react2['default'].createElement(\n              'th',\n              { onClick: this.sortByCollectorVersion },\n              'Collector Version'\n            ),\n            _react2['default'].createElement(\n              'th',\n              { style: { width: 170 } },\n              ' '\n            )\n          )\n        ),\n        _react2['default'].createElement(\n          'tbody',\n          null,\n          collectors\n        )\n      )\n    );\n  },\n  toggleShowInactive: function toggleShowInactive() {\n    this.setState({ showInactive: !this.state.showInactive });\n  },\n  sortById: function sortById() {\n    this.setState({ sort: function sort(collector) {\n        return collector.id;\n      } });\n  },\n  sortByNodeId: function sortByNodeId() {\n    this.setState({ sort: function sort(collector) {\n        return collector.node_id;\n      } });\n  },\n  sortByOperatingSystem: function sortByOperatingSystem() {\n    this.setState({ sort: function sort(collector) {\n        return collector.node_details.operating_system;\n      } });\n  },\n  sortByLastSeen: function sortByLastSeen() {\n    this.setState({ sort: function sort(collector) {\n        return collector.last_seen;\n      } });\n  },\n  sortByCollectorVersion: function sortByCollectorVersion() {\n    this.setState({ sort: function sort(collector) {\n        return collector.collector_version;\n      } });\n  },\n  _formatEmptyListAlert: function _formatEmptyListAlert() {\n    var showInactiveHint = this.state.showInactive ? null : ' and/or click on \\\"Include inactive collectors\\\"';\n    return _react2['default'].createElement(\n      _reactBootstrap.Alert,\n      null,\n      'There are no collectors to show. Try adjusting your search filter',\n      showInactiveHint,\n      '.'\n    );\n  },\n  render: function render() {\n    var _this2 = this;\n\n    if (this.state.collectors) {\n      var collectors = this._getFilteredCollectors().filter(function (collector) {\n        return _this2.state.showInactive || collector.active;\n      }).sort(this._bySortField).map(function (collector) {\n        return _react2['default'].createElement(_CollectorRow2['default'], { key: collector.id, collector: collector });\n      });\n\n      var showOrHideInactive = this.state.showInactive ? 'Hide' : 'Include';\n\n      var collectorList = collectors.length > 0 ? this._formatCollectorList(collectors) : this._formatEmptyListAlert();\n\n      return _react2['default'].createElement(\n        _reactBootstrap.Row,\n        null,\n        _react2['default'].createElement(\n          _reactBootstrap.Col,\n          { md: 12 },\n          _react2['default'].createElement(\n            'a',\n            { onClick: this.toggleShowInactive, className: 'btn btn-primary pull-right' },\n            showOrHideInactive,\n            ' inactive collectors'\n          ),\n          _react2['default'].createElement(\n            'form',\n            { className: 'form-inline collectors-filter-form', onSubmit: function (evt) {\n                return evt.preventDefault();\n              } },\n            _react2['default'].createElement(\n              'div',\n              { className: 'form-group form-group-sm' },\n              _react2['default'].createElement(\n                'label',\n                { htmlFor: 'collectorsfilter', className: 'control-label' },\n                'Filter collectors:'\n              ),\n              _react2['default'].createElement('input', { type: 'text', name: 'filter', id: 'collectorsfilter', className: 'form-control', value: this.state.filter, onChange: function (event) {\n                  _this2.setState({ filter: event.target.value });\n                } })\n            )\n          ),\n          collectorList\n        )\n      );\n    }\n\n    return _react2['default'].createElement(_componentsCommon.Spinner, null);\n  }\n});\n\nexports['default'] = CollectorList;\nmodule.exports = exports['default'];\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"CollectorList.jsx\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/components/collectors/CollectorList.jsx\n ** module id = 558\n ** module chunks = 36\n **/\n//# sourceURL=webpack:///./src/components/collectors/CollectorList.jsx?")},559:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nObject.defineProperty(exports, '__esModule', {\n  value: true\n});\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _routingJsRoutes = __webpack_require__(9);\n\nvar _routingJsRoutes2 = _interopRequireDefault(_routingJsRoutes);\n\nvar _componentsCommon = __webpack_require__(4);\n\nvar CollectorRow = _react2['default'].createClass({\n  displayName: 'CollectorRow',\n\n  propTypes: {\n    collector: _react2['default'].PropTypes.object.isRequired\n  },\n  getInitialState: function getInitialState() {\n    return {\n      showRelativeTime: true\n    };\n  },\n  _getOsGlyph: function _getOsGlyph(operatingSystem) {\n    var glyphClass = 'fa-question-circle';\n    var os = operatingSystem.trim().toLowerCase();\n    if (os.indexOf('mac os') > -1) {\n      glyphClass = 'fa-apple';\n    }\n    if (os.indexOf('linux') > -1) {\n      glyphClass = 'fa-linux';\n    }\n    if (os.indexOf('win') > -1) {\n      glyphClass = 'fa-windows';\n    }\n\n    glyphClass += ' collector-os';\n\n    return _react2['default'].createElement('i', { className: 'fa ' + glyphClass });\n  },\n  render: function render() {\n    var collector = this.props.collector;\n    var collectorClass = collector.active ? '' : 'greyed-out inactive';\n    var style = {};\n    var annotation = collector.active ? '' : '(inactive)';\n    var osGlyph = this._getOsGlyph(collector.node_details.operating_system);\n    return _react2['default'].createElement(\n      'tr',\n      { className: collectorClass, style: style },\n      _react2['default'].createElement(\n        'td',\n        { className: 'limited' },\n        collector.node_id\n      ),\n      _react2['default'].createElement(\n        'td',\n        { className: 'limited' },\n        osGlyph,\n        collector.node_details.operating_system\n      ),\n      _react2['default'].createElement(\n        'td',\n        { className: 'limited' },\n        _react2['default'].createElement(_componentsCommon.Timestamp, { dateTime: collector.last_seen, relative: this.state.showRelativeTime })\n      ),\n      _react2['default'].createElement(\n        'td',\n        { className: 'limited' },\n        collector.id,\n        annotation\n      ),\n      _react2['default'].createElement(\n        'td',\n        { className: 'limited' },\n        collector.collector_version\n      ),\n      _react2['default'].createElement(\n        'td',\n        { className: 'limited' },\n        _react2['default'].createElement(\n          'a',\n          { href: _routingJsRoutes2['default'].controllers.SearchController.index('gl2_source_collector:' + collector.id, 'relative', 28800).url,\n            className: 'btn btn-info btn-xs' },\n          'Show messages from this collector'\n        )\n      )\n    );\n  }\n});\n\nexports['default'] = CollectorRow;\nmodule.exports = exports['default'];\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"CollectorRow.jsx\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/components/collectors/CollectorRow.jsx\n ** module id = 559\n ** module chunks = 36\n **/\n//# sourceURL=webpack:///./src/components/collectors/CollectorRow.jsx?")},669:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nObject.defineProperty(exports, '__esModule', {\n  value: true\n});\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _reactBootstrap = __webpack_require__(2);\n\nvar _utilDocsHelper = __webpack_require__(14);\n\nvar _utilDocsHelper2 = _interopRequireDefault(_utilDocsHelper);\n\nvar _componentsCommonPageHeader = __webpack_require__(41);\n\nvar _componentsCommonPageHeader2 = _interopRequireDefault(_componentsCommonPageHeader);\n\nvar _componentsCollectorsCollectorList = __webpack_require__(558);\n\nvar _componentsCollectorsCollectorList2 = _interopRequireDefault(_componentsCollectorsCollectorList);\n\nvar _componentsSupportDocumentationLink = __webpack_require__(28);\n\nvar _componentsSupportDocumentationLink2 = _interopRequireDefault(_componentsSupportDocumentationLink);\n\nvar CollectorsPage = _react2['default'].createClass({\n  displayName: 'CollectorsPage',\n\n  render: function render() {\n    return _react2['default'].createElement(\n      'span',\n      null,\n      _react2['default'].createElement(\n        _componentsCommonPageHeader2['default'],\n        { title: 'Collectors in Cluster' },\n        _react2['default'].createElement(\n          'span',\n          null,\n          'The Graylog collectors can reliably forward contents of log files or Windows EventLog from your servers.'\n        ),\n        _react2['default'].createElement(\n          'span',\n          null,\n          'Read more about collectors and how to set them up in the',\n          ' ',\n          _react2['default'].createElement(_componentsSupportDocumentationLink2['default'], { page: _utilDocsHelper2['default'].PAGES.COLLECTOR, text: 'Graylog documentation' }),\n          '.'\n        )\n      ),\n      _react2['default'].createElement(\n        _reactBootstrap.Row,\n        { className: 'content' },\n        _react2['default'].createElement(\n          _reactBootstrap.Col,\n          { md: 12 },\n          _react2['default'].createElement(_componentsCollectorsCollectorList2['default'], null)\n        )\n      )\n    );\n  }\n});\n\nexports['default'] = CollectorsPage;\nmodule.exports = exports['default'];\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"CollectorsPage.jsx\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./~/react-hot-loader!./~/babel-loader!./src/pages/CollectorsPage.jsx\n ** module id = 669\n ** module chunks = 36\n **/\n//# sourceURL=webpack:///./src/pages/CollectorsPage.jsx?./~/react-hot-loader!./~/babel-loader")}});