/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alerts;

import com.floreysoft.jmte.Engine;
import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.graylog2.alerts.AlertSender;
import org.graylog2.alerts.StaticEmailAlertSender;
import org.graylog2.configuration.EmailConfiguration;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.users.UserService;
import org.graylog2.streams.StreamRuleService;

public class FormattedEmailAlertSender
extends StaticEmailAlertSender
implements AlertSender {
    public static final String bodyTemplate = "##########\nAlert Description: ${check_result.resultDescription}\nDate: ${check_result.triggeredAt}\nStream ID: ${stream.id}\nStream title: ${stream.title}\nStream description: ${stream.description}\n${if stream_url}Stream URL: ${stream_url}${end}\n\nTriggered condition: ${check_result.triggeredCondition}\n##########\n\n${if backlog}Last messages accounting for this alert:\n${foreach backlog message}${message}\n\n${end}${else}<No backlog>\n${end}\n";
    private final Engine engine = new Engine();
    private Configuration pluginConfig;

    @Inject
    public FormattedEmailAlertSender(EmailConfiguration configuration, StreamRuleService streamRuleService, UserService userService, NotificationService notificationService, NodeId nodeId) {
        super(configuration, streamRuleService, userService, notificationService, nodeId);
    }

    @Override
    public void initialize(Configuration configuration) {
        this.pluginConfig = configuration;
        super.initialize(configuration);
    }

    @Override
    protected String buildSubject(Stream stream, AlertCondition.CheckResult checkResult, List<Message> backlog) {
        String template = this.pluginConfig == null || this.pluginConfig.getString("subject") == null ? "Graylog alert for stream: ${stream.title}: ${check_result.resultDescription}" : this.pluginConfig.getString("subject");
        Map<String, Object> model = this.getModel(stream, checkResult, backlog);
        Engine engine = new Engine();
        return engine.transform(template, model);
    }

    @Override
    protected String buildBody(Stream stream, AlertCondition.CheckResult checkResult, List<Message> backlog) {
        String template = this.pluginConfig == null || this.pluginConfig.getString("body") == null ? bodyTemplate : this.pluginConfig.getString("body");
        Map<String, Object> model = this.getModel(stream, checkResult, backlog);
        return this.engine.transform(template, model);
    }

    private Map<String, Object> getModel(Stream stream, AlertCondition.CheckResult checkResult, List<Message> backlog) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("stream", stream);
        model.put("check_result", checkResult);
        model.put("stream_url", this.buildStreamDetailsURL(this.configuration.getWebInterfaceUri(), checkResult, stream));
        List messages = (List)MoreObjects.firstNonNull(backlog, Collections.emptyList());
        model.put("backlog", messages);
        model.put("backlog_size", messages.size());
        return model;
    }
}

