/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.collectors;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import org.graylog2.collectors.AutoValue_CollectorImpl;
import org.graylog2.collectors.Collector;
import org.graylog2.collectors.CollectorNodeDetails;
import org.graylog2.database.CollectionName;
import org.graylog2.rest.models.collector.responses.CollectorSummary;
import org.joda.time.DateTime;

@JsonAutoDetect
@CollectionName(value="collectors")
public abstract class CollectorImpl
implements Collector {
    @Override
    @JsonProperty(value="id")
    public abstract String getId();

    @Override
    @JsonProperty(value="node_id")
    public abstract String getNodeId();

    @Override
    @JsonProperty(value="node_details")
    public abstract CollectorNodeDetails getNodeDetails();

    @Override
    @JsonProperty(value="collector_version")
    public abstract String getCollectorVersion();

    @Override
    public CollectorSummary toSummary(Function<Collector, Boolean> isActiveFunction) {
        Boolean isActive = (Boolean)isActiveFunction.apply((Object)this);
        return CollectorSummary.create(this.getId(), this.getNodeId(), this.getNodeDetails().toSummary(), this.getLastSeen(), this.getCollectorVersion(), isActive != null && isActive != false);
    }

    @Override
    @JsonProperty(value="last_seen")
    public abstract DateTime getLastSeen();

    @JsonCreator
    public static CollectorImpl create(@JsonProperty(value="_id") String objectId, @JsonProperty(value="id") String id, @JsonProperty(value="node_id") String nodeId, @JsonProperty(value="node_details") CollectorNodeDetails collectorNodeDetails, @JsonProperty(value="collector_version") String collectorVersion, @JsonProperty(value="last_seen") DateTime lastSeen) {
        return new AutoValue_CollectorImpl(id, nodeId, collectorNodeDetails, collectorVersion, lastSeen);
    }

    public static CollectorImpl create(String collectorId, String nodeId, String collectorVersion, CollectorNodeDetails collectorNodeDetails, DateTime lastSeen) {
        return new AutoValue_CollectorImpl(collectorId, nodeId, collectorNodeDetails, collectorVersion, lastSeen);
    }
}

