/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.converters.StringListConverter;
import com.github.joschi.jadconfig.util.Duration;
import com.github.joschi.jadconfig.validators.FilePathReadableValidator;
import com.github.joschi.jadconfig.validators.InetPortValidator;
import com.github.joschi.jadconfig.validators.PositiveDurationValidator;
import com.github.joschi.jadconfig.validators.PositiveIntegerValidator;
import com.github.joschi.jadconfig.validators.PositiveLongValidator;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import org.joda.time.Period;

public class ElasticsearchConfiguration {
    @Parameter(value="elasticsearch_cluster_name")
    private String clusterName = "graylog";
    @Parameter(value="elasticsearch_node_name_prefix")
    private String nodeNamePrefix = "graylog-";
    @Parameter(value="elasticsearch_node_master")
    private boolean masterNode = false;
    @Parameter(value="elasticsearch_node_data")
    private boolean dataNode = false;
    @Parameter(value="elasticsearch_path_data")
    private String pathData = "data/elasticsearch";
    @Parameter(value="elasticsearch_path_home")
    private String pathHome = "data/elasticsearch";
    @Parameter(value="elasticsearch_transport_tcp_port", validator=InetPortValidator.class)
    private int transportTcpPort = 9350;
    @Parameter(value="elasticsearch_http_enabled")
    private boolean httpEnabled = false;
    @Parameter(value="elasticsearch_discovery_zen_ping_multicast_enabled")
    private boolean multicastDiscovery = true;
    @Parameter(value="elasticsearch_discovery_zen_ping_unicast_hosts", converter=StringListConverter.class)
    private List<String> unicastHosts;
    @Parameter(value="elasticsearch_discovery_initial_state_timeout")
    private String initialStateTimeout = "3s";
    @Parameter(value="elasticsearch_network_host")
    private String networkHost;
    @Parameter(value="elasticsearch_network_bind_host")
    private String networkBindHost;
    @Parameter(value="elasticsearch_network_publish_host")
    private String networkPublishHost;
    @Parameter(value="elasticsearch_cluster_discovery_timeout", validator=PositiveLongValidator.class)
    private long clusterDiscoveryTimeout = 5000L;
    @Parameter(value="elasticsearch_disable_version_check")
    private boolean disableVersionCheck = false;
    @Parameter(value="elasticsearch_config_file", validator=FilePathReadableValidator.class)
    private Path configFile;
    @Parameter(value="elasticsearch_index_prefix", required=true)
    private String indexPrefix = "graylog";
    @Parameter(value="elasticsearch_max_number_of_indices", required=true, validator=PositiveIntegerValidator.class)
    private int maxNumberOfIndices = 20;
    @Parameter(value="elasticsearch_max_docs_per_index", validator=PositiveIntegerValidator.class, required=true)
    private int maxDocsPerIndex = 80000000;
    @Parameter(value="elasticsearch_max_size_per_index", validator=PositiveLongValidator.class, required=true)
    private long maxSizePerIndex = 0x40000000L;
    @Parameter(value="elasticsearch_max_time_per_index", required=true)
    private Period maxTimePerIndex = Period.days((int)1);
    @Parameter(value="elasticsearch_shards", validator=PositiveIntegerValidator.class, required=true)
    private int shards = 4;
    @Parameter(value="elasticsearch_replicas", validator=PositiveIntegerValidator.class, required=true)
    private int replicas = 0;
    @Parameter(value="elasticsearch_analyzer", required=true)
    private String analyzer = "standard";
    @Parameter(value="elasticsearch_template_name")
    private String templateName = "graylog-internal";
    @Parameter(value="no_retention")
    private boolean noRetention = false;
    @Parameter(value="retention_strategy", required=true)
    private String retentionStrategy = "delete";
    @Parameter(value="rotation_strategy")
    private String rotationStrategy = "count";
    @Parameter(value="disable_index_optimization")
    private boolean disableIndexOptimization = false;
    @Parameter(value="index_optimization_max_num_segments", validator=PositiveIntegerValidator.class)
    private int indexOptimizationMaxNumSegments = 1;
    @Parameter(value="elasticsearch_request_timeout", validator=PositiveDurationValidator.class)
    private Duration requestTimeout = Duration.minutes((long)1L);

    public String getClusterName() {
        return this.clusterName;
    }

    public String getNodeNamePrefix() {
        return this.nodeNamePrefix;
    }

    public boolean isMasterNode() {
        return this.masterNode;
    }

    public boolean isDataNode() {
        return this.dataNode;
    }

    public boolean isClientNode() {
        return !this.isDataNode();
    }

    public int getTransportTcpPort() {
        return this.transportTcpPort;
    }

    public boolean isHttpEnabled() {
        return this.httpEnabled;
    }

    public boolean isMulticastDiscovery() {
        return this.multicastDiscovery;
    }

    public List<String> getUnicastHosts() {
        return this.unicastHosts;
    }

    public String getInitialStateTimeout() {
        return this.initialStateTimeout;
    }

    public String getNetworkHost() {
        return this.networkHost;
    }

    public String getNetworkBindHost() {
        return this.networkBindHost;
    }

    public String getNetworkPublishHost() {
        return this.networkPublishHost;
    }

    public long getClusterDiscoveryTimeout() {
        return this.clusterDiscoveryTimeout;
    }

    public boolean isDisableVersionCheck() {
        return this.disableVersionCheck;
    }

    public Path getConfigFile() {
        return this.configFile;
    }

    public String getIndexPrefix() {
        return this.indexPrefix.toLowerCase(Locale.ENGLISH);
    }

    public int getMaxNumberOfIndices() {
        return this.maxNumberOfIndices;
    }

    public int getMaxDocsPerIndex() {
        return this.maxDocsPerIndex;
    }

    public long getMaxSizePerIndex() {
        return this.maxSizePerIndex;
    }

    public Period getMaxTimePerIndex() {
        return this.maxTimePerIndex;
    }

    public int getShards() {
        return this.shards;
    }

    public int getReplicas() {
        return this.replicas;
    }

    public String getAnalyzer() {
        return this.analyzer;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getRotationStrategy() {
        return this.rotationStrategy;
    }

    public boolean performRetention() {
        return !this.noRetention;
    }

    public void setPerformRetention(boolean retention) {
        this.noRetention = !retention;
    }

    public String getRetentionStrategy() {
        return this.retentionStrategy;
    }

    public int getIndexOptimizationMaxNumSegments() {
        return this.indexOptimizationMaxNumSegments;
    }

    public boolean isDisableIndexOptimization() {
        return this.disableIndexOptimization;
    }

    public String getPathData() {
        return this.pathData;
    }

    public String getPathHome() {
        return this.pathHome;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }
}

