/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.graylog2.dashboards.widgets.DashboardWidget;
import org.graylog2.dashboards.widgets.WidgetCacheTime;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.timeranges.TimeRange;

public abstract class ChartWidget
extends DashboardWidget {
    @Nullable
    protected final String streamId;
    protected final Searches.DateHistogramInterval interval;

    protected ChartWidget(MetricRegistry metricRegistry, DashboardWidget.Type type, String id, TimeRange timeRange, String description, WidgetCacheTime cacheTime, Map<String, Object> config, String creatorUserId) {
        super(metricRegistry, type, id, timeRange, description, cacheTime, config, creatorUserId);
        this.streamId = (String)config.get("stream_id");
        this.interval = config.containsKey("interval") ? Searches.DateHistogramInterval.valueOf(((String)config.get("interval")).toUpperCase(Locale.ENGLISH)) : Searches.DateHistogramInterval.MINUTE;
    }

    @Override
    public Map<String, Object> getPersistedConfig() {
        ImmutableMap.Builder persistedConfig = ImmutableMap.builder().putAll(super.getPersistedConfig()).put((Object)"interval", (Object)this.interval.toString().toLowerCase(Locale.ENGLISH));
        if (!Strings.isNullOrEmpty((String)this.streamId)) {
            persistedConfig.put((Object)"stream_id", (Object)this.streamId);
        }
        return persistedConfig.build();
    }
}

