/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.graylog2.dashboards.widgets.ComputationResult;
import org.graylog2.dashboards.widgets.WidgetCacheTime;
import org.graylog2.indexer.searches.timeranges.TimeRange;
import org.graylog2.plugin.database.EmbeddedPersistable;

public abstract class DashboardWidget
implements EmbeddedPersistable {
    public static final String FIELD_ID = "id";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_CACHE_TIME = "cache_time";
    public static final String FIELD_CREATOR_USER_ID = "creator_user_id";
    public static final String FIELD_CONFIG = "config";
    private final MetricRegistry metricRegistry;
    private final Type type;
    private final String id;
    private final TimeRange timeRange;
    private final Map<String, Object> config;
    private final String creatorUserId;
    private int cacheTime;
    private String description;
    private Supplier<ComputationResult> cachedResult;

    protected DashboardWidget(MetricRegistry metricRegistry, Type type, String id, TimeRange timeRange, String description, WidgetCacheTime cacheTime, Map<String, Object> config, String creatorUserId) {
        this.metricRegistry = metricRegistry;
        this.type = type;
        this.id = id;
        this.timeRange = timeRange;
        this.config = config;
        this.creatorUserId = creatorUserId;
        this.description = description;
        this.cacheTime = cacheTime.getCacheTime();
        this.cachedResult = Suppliers.memoizeWithExpiration((Supplier)new ComputationResultSupplier(), (long)this.cacheTime, (TimeUnit)TimeUnit.SECONDS);
    }

    public Type getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCacheTime(int cacheTime) {
        this.cacheTime = cacheTime;
        this.cachedResult = Suppliers.memoizeWithExpiration((Supplier)new ComputationResultSupplier(), (long)this.cacheTime, (TimeUnit)TimeUnit.SECONDS);
    }

    public int getCacheTime() {
        return this.cacheTime;
    }

    public TimeRange getTimeRange() {
        Preconditions.checkArgument((this.timeRange != null ? 1 : 0) != 0, (Object)"Invalid time range provided");
        return this.timeRange;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public String getCreatorUserId() {
        return this.creatorUserId;
    }

    public Map<String, Object> getPersistedFields() {
        return ImmutableMap.builder().put((Object)FIELD_ID, (Object)this.id).put((Object)FIELD_TYPE, (Object)this.type.toString().toLowerCase(Locale.ENGLISH)).put((Object)FIELD_DESCRIPTION, (Object)this.description).put((Object)FIELD_CACHE_TIME, (Object)this.cacheTime).put((Object)FIELD_CREATOR_USER_ID, (Object)this.creatorUserId).put((Object)FIELD_CONFIG, this.getPersistedConfig()).build();
    }

    public ComputationResult getComputationResult() throws ExecutionException {
        return (ComputationResult)this.cachedResult.get();
    }

    public Map<String, Object> getPersistedConfig() {
        return ImmutableMap.of((Object)"timerange", this.getTimeRange().getPersistedConfig());
    }

    protected abstract ComputationResult compute();

    private Timer getCalculationTimer() {
        return this.metricRegistry.timer(MetricRegistry.name(this.getClass(), (String[])new String[]{this.getId(), "calculationTime"}));
    }

    private Meter getCalculationMeter() {
        return this.metricRegistry.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{this.getId(), "calculations"}));
    }

    private class ComputationResultSupplier
    implements Supplier<ComputationResult> {
        private ComputationResultSupplier() {
        }

        /*
         * Loose catch block
         */
        public ComputationResult get() {
            try {
                try (Timer.Context timer = DashboardWidget.this.getCalculationTimer().time();){
                    ComputationResult computationResult = DashboardWidget.this.compute();
                    return computationResult;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                DashboardWidget.this.getCalculationMeter().mark();
            }
        }
    }

    public static class NoSuchWidgetTypeException
    extends Exception {
        public NoSuchWidgetTypeException() {
        }

        public NoSuchWidgetTypeException(String msg) {
            super(msg);
        }
    }

    public static enum Type {
        SEARCH_RESULT_COUNT,
        STREAM_SEARCH_RESULT_COUNT,
        FIELD_CHART,
        QUICKVALUES,
        SEARCH_RESULT_CHART,
        STATS_COUNT,
        STACKED_CHART;

    }
}

