/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import org.graylog2.dashboards.widgets.ChartWidget;
import org.graylog2.dashboards.widgets.ComputationResult;
import org.graylog2.dashboards.widgets.DashboardWidget;
import org.graylog2.dashboards.widgets.InvalidWidgetConfigurationException;
import org.graylog2.dashboards.widgets.WidgetCacheTime;
import org.graylog2.indexer.results.HistogramResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.timeranges.TimeRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldChartWidget
extends ChartWidget {
    private static final Logger LOG = LoggerFactory.getLogger(FieldChartWidget.class);
    private final String query;
    private final String field;
    private final String statisticalFunction;
    private final String renderer;
    private final String interpolation;
    private final Searches searches;

    public FieldChartWidget(MetricRegistry metricRegistry, Searches searches, String id, String description, WidgetCacheTime cacheTime, Map<String, Object> config, String query, TimeRange timeRange, String creatorUserId) throws InvalidWidgetConfigurationException {
        super(metricRegistry, DashboardWidget.Type.FIELD_CHART, id, timeRange, description, cacheTime, config, creatorUserId);
        this.searches = searches;
        if (!this.checkConfig(config)) {
            throw new InvalidWidgetConfigurationException("Missing or invalid widget configuration. Provided config was: " + config.toString());
        }
        this.query = query == null || query.trim().isEmpty() ? "*" : query;
        this.field = (String)config.get("field");
        this.statisticalFunction = (String)config.get("valuetype");
        this.renderer = (String)config.get("renderer");
        this.interpolation = (String)config.get("interpolation");
    }

    @Override
    public Map<String, Object> getPersistedConfig() {
        ImmutableMap.Builder persistedConfig = ImmutableMap.builder().putAll(super.getPersistedConfig()).put((Object)"query", (Object)this.query).put((Object)"field", (Object)this.field).put((Object)"valuetype", (Object)this.statisticalFunction).put((Object)"renderer", (Object)this.renderer).put((Object)"interpolation", (Object)this.interpolation);
        return persistedConfig.build();
    }

    @Override
    protected ComputationResult compute() {
        String filter = null;
        if (!Strings.isNullOrEmpty((String)this.streamId)) {
            filter = "streams:" + this.streamId;
        }
        try {
            HistogramResult histogramResult = this.searches.fieldHistogram(this.query, this.field, Searches.DateHistogramInterval.valueOf(this.interval.toString().toUpperCase(Locale.ENGLISH)), filter, this.getTimeRange(), "cardinality".equalsIgnoreCase(this.statisticalFunction));
            return new ComputationResult(histogramResult.getResults(), histogramResult.took().millis(), histogramResult.getHistogramBoundaries());
        }
        catch (Searches.FieldTypeException e) {
            String msg = "Could not calculate [" + this.getClass().getCanonicalName() + "] widget <" + this.getId() + ">. Not a numeric field? The field was [" + this.field + "]";
            LOG.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    private boolean checkConfig(Map<String, Object> config) {
        return config.containsKey("field") && config.containsKey("valuetype") && config.containsKey("renderer") && config.containsKey("interpolation") && config.containsKey("interval");
    }
}

