/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.graylog2.dashboards.widgets.ChartWidget;
import org.graylog2.dashboards.widgets.ComputationResult;
import org.graylog2.dashboards.widgets.DashboardWidget;
import org.graylog2.dashboards.widgets.InvalidWidgetConfigurationException;
import org.graylog2.dashboards.widgets.WidgetCacheTime;
import org.graylog2.indexer.results.HistogramResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.indexer.searches.timeranges.TimeRange;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackedChartWidget
extends ChartWidget {
    private static final Logger LOG = LoggerFactory.getLogger(StackedChartWidget.class);
    private final String renderer;
    private final String interpolation;
    private final List<Series> chartSeries;
    private final Searches searches;

    public StackedChartWidget(MetricRegistry metricRegistry, Searches searches, String id, String description, WidgetCacheTime cacheTime, Map<String, Object> config, TimeRange timeRange, String creatorUserId) throws InvalidWidgetConfigurationException {
        super(metricRegistry, DashboardWidget.Type.STACKED_CHART, id, timeRange, description, cacheTime, config, creatorUserId);
        this.searches = searches;
        if (!this.checkConfig(config)) {
            throw new InvalidWidgetConfigurationException("Missing or invalid widget configuration. Provided config was: " + config.toString());
        }
        this.renderer = (String)config.get("renderer");
        this.interpolation = (String)config.get("interpolation");
        Object persistedSeries = config.get("series");
        if (persistedSeries instanceof List) {
            List chartSeries = (List)persistedSeries;
            this.chartSeries = new ArrayList<Series>(chartSeries.size());
            for (Object series : chartSeries) {
                this.chartSeries.add(Series.fromMap((Map)series));
            }
        } else {
            throw new InvalidWidgetConfigurationException("Invalid widget configuration, 'series' should be a list: " + config.toString());
        }
    }

    @Override
    public Map<String, Object> getPersistedConfig() {
        ImmutableList.Builder seriesBuilder = ImmutableList.builder();
        for (Series series : this.chartSeries) {
            seriesBuilder.add(series.toMap());
        }
        ImmutableMap.Builder persistedConfig = ImmutableMap.builder().putAll(super.getPersistedConfig()).put((Object)"renderer", (Object)this.renderer).put((Object)"interpolation", (Object)this.interpolation).put((Object)"series", (Object)seriesBuilder.build());
        return persistedConfig.build();
    }

    @Override
    protected ComputationResult compute() {
        String filter = null;
        if (!Strings.isNullOrEmpty((String)this.streamId)) {
            filter = "streams:" + this.streamId;
        }
        ArrayList<Map> results = new ArrayList<Map>(this.chartSeries.size());
        DateTime from = null;
        DateTime to = null;
        long tookMs = 0L;
        for (Series series : this.chartSeries) {
            try {
                HistogramResult histogramResult = this.searches.fieldHistogram(series.query, series.field, Searches.DateHistogramInterval.valueOf(this.interval.toString().toUpperCase(Locale.ENGLISH)), filter, this.getTimeRange(), "cardinality".equalsIgnoreCase(series.statisticalFunction));
                if (from == null) {
                    from = histogramResult.getHistogramBoundaries().getFrom();
                }
                to = histogramResult.getHistogramBoundaries().getTo();
                results.add(histogramResult.getResults());
                tookMs += histogramResult.took().millis();
            }
            catch (Searches.FieldTypeException e) {
                String msg = "Could not calculate [" + this.getClass().getCanonicalName() + "] widget <" + this.getId() + ">. Not a numeric field? The field was [" + series.field + "]";
                LOG.error(msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
        }
        AbsoluteRange computationTimeRange = AbsoluteRange.create(from, to);
        return new ComputationResult(results, tookMs, computationTimeRange);
    }

    private boolean checkConfig(Map<String, Object> config) {
        return config.containsKey("renderer") && config.containsKey("interpolation") && config.containsKey("interval") && config.containsKey("series");
    }

    private static class Series {
        final String field;
        final String query;
        final String statisticalFunction;

        public static Series fromMap(Map<String, Object> fields) {
            return new Series((String)fields.get("query"), (String)fields.get("field"), (String)fields.get("statistical_function"));
        }

        Series(String query, String field, String statisticalFunction) {
            this.query = query == null || query.trim().isEmpty() ? "*" : query;
            this.field = field;
            this.statisticalFunction = statisticalFunction;
        }

        public Map<String, Object> toMap() {
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder().put((Object)"query", (Object)this.query).put((Object)"field", (Object)this.field).put((Object)"statistical_function", (Object)this.statisticalFunction);
            return mapBuilder.build();
        }
    }
}

