/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database;

import com.github.zafarkhaja.semver.Version;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.mongodb.BasicDBList;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.configuration.MongoDbConfiguration;
import org.graylog2.database.MongoConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MongoConnectionImpl
implements MongoConnection {
    private static final Logger LOG = LoggerFactory.getLogger(MongoConnectionImpl.class);
    private static final Version MINIMUM_MONGODB_VERSION = Version.forIntegers((int)2, (int)4);
    private final MongoClientURI mongoClientURI;
    private MongoClient m = null;
    private DB db = null;

    @Inject
    public MongoConnectionImpl(MongoDbConfiguration configuration) {
        this(configuration.getMongoClientURI());
    }

    MongoConnectionImpl(MongoClientURI mongoClientURI) {
        this.mongoClientURI = (MongoClientURI)Preconditions.checkNotNull((Object)mongoClientURI);
    }

    @Override
    public synchronized Mongo connect() {
        if (this.m == null) {
            String dbName = this.mongoClientURI.getDatabase();
            if (Strings.isNullOrEmpty((String)dbName)) {
                LOG.error("The MongoDB database name must not be null or empty (mongodb_uri was: {})", (Object)this.mongoClientURI);
                throw new RuntimeException("MongoDB database name is missing.");
            }
            this.m = new MongoClient(this.mongoClientURI);
            this.db = this.m.getDB(dbName);
            this.db.setWriteConcern(WriteConcern.SAFE);
        }
        try {
            this.db.command("{ ping: 1 }");
        }
        catch (MongoCommandException e) {
            if (e.getCode() == 18) {
                throw new MongoException("Couldn't connect to MongoDB. Please check the authentication credentials.", (Throwable)e);
            }
            throw new MongoException("Couldn't connect to MongoDB: " + e.getMessage(), (Throwable)e);
        }
        Version mongoVersion = this.getMongoVersion(this.m.getDB("admin"));
        if (mongoVersion != null && mongoVersion.lessThan(MINIMUM_MONGODB_VERSION)) {
            LOG.warn("You're running MongoDB {} but Graylog requires at least MongoDB {}. Please upgrade.", (Object)mongoVersion, (Object)MINIMUM_MONGODB_VERSION);
        }
        return this.m;
    }

    @Nullable
    private Version getMongoVersion(DB adminDb) {
        CommandResult buildInfoResult = adminDb.command("buildInfo");
        if (buildInfoResult.ok()) {
            BasicDBList versionArray = (BasicDBList)buildInfoResult.get("versionArray");
            if (versionArray == null || versionArray.size() < 3) {
                LOG.debug("Couldn't retrieve MongoDB version");
                return null;
            }
            int majorVersion = (Integer)versionArray.get(0);
            int minorVersion = (Integer)versionArray.get(1);
            int patchVersion = (Integer)versionArray.get(2);
            return Version.forIntegers((int)majorVersion, (int)minorVersion, (int)patchVersion);
        }
        LOG.debug("Couldn't retrieve MongoDB buildInfo: {}", (Object)buildInfoResult.getErrorMessage());
        return null;
    }

    @Override
    public DB getDatabase() {
        return this.db;
    }
}

