/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.events;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.DeadEvent;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import javax.inject.Inject;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.events.ClusterEvent;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.utilities.AutoValueUtils;
import org.mongojack.DBCursor;
import org.mongojack.DBSort;
import org.mongojack.DBUpdate;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterEventPeriodical
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterEventPeriodical.class);
    @VisibleForTesting
    static final String COLLECTION_NAME = "cluster_events";
    private final JacksonDBCollection<ClusterEvent, String> dbCollection;
    private final NodeId nodeId;
    private final ObjectMapper objectMapper;
    private final EventBus serverEventBus;

    @Inject
    public ClusterEventPeriodical(MongoJackObjectMapperProvider mapperProvider, MongoConnection mongoConnection, NodeId nodeId, ObjectMapper objectMapper, EventBus serverEventBus, @ClusterEventBus EventBus clusterEventBus) {
        this((JacksonDBCollection<ClusterEvent, String>)JacksonDBCollection.wrap((DBCollection)ClusterEventPeriodical.prepareCollection(mongoConnection), ClusterEvent.class, String.class, (ObjectMapper)mapperProvider.get()), nodeId, objectMapper, serverEventBus, clusterEventBus);
    }

    ClusterEventPeriodical(JacksonDBCollection<ClusterEvent, String> dbCollection, NodeId nodeId, ObjectMapper objectMapper, EventBus serverEventBus, EventBus clusterEventBus) {
        this.nodeId = (NodeId)Preconditions.checkNotNull((Object)nodeId);
        this.dbCollection = (JacksonDBCollection)Preconditions.checkNotNull(dbCollection);
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper);
        this.serverEventBus = (EventBus)Preconditions.checkNotNull((Object)serverEventBus);
        ((EventBus)Preconditions.checkNotNull((Object)clusterEventBus)).register((Object)this);
    }

    @VisibleForTesting
    static DBCollection prepareCollection(MongoConnection mongoConnection) {
        DB db = mongoConnection.getDatabase();
        DBCollection coll = db.getCollection(COLLECTION_NAME);
        coll.createIndex((DBObject)DBSort.asc((String)"timestamp").asc("producer").asc("consumers"));
        coll.setWriteConcern(WriteConcern.JOURNALED);
        return coll;
    }

    public boolean runsForever() {
        return false;
    }

    public boolean stopOnGracefulShutdown() {
        return true;
    }

    public boolean masterOnly() {
        return false;
    }

    public boolean startOnThisNode() {
        return true;
    }

    public boolean isDaemon() {
        return true;
    }

    public int getInitialDelaySeconds() {
        return 0;
    }

    public int getPeriodSeconds() {
        return 1;
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void doRun() {
        try {
            LOG.debug("Opening MongoDB cursor on \"{}\"", (Object)COLLECTION_NAME);
            DBCursor<ClusterEvent> cursor = this.eventCursor(this.nodeId);
            if (LOG.isTraceEnabled()) {
                LOG.trace("MongoDB query plan: {}", (Object)cursor.explain());
            }
            while (cursor.hasNext()) {
                ClusterEvent clusterEvent = (ClusterEvent)cursor.next();
                LOG.trace("Processing cluster event: {}", (Object)clusterEvent);
                Object payload = this.extractPayload(clusterEvent.payload(), clusterEvent.eventClass());
                if (payload != null) {
                    this.serverEventBus.post(payload);
                } else {
                    LOG.warn("Couldn't extract payload of cluster event with ID <{}>", (Object)clusterEvent.id());
                    LOG.debug("Invalid payload in cluster event: {}", (Object)clusterEvent);
                }
                this.updateConsumers(clusterEvent.id(), this.nodeId);
            }
        }
        catch (Exception e) {
            LOG.warn("Error while reading cluster events from MongoDB, retrying.", (Throwable)e);
        }
    }

    @Subscribe
    public void publishClusterEvent(Object event) {
        if (event instanceof DeadEvent) {
            LOG.debug("Skipping DeadEvent on cluster event bus");
            return;
        }
        String className = AutoValueUtils.getCanonicalName(event.getClass());
        ClusterEvent clusterEvent = ClusterEvent.create(this.nodeId.toString(), className, event);
        try {
            String id = (String)this.dbCollection.save((Object)clusterEvent, WriteConcern.JOURNALED).getSavedId();
            LOG.debug("Published cluster event with ID <{}> and type <{}>", (Object)id, (Object)className);
        }
        catch (MongoException e) {
            LOG.error("Couldn't publish cluster event of type <" + className + ">", (Throwable)e);
        }
    }

    private DBCursor<ClusterEvent> eventCursor(NodeId nodeId) {
        BasicDBObject producerClause = new BasicDBObject("producer", (Object)new BasicDBObject("$ne", (Object)nodeId.toString()));
        BasicDBList consumersList = new BasicDBList();
        consumersList.add((Object)nodeId.toString());
        BasicDBObject consumersClause = new BasicDBObject("consumers", (Object)new BasicDBObject("$nin", (Object)consumersList));
        BasicDBList and = new BasicDBList();
        and.add((Object)producerClause);
        and.add((Object)consumersClause);
        BasicDBObject query = new BasicDBObject("$and", (Object)and);
        return this.dbCollection.find((DBObject)query).sort((DBObject)DBSort.asc((String)"timestamp"));
    }

    private void updateConsumers(String eventId, NodeId nodeId) {
        WriteResult writeResult = this.dbCollection.updateById((Object)eventId, DBUpdate.addToSet((String)"consumers", (Object)nodeId.toString()));
    }

    private Object extractPayload(Object payload, String eventClass) {
        try {
            Class<?> clazz = Class.forName(eventClass);
            return this.objectMapper.convertValue(payload, clazz);
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Couldn't load class <" + eventClass + "> for event", (Throwable)e);
            return null;
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Error while deserializing payload", (Throwable)e);
            return null;
        }
    }
}

